/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datagen;

import com.denfop.api.Recipes;
import com.denfop.api.crafting.BaseRecipe;
import com.denfop.api.crafting.BaseShapelessRecipe;
import com.denfop.datagen.ShapedRecipeBuilder;
import com.denfop.datagen.ShapelessRecipeBuilder;
import com.denfop.datagen.furnace.FurnaceProvider;
import com.denfop.datagen.furnace.FurnaceRecipe;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipes.BaseRecipes;
import com.denfop.recipes.FurnaceRecipes;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public class RecipeProvider
extends VanillaRecipeProvider {
    public static int ID = 0;

    public RecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput p_301191_) {
        BaseRecipes.init();
        Map<String, Recipe> map = Recipes.getRecipeMap();
        for (Map.Entry<String, Recipe> entry : map.entrySet()) {
            String id = entry.getKey();
            Recipe recipe = entry.getValue();
            try {
                Object shaped;
                if (recipe instanceof BaseRecipe) {
                    BaseRecipe baseRecipe = (BaseRecipe)recipe;
                    shaped = ShapedRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)baseRecipe.getOutput().getItem(), baseRecipe.getOutput().getCount());
                    baseRecipe.getRecipeGrid().getGrids().get(0).forEach(((ShapedRecipeBuilder)shaped)::pattern);
                    ((ShapedRecipeBuilder)shaped).add(baseRecipe);
                    ((ShapedRecipeBuilder)shaped).unlockedBy("any", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.AIR}));
                    Recipes.registerRecipe(p_301191_, (RecipeBuilder)shaped, id.toLowerCase());
                    continue;
                }
                if (!(recipe instanceof BaseShapelessRecipe)) continue;
                BaseShapelessRecipe baseShapelessRecipe = (BaseShapelessRecipe)recipe;
                shaped = ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, (ItemLike)baseShapelessRecipe.getOutput().getItem(), baseShapelessRecipe.getOutput().getCount());
                ((ShapelessRecipeBuilder)shaped).add(baseShapelessRecipe);
                for (IInputItemStack recipeInput : baseShapelessRecipe.getRecipeInputList()) {
                    if (recipeInput.getInputs().size() == 1 && !recipeInput.getInputs().get(0).getComponents().isEmpty()) {
                        HolderSet.Direct holders = HolderSet.direct((Holder[])new Holder[]{recipeInput.getInputs().get(0).getItemHolder()});
                        ((ShapelessRecipeBuilder)shaped).requires(new DataComponentIngredient((HolderSet)holders, DataComponentPredicate.allOf((DataComponentMap)recipeInput.getInputs().get(0).getComponents()), false).toVanilla());
                        continue;
                    }
                    if (recipeInput instanceof InputOreDict) {
                        ((ShapelessRecipeBuilder)shaped).requires(Ingredient.of(recipeInput.getTag()));
                        continue;
                    }
                    ((ShapelessRecipeBuilder)shaped).requires(Ingredient.of((ItemStack[])recipeInput.getInputs().toArray(new ItemStack[0])));
                }
                ((ShapelessRecipeBuilder)shaped).unlockedBy("any", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.AIR}));
                Recipes.registerRecipe(p_301191_, (RecipeBuilder)shaped, id.toLowerCase());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        FurnaceRecipes.recipe();
        FurnaceProvider.furnaceRecipeList = new ArrayList<FurnaceRecipe>(FurnaceProvider.furnaceRecipeList);
        for (FurnaceRecipe furnaceRecipe : FurnaceProvider.furnaceRecipeList) {
            SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{furnaceRecipe.getInput()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)furnaceRecipe.getOutput().getItem(), (float)furnaceRecipe.getXp(), (int)200).unlockedBy("any", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.AIR})).save(p_301191_, "industrialupgrade:furnace_" + ID++);
        }
    }
}

