/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.entity;

import com.denfop.entity.SmallBee;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

class ReturnToHiveGoal
extends Goal {
    private final SmallBee bee;

    public ReturnToHiveGoal(SmallBee bee) {
        this.bee = bee;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.bee.getCustomHive() == null) {
            return true;
        }
        return this.bee.hasCustomNectar() && this.bee.getCustomHive() != null;
    }

    public void start() {
        BlockPos hive = this.bee.getCustomHive();
        this.bee.getNavigation().moveTo((double)hive.getX() + 0.5, (double)hive.getY() + 1.0, (double)hive.getZ() + 0.5, 0.5);
    }

    public void tick() {
        if (this.bee.getCustomHive() == null || this.bee.tickCount >= 200) {
            this.bee.discard();
            return;
        }
        if (this.bee.getCustomHive() != null && this.bee.position().distanceTo(Vec3.atCenterOf((Vec3i)this.bee.getCustomHive())) < 1.75) {
            this.bee.setHasCustomNectar(false);
            this.bee.discard();
        } else if (this.bee.getCustomHive() != null) {
            this.bee.pathfindRandomlyTowards(this.bee.getCustomHive().above());
        }
    }

    public boolean canContinueToUse() {
        return this.bee.hasCustomNectar();
    }
}

