/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUCore;
import com.denfop.api.gasvein.GasVein;
import com.denfop.api.gasvein.GasVeinSystem;
import com.denfop.api.guidebook.GuideBookCore;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.Data;
import com.denfop.api.space.fakebody.FakeAsteroid;
import com.denfop.api.space.fakebody.FakePlanet;
import com.denfop.api.space.fakebody.FakeSatellite;
import com.denfop.api.space.fakebody.IFakeAsteroid;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.IFakePlanet;
import com.denfop.api.space.fakebody.IFakeSatellite;
import com.denfop.api.vein.Vein;
import com.denfop.api.vein.VeinSystem;
import com.denfop.items.relocator.RelocatorNetwork;
import com.denfop.render.streak.PlayerStreakInfo;
import com.denfop.tiles.quarry_earth.TileEntityEarthQuarryController;
import com.denfop.world.GenData;
import com.denfop.world.WorldGenGas;
import com.denfop.world.vein.AlgorithmVein;
import com.denfop.world.vein.noise.Point;
import com.denfop.world.vein.noise.ShellCluster;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class WorldSavedDataIU
extends SavedData {
    public int col;
    Level world;
    private CompoundTag tagCompound = new CompoundTag();

    public WorldSavedDataIU() {
    }

    public WorldSavedDataIU(String name) {
    }

    public static WorldSavedDataIU create() {
        return new WorldSavedDataIU();
    }

    public static WorldSavedDataIU load(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        WorldSavedDataIU dataIU = WorldSavedDataIU.create();
        dataIU.readNBT(compound, lookupProvider);
        return dataIU;
    }

    public static void loadShellClusterChunks(CompoundTag tag) {
        HashMap result = new HashMap();
        ShellCluster cluster = new ShellCluster();
        cluster.point = new Point(tag.getCompound("volcano").getInt("x"), tag.getCompound("volcano").getInt("z"));
        AlgorithmVein.volcano = cluster;
        ListTag outerList = tag.getList("shellClusterChunks", 10);
        for (int i = 0; i < outerList.size(); ++i) {
            CompoundTag outerTag = outerList.getCompound(i);
            int outerKey = outerTag.getInt("outer");
            HashMap<Integer, Tuple> innerMap = new HashMap<Integer, Tuple>();
            ListTag innerList = outerTag.getList("innerList", 10);
            for (int j = 0; j < innerList.size(); ++j) {
                CompoundTag innerTag = innerList.getCompound(j);
                int innerKey = innerTag.getInt("inner");
                int r = innerTag.getInt("r");
                int g = innerTag.getInt("g");
                int b = innerTag.getInt("b");
                int a = innerTag.getInt("a");
                int value = innerTag.getInt("value");
                Color color = new Color(r, g, b, a);
                innerMap.put(innerKey, new Tuple((Object)color, (Object)value));
            }
            result.put(outerKey, innerMap);
        }
        AlgorithmVein.shellClusterChuncks = !result.isEmpty() ? Collections.unmodifiableMap(result) : new HashMap<Integer, Map<Integer, Tuple<Color, Integer>>>();
    }

    public static CompoundTag saveShellClusterChunks() {
        CompoundTag tag = new CompoundTag();
        ListTag outerList = new ListTag();
        CompoundTag volcanoTag = new CompoundTag();
        if (AlgorithmVein.volcano != null) {
            volcanoTag.putInt("x", (int)AlgorithmVein.volcano.point.x);
            volcanoTag.putInt("z", (int)AlgorithmVein.volcano.point.y);
            tag.put("volcano", (Tag)volcanoTag);
        }
        for (Map.Entry<Integer, Map<Integer, Tuple<Color, Integer>>> outer : AlgorithmVein.shellClusterChuncks.entrySet()) {
            int outerKey = outer.getKey();
            CompoundTag outerTag = new CompoundTag();
            outerTag.putInt("outer", outerKey);
            ListTag innerList = new ListTag();
            for (Map.Entry<Integer, Tuple<Color, Integer>> inner : outer.getValue().entrySet()) {
                int innerKey = inner.getKey();
                Tuple<Color, Integer> tuple = inner.getValue();
                Color color = (Color)tuple.getA();
                int number = (Integer)tuple.getB();
                CompoundTag innerTag = new CompoundTag();
                innerTag.putInt("inner", innerKey);
                innerTag.putInt("r", color.getRed());
                innerTag.putInt("g", color.getGreen());
                innerTag.putInt("b", color.getBlue());
                innerTag.putInt("a", color.getAlpha());
                innerTag.putInt("value", number);
                innerList.add((Object)innerTag);
            }
            outerTag.put("innerList", (Tag)innerList);
            outerList.add((Object)outerTag);
        }
        tag.put("shellClusterChunks", (Tag)outerList);
        return tag;
    }

    public void readNBT(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        int i;
        SpaceNet.instance.getFakeSpaceSystem().unload();
        if (compound.contains("shells")) {
            AlgorithmVein.shellClusterChuncks.clear();
            WorldSavedDataIU.loadShellClusterChunks(compound.getCompound("shells"));
        }
        if (compound.contains("fakePlayers")) {
            ListTag fakePlayersList = compound.getList("fakePlayers", 10);
            for (i = 0; i < fakePlayersList.size(); ++i) {
                CompoundTag nbt = fakePlayersList.getCompound(i);
                UUID name = nbt.getUUID("name");
                ListTag fakesBody = nbt.getList("fakesBody", 10);
                ListTag dataBody = nbt.getList("dataBody", 10);
                HashMap<IBody, Data> map = new HashMap<IBody, Data>();
                for (int ii = 0; ii < dataBody.size(); ++ii) {
                    CompoundTag nbt1 = dataBody.getCompound(ii);
                    Data data = new Data(nbt1.getCompound("data"));
                    map.put(data.getBody(), data);
                }
                SpaceNet.instance.getFakeSpaceSystem().addDataBody(name, map);
                LinkedList<IFakeBody> fakeBodies = new LinkedList<IFakeBody>();
                for (int ii = 0; ii < fakesBody.size(); ++ii) {
                    IFakeBody fakePlanet;
                    CompoundTag nbt1 = fakesBody.getCompound(ii);
                    byte id = nbt1.getByte("id");
                    if (id == 0) {
                        fakePlanet = new FakePlanet(nbt1, lookupProvider);
                        fakeBodies.add(fakePlanet);
                        SpaceNet.instance.getFakeSpaceSystem().addFakePlanet((FakePlanet)fakePlanet);
                        SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(((FakePlanet)fakePlanet).getPlayer()).put(((FakePlanet)fakePlanet).getPlanet(), ((FakePlanet)fakePlanet).getSpaceOperation());
                    }
                    if (id == 1) {
                        fakePlanet = new FakeSatellite(nbt1, lookupProvider);
                        fakeBodies.add(fakePlanet);
                        SpaceNet.instance.getFakeSpaceSystem().addFakeSatellite((FakeSatellite)fakePlanet);
                        SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(((FakeSatellite)fakePlanet).getPlayer()).put(((FakeSatellite)fakePlanet).getSatellite(), ((FakeSatellite)fakePlanet).getSpaceOperation());
                    }
                    if (id != 2) continue;
                    fakePlanet = new FakeAsteroid(nbt1, lookupProvider);
                    fakeBodies.add(fakePlanet);
                    SpaceNet.instance.getFakeSpaceSystem().addFakeAsteroid((FakeAsteroid)fakePlanet);
                    SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(((FakeAsteroid)fakePlanet).getPlayer()).put(((FakeAsteroid)fakePlanet).getAsteroid(), ((FakeAsteroid)fakePlanet).getSpaceOperation());
                }
                SpaceNet.instance.getFakeSpaceSystem().getBodyMap().put(name, new ArrayList(fakeBodies));
            }
        }
        VeinSystem.system.unload();
        if (compound.contains("veins")) {
            ListTag veinsList = compound.getList("veins", 10);
            for (i = 0; i < veinsList.size(); ++i) {
                CompoundTag veinTag = veinsList.getCompound(i);
                VeinSystem.system.addVein(veinTag);
            }
        }
        SpaceNet.instance.getColonieNet().unload();
        if (compound.contains("colonies")) {
            ListTag coloniesList = compound.getList("colonies", 10);
            for (i = 0; i < coloniesList.size(); ++i) {
                CompoundTag colonyTag = coloniesList.getCompound(i);
                SpaceNet.instance.getColonieNet().addColony(colonyTag, lookupProvider);
            }
        }
        RadiationSystem.rad_system.clear();
        if (compound.contains("radiations")) {
            ListTag radiationsList = compound.getList("radiations", 10);
            for (i = 0; i < radiationsList.size(); ++i) {
                CompoundTag radiationTag = radiationsList.getCompound(i);
                RadiationSystem.rad_system.addRadiation(radiationTag);
            }
        }
        IUCore.mapStreakInfo.clear();
        if (compound.contains("streaks")) {
            ListTag streaksList = compound.getList("streaks", 10);
            for (i = 0; i < streaksList.size(); ++i) {
                CompoundTag streakTag = streaksList.getCompound(i);
                String nick = streakTag.getString("nick");
                PlayerStreakInfo streakInfo = new PlayerStreakInfo(streakTag.getCompound("streak"));
                IUCore.mapStreakInfo.putIfAbsent(nick, streakInfo);
            }
        }
        if (compound.contains("pollution")) {
            CompoundTag pollutionTag = compound.getCompound("pollution");
            PollutionManager.pollutionManager.loadData(pollutionTag);
        }
        TileEntityEarthQuarryController.chunkPos.clear();
        if (compound.contains("earth_quarry")) {
            ListTag earthQuarryList = compound.getList("earth_quarry", 10);
            for (i = 0; i < earthQuarryList.size(); ++i) {
                CompoundTag chunkTag = earthQuarryList.getCompound(i);
                int x = chunkTag.getInt("x");
                int z = chunkTag.getInt("z");
                TileEntityEarthQuarryController.chunkPos.add(new ChunkPos(x, z));
            }
        }
        WorldGenGas.gasMap.clear();
        if (compound.contains("gen_gas")) {
            ListTag gasMapList = compound.getList("gen_gas", 10);
            for (i = 0; i < gasMapList.size(); ++i) {
                CompoundTag gasTag = gasMapList.getCompound(i);
                int x = gasTag.getInt("x");
                int z = gasTag.getInt("z");
                CompoundTag dataTag = gasTag.getCompound("data");
                WorldGenGas.gasMap.put(new ChunkPos(x, z), new GenData(dataTag));
            }
        }
        PrimitiveHandler.getMapPrimitives().clear();
        if (compound.contains("primitive")) {
            ListTag primitiveList = compound.getList("primitive", 10);
            for (i = 0; i < primitiveList.size(); ++i) {
                CompoundTag primitiveCompound = primitiveList.getCompound(i);
                ListTag playersList = primitiveCompound.getList("listPlayers", 10);
                HashMap<UUID, Double> playerMap = new HashMap<UUID, Double>();
                for (int j = 0; j < playersList.size(); ++j) {
                    CompoundTag playerCompound = playersList.getCompound(j);
                    UUID playerUUID = playerCompound.getUUID("uuid");
                    double value = playerCompound.getDouble("value");
                    playerMap.put(playerUUID, value);
                }
                EnumPrimitive primitiveType = EnumPrimitive.values()[primitiveCompound.getInt("id")];
                PrimitiveHandler.getMapPrimitives().put(primitiveType, playerMap);
            }
        }
        GasVeinSystem.system.unload();
        if (compound.contains("gasvein")) {
            ListTag gasVeinsList = compound.getList("gasvein", 10);
            for (i = 0; i < gasVeinsList.size(); ++i) {
                CompoundTag gasVeinTag = gasVeinsList.getCompound(i);
                GasVeinSystem.system.addVein(gasVeinTag);
            }
        }
        RelocatorNetwork.instance.onUnload();
        if (compound.contains("relocator")) {
            CompoundTag tag8 = compound.getCompound("relocator");
            ListTag nbtTagList = tag8.getList("worldUUID", 10);
            for (int i2 = 0; i2 < nbtTagList.size(); ++i2) {
                CompoundTag tag9 = nbtTagList.getCompound(i2);
                ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag9.getString("id")));
                ListTag nbtTagList1 = tag9.getList("listUUID", 10);
                HashMap uuidMap = new HashMap();
                for (int j = 0; j < nbtTagList1.size(); ++j) {
                    CompoundTag tag10 = nbtTagList1.getCompound(j);
                    if (tag10.contains("listPoint")) {
                        UUID uuid = tag10.getUUID("uuid");
                        ListTag nbtTagList2 = tag10.getList("listPoint", 10);
                        LinkedList<com.denfop.items.relocator.Point> points = new LinkedList<com.denfop.items.relocator.Point>();
                        for (int k = 0; k < nbtTagList2.size(); ++k) {
                            CompoundTag pointTag = nbtTagList2.getCompound(k);
                            com.denfop.items.relocator.Point point = new com.denfop.items.relocator.Point(pointTag);
                            points.add(point);
                        }
                        uuidMap.put(uuid, points);
                    }
                    RelocatorNetwork.instance.getWorldDataPoints().put((ResourceKey<Level>)resourceKey, uuidMap);
                }
            }
        } else {
            compound.put("relocator", (Tag)new CompoundTag());
        }
        HashMap<UUID, Map<String, List<String>>> mapData = new HashMap<UUID, Map<String, List<String>>>();
        GuideBookCore.uuidGuideMap.clear();
        if (compound.contains("guide_book")) {
            CompoundTag data = compound.getCompound("guide_book");
            ListTag list = data.getList("list", 10);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                CompoundTag data1 = list.getCompound(i3);
                UUID uuid = data1.getUUID("uuid");
                HashMap mapQuest = new HashMap();
                ListTag list1 = data1.getList("list", 10);
                for (int j = 0; j < list1.size(); ++j) {
                    CompoundTag data2 = list1.getCompound(j);
                    String tab = data2.getString("tab");
                    ListTag list2 = data2.getList("list", 8);
                    ArrayList<String> names = new ArrayList<String>();
                    for (int k = 0; k < list2.size(); ++k) {
                        names.add(list2.getString(k));
                    }
                    mapQuest.put(tab, names);
                }
                mapData.put(uuid, mapQuest);
            }
        }
        GuideBookCore.uuidGuideMap = mapData;
    }

    public Level getWorld() {
        return this.world;
    }

    public void setWorld(Level world) {
        this.world = world;
    }

    public CompoundTag getTagCompound() {
        return this.tagCompound;
    }

    @Nonnull
    public CompoundTag save(@Nonnull CompoundTag compound, HolderLookup.Provider p_323640_) {
        compound = new CompoundTag();
        ListTag fakePlayersList = new ListTag();
        for (UUID uUID : SpaceNet.instance.getFakeSpaceSystem().getBodyMap().keySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putUUID("name", uUID);
            List<IFakeBody> list = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().get(uUID);
            Map<IBody, Data> map = SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(uUID);
            ListTag listTag = new ListTag();
            for (IFakeBody iFakeBody : list) {
                CompoundTag compoundTag2 = new CompoundTag();
                if (iFakeBody instanceof IFakePlanet) {
                    compoundTag2.putByte("id", (byte)0);
                }
                if (iFakeBody instanceof IFakeSatellite) {
                    compoundTag2.putByte("id", (byte)1);
                }
                if (iFakeBody instanceof IFakeAsteroid) {
                    compoundTag2.putByte("id", (byte)2);
                }
                iFakeBody.writeNBTTagCompound(compoundTag2, p_323640_);
                listTag.add((Object)compoundTag2);
            }
            compoundTag.put("fakesBody", (Tag)listTag);
            ListTag listTag2 = new ListTag();
            for (Map.Entry<IBody, Data> entry : map.entrySet()) {
                CompoundTag compoundTag3 = new CompoundTag();
                compoundTag3.put("data", (Tag)entry.getValue().writeNBT());
                listTag2.add((Object)compoundTag3);
            }
            compoundTag.put("dataBody", (Tag)listTag2);
            fakePlayersList.add((Object)compoundTag);
        }
        compound.put("fakePlayers", (Tag)fakePlayersList);
        ListTag veinsList = new ListTag();
        for (Vein vein : VeinSystem.system.getVeinsList()) {
            veinsList.add((Object)vein.writeTag());
        }
        compound.put("veins", (Tag)veinsList);
        ListTag listTag = new ListTag();
        for (UUID uUID : SpaceNet.instance.getColonieNet().getList()) {
            listTag.add((Object)SpaceNet.instance.getColonieNet().writeNBT(new CompoundTag(), uUID, p_323640_));
        }
        compound.put("colonies", (Tag)listTag);
        ListTag listTag3 = new ListTag();
        for (Radiation radiation : RadiationSystem.rad_system.radiationList) {
            listTag3.add((Object)radiation.writeCompound());
        }
        compound.put("radiations", (Tag)listTag3);
        ListTag listTag4 = new ListTag();
        for (Map.Entry<EnumPrimitive, Map<UUID, Double>> entry : PrimitiveHandler.getMapPrimitives().entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            ListTag listTag5 = new ListTag();
            for (Map.Entry<UUID, Double> entry2 : entry.getValue().entrySet()) {
                CompoundTag player = new CompoundTag();
                player.putUUID("uuid", entry2.getKey());
                player.putDouble("value", entry2.getValue().doubleValue());
                listTag5.add((Object)player);
            }
            compoundTag.put("listPlayers", (Tag)listTag5);
            compoundTag.putInt("id", entry.getKey().ordinal());
            listTag4.add((Object)compoundTag);
        }
        compound.put("primitive", (Tag)listTag4);
        ListTag listTag6 = new ListTag();
        for (Map.Entry<String, PlayerStreakInfo> entry : IUCore.mapStreakInfo.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("nick", entry.getKey());
            compoundTag.put("streak", (Tag)entry.getValue().writeNBT());
            listTag6.add((Object)compoundTag);
        }
        compound.put("streaks", (Tag)listTag6);
        compound.put("pollution", (Tag)PollutionManager.pollutionManager.writeCompound());
        ListTag listTag7 = new ListTag();
        for (ChunkPos chunkPos : TileEntityEarthQuarryController.chunkPos) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("x", chunkPos.x);
            compoundTag.putInt("z", chunkPos.z);
            listTag7.add((Object)compoundTag);
        }
        compound.put("earth_quarry", (Tag)listTag7);
        ListTag listTag8 = new ListTag();
        for (Map.Entry<ChunkPos, GenData> entry : WorldGenGas.gasMap.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("x", entry.getKey().x);
            compoundTag.putInt("z", entry.getKey().z);
            compoundTag.put("data", (Tag)entry.getValue().writeNBT());
            listTag8.add((Object)compoundTag);
        }
        compound.put("gen_gas", (Tag)listTag8);
        ListTag listTag9 = new ListTag();
        for (GasVein gasVein : GasVeinSystem.system.getVeinsList()) {
            listTag9.add((Object)gasVein.writeTag());
        }
        compound.put("gasvein", (Tag)listTag9);
        Map<ResourceKey<Level>, Map<UUID, List<com.denfop.items.relocator.Point>>> map = RelocatorNetwork.instance.getWorldDataPoints();
        CompoundTag compoundTag = new CompoundTag();
        ListTag worldListTag = new ListTag();
        for (Map.Entry<ResourceKey<Level>, Map<UUID, List<com.denfop.items.relocator.Point>>> worldEntry : map.entrySet()) {
            CompoundTag worldTag = new CompoundTag();
            worldTag.putString("id", worldEntry.getKey().location().toString());
            ListTag uuidListTag = new ListTag();
            for (Map.Entry<UUID, List<com.denfop.items.relocator.Point>> uuidEntry : worldEntry.getValue().entrySet()) {
                CompoundTag uuidTag = new CompoundTag();
                uuidTag.putUUID("uuid", uuidEntry.getKey());
                ListTag pointsListTag = new ListTag();
                for (com.denfop.items.relocator.Point point : uuidEntry.getValue()) {
                    pointsListTag.add((Object)point.writeToNBT(new CompoundTag()));
                }
                uuidTag.put("listPoint", (Tag)pointsListTag);
                uuidListTag.add((Object)uuidTag);
            }
            worldTag.put("listUUID", (Tag)uuidListTag);
            worldListTag.add((Object)worldTag);
        }
        compoundTag.put("worldUUID", (Tag)worldListTag);
        compound.put("relocator", (Tag)compoundTag);
        Map<UUID, Map<String, List<String>>> mapData = GuideBookCore.uuidGuideMap;
        if (!mapData.isEmpty()) {
            CompoundTag data = new CompoundTag();
            ListTag list = new ListTag();
            for (Map.Entry<UUID, Map<String, List<String>>> entry : mapData.entrySet()) {
                CompoundTag data1 = new CompoundTag();
                data1.putUUID("uuid", entry.getKey());
                ListTag list1 = new ListTag();
                Map<String, List<String>> mapQuest = entry.getValue();
                for (Map.Entry entry3 : mapQuest.entrySet()) {
                    CompoundTag data2 = new CompoundTag();
                    data2.putString("tab", (String)entry3.getKey());
                    ListTag list2 = new ListTag();
                    ((List)entry3.getValue()).forEach(name -> list2.add((Object)StringTag.valueOf((String)name)));
                    data2.put("list", (Tag)list2);
                    list1.add((Object)data2);
                }
                data1.put("list", (Tag)list1);
                list.add((Object)data1);
            }
            data.put("list", (Tag)list);
            compound.put("guide_book", (Tag)data);
        }
        compound.put("shells", (Tag)WorldSavedDataIU.saveShellClusterChunks());
        this.tagCompound = compound;
        return compound;
    }
}

