/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.TankGauge;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.upgrades.UpgradeRegistry;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentRenderInventory;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.Energy;
import com.denfop.componets.EnumTypeComponentSlot;
import com.denfop.container.ContainerPlasticCreator;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.mechanism.TilePlasticCreator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.IFluidTank;

@OnlyIn(value=Dist.CLIENT)
public class GuiPlasticCreator<T extends ContainerPlasticCreator>
extends GuiIU<ContainerPlasticCreator> {
    public final ContainerPlasticCreator container;

    public GuiPlasticCreator(ContainerPlasticCreator container1) {
        super(container1);
        this.container = container1;
        this.componentList.clear();
        this.invSlotList.add(((TilePlasticCreator)this.container.base).outputSlot);
        this.inventory = new GuiComponent(this, 7, 83, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.ALL)));
        this.slots = new GuiComponent(this, 0, 0, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.SLOTS_UPGRADE, this.invSlotList)));
        this.componentList.add(this.inventory);
        this.componentList.add(this.slots);
        this.addComponent(new GuiComponent(this, 80, 35, EnumTypeComponent.PROCESS, new Component<ComponentProgress>(((TilePlasticCreator)this.container.base).componentProgress)));
        this.addComponent(new GuiComponent(this, 117, 60, EnumTypeComponent.SOUND_BUTTON, new Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
        this.componentList.add(new GuiComponent(this, 0, 0, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.SLOT, Collections.singletonList(((TilePlasticCreator)this.container.base).input_slot)))));
        this.addComponent(new GuiComponent(this, 58, 35, EnumTypeComponent.ENERGY, new Component<Energy>(((TilePlasticCreator)this.container.base).energy)));
        this.addElement(TankGauge.createNormal(this, 6, 5, (IFluidTank)((TilePlasticCreator)this.container.base).fluidTank));
    }

    private static List<ItemStack> getCompatibleUpgrades(IUpgradableBlock block) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Set<UpgradableProperty> properties = block.getUpgradableProperties();
        for (ItemStack stack : UpgradeRegistry.getUpgrades()) {
            IUpgradeItem item = (IUpgradeItem)stack.getItem();
            if (!item.isSuitableFor(stack, properties)) continue;
            ret.add(stack);
        }
        return ret;
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
    }

    public void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 0 && mouseX <= 12 && mouseY >= 0 && mouseY <= 12) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.generic.text.upgrade"));
            for (ItemStack stack : GuiPlasticCreator.getCompatibleUpgrades((IUpgradableBlock)((Object)this.container.base))) {
                text.add(stack.getDisplayName().getString());
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        GuiPlasticCreator.bindTexture(this.getTexture());
        GuiPlasticCreator.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine.png");
    }
}

