/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.biomass;

import com.denfop.IUItem;
import com.denfop.blocks.FluidName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class BiomassHandler {
    private static final List<BiomassHandler> recipes = new ArrayList<BiomassHandler>();
    private final ItemStack input;
    private final FluidStack output;

    public BiomassHandler(ItemStack input, FluidStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<BiomassHandler> getRecipes() {
        if (recipes.isEmpty()) {
            BiomassHandler.initRecipes();
        }
        return recipes;
    }

    public static BiomassHandler addRecipe(ItemStack input, FluidStack output) {
        BiomassHandler recipe = new BiomassHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        BiomassHandler.addRecipe(IUItem.biochaff, new FluidStack((Fluid)FluidName.fluidbiomass.getInstance().get(), 200));
        BiomassHandler.addRecipe(IUItem.plantBall, new FluidStack((Fluid)FluidName.fluidbiomass.getInstance().get(), 150));
    }

    public ItemStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }
}

