/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.handlerho;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class HandlerHOHandler {
    protected static final List<HandlerHOHandler> recipes = new ArrayList<HandlerHOHandler>();
    protected final List<ItemStack> output;
    protected final CompoundTag nbt;
    protected final ItemStack input;

    public HandlerHOHandler(ItemStack input, List<ItemStack> output, CompoundTag metaData) {
        this.input = input;
        this.output = output;
        this.nbt = metaData;
    }

    public static List<HandlerHOHandler> getRecipes() {
        if (recipes.isEmpty()) {
            HandlerHOHandler.initRecipes();
        }
        return recipes;
    }

    public static HandlerHOHandler addRecipe(ItemStack input, List<ItemStack> output, CompoundTag metaData) {
        HandlerHOHandler recipe = new HandlerHOHandler(input, output, metaData);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static HandlerHOHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (HandlerHOHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("handlerho")) {
            HandlerHOHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items, container.getOutput().metadata);
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public boolean matchesInput(ItemStack is) {
        return is.getItem() == this.input.getItem();
    }

    public CompoundTag getNBT() {
        return this.nbt;
    }
}

