/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.sharpener;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class SharpenerHandler {
    private static final List<SharpenerHandler> recipes = new ArrayList<SharpenerHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public SharpenerHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<SharpenerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            SharpenerHandler.initRecipes();
        }
        return recipes;
    }

    public static SharpenerHandler addRecipe(ItemStack input, ItemStack output) {
        SharpenerHandler recipe = new SharpenerHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static SharpenerHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (SharpenerHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("sharpener")) {
            SharpenerHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

