/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.Localization;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.CapabilityFluidHandlerItem;
import com.denfop.items.ItemFluidCapabilities;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class ItemFluidContainer
extends Item
implements ItemFluidCapabilities {
    public final int capacity;
    protected String nameItem;

    public ItemFluidContainer(int capacity) {
        super(new Item.Properties().stacksTo(64).setNoRepair());
        this.capacity = capacity;
    }

    public ItemFluidContainer(Item.Properties properties, int capacity) {
        super(properties);
        this.capacity = capacity;
    }

    public ItemFluidContainer(int capacity, int amount) {
        super(new Item.Properties().stacksTo(amount).setNoRepair());
        this.capacity = capacity;
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem + ".name";
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext level, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, level, list, tooltipFlag);
        IFluidHandlerItem fs = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM, null);
        if (fs != null) {
            if (fs.getFluidInTank(0).getFluid() != Fluids.EMPTY) {
                list.add((Component)Component.literal((String)("< " + Localization.translate(fs.getFluidInTank(0).getFluid().getFluidType().getDescriptionId()) + ", " + fs.getFluidInTank(0).getAmount() + " mB >")));
            } else {
                list.add((Component)Component.literal((String)Localization.translate("iu.item.FluidContainer.Empty")));
            }
        }
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        if (!this.hasCraftingRemainingItem(stack)) {
            return super.getCraftingRemainingItem(stack);
        }
        ItemStack ret = ModUtils.setSize(stack, 1);
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM, null);
        handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        return handler.getContainer();
    }

    @Override
    public IFluidHandlerItem initCapabilities(ItemStack stack) {
        return new CapabilityFluidHandlerItem(() -> (DataComponentType)DataComponentsInit.FLUID.get(), stack, this.capacity){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && ItemFluidContainer.this.canfill(fluid.getFluid());
            }

            public boolean canDrainFluidType(FluidStack fluid) {
                return fluid != null && ItemFluidContainer.this.canfill(fluid.getFluid()) && ItemFluidContainer.this.canDrain(fluid);
            }
        };
    }

    public boolean canDrain(FluidStack fluid) {
        return true;
    }

    public List<ItemStack> getAllStacks() {
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        ret.add(new ItemStack((ItemLike)this).copy());
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            ItemStack add = this.getItemStack(fluid);
            if (add == ItemStack.EMPTY || add.isEmpty() || FluidHandlerFix.getFluidHandler(add).getFluidInTank(0).isEmpty()) continue;
            ret.add(add);
        }
        return ret;
    }

    public boolean canfill(Fluid var1) {
        return true;
    }

    public ItemStack getItemStack(ItemStack ret, Fluid fluid) {
        if (fluid == null) {
            return ret;
        }
        IFluidHandlerItem handler = FluidHandlerFix.getFluidHandler(ret);
        if (handler == null) {
            return null;
        }
        return handler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE) > 0 ? handler.getContainer() : null;
    }

    public ItemStack getItemStack(Fluid fluid) {
        ItemStack ret = new ItemStack((ItemLike)this).copy();
        if (fluid == null || fluid == Fluids.EMPTY || !fluid.isSource(fluid.defaultFluidState())) {
            return ret;
        }
        IFluidHandlerItem handler = FluidHandlerFix.getFluidHandler(ret);
        if (handler == null) {
            handler = this.initCapabilities(ret);
        }
        if (handler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE) > 0) {
            return handler.getContainer();
        }
        return ret;
    }
}

