/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.api.item.IVolcanoArmor;
import com.denfop.componets.Fluids;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.items.armour.ItemArmorUtility;
import com.denfop.register.Register;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import org.jetbrains.annotations.Nullable;

public class ItemArmorVolcanoHazmat
extends ItemArmorUtility
implements IVolcanoArmor,
ISpecialArmor {
    public ItemArmorVolcanoHazmat(String name, ArmorItem.Type type) {
        super((Holder<ArmorMaterial>)Register.HAZMAT, name, type);
        if (type.getSlot() == EquipmentSlot.FEET) {
            NeoForge.EVENT_BUS.register((Object)this);
        }
        this.armorName = name;
    }

    public static boolean hasCompleteHazmat(LivingEntity living) {
        ItemStack stack;
        EquipmentSlot slot2;
        IVolcanoArmor hazmat;
        Iterator var1 = Arrays.stream(EquipmentSlot.values()).filter(slot -> slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND).iterator();
        do {
            if (!var1.hasNext()) {
                return true;
            }
            slot2 = (EquipmentSlot)var1.next();
            stack = living.getItemBySlot(slot2);
            if (!(stack.getItem() instanceof IVolcanoArmor)) {
                return false;
            }
            hazmat = (IVolcanoArmor)stack.getItem();
            if (hazmat.addsProtection(living, slot2, stack)) continue;
            return false;
        } while (!hazmat.fullyProtects(living, slot2, stack));
        return true;
    }

    public static boolean hazmatAbsorbs(DamageSource source) {
        return source.is(DamageTypeTags.IS_FIRE);
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        int suffix1 = this.getEquipmentSlot() == EquipmentSlot.LEGS ? 2 : 1;
        return ResourceLocation.parse((String)("industrialupgrade:textures/armor/volcano_hazmat_" + suffix1 + ".png"));
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(LivingEntity player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (this.getEquipmentSlot() == EquipmentSlot.HEAD && ItemArmorVolcanoHazmat.hazmatAbsorbs(source) && ItemArmorVolcanoHazmat.hasCompleteHazmat(player)) {
            if (source.is(DamageTypeTags.IS_FIRE)) {
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 60, 1));
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, Integer.MAX_VALUE);
        }
        return this.getEquipmentSlot() == EquipmentSlot.FEET && source.is(DamageTypeTags.IS_FALL) ? new ISpecialArmor.ArmorProperties(10, damage < 8.0 ? 1.0 : 0.875, (armor.getMaxDamage() - armor.getDamageValue() + 2) * 2 * 25) : new ISpecialArmor.ArmorProperties(0, 0.05, (armor.getMaxDamage() - armor.getDamageValue() + 2) / 2 * 25);
    }

    @Override
    public void damageArmor(LivingEntity entity, ItemStack stack, DamageSource source, float damage, int slot) {
        if (!ItemArmorVolcanoHazmat.hazmatAbsorbs(source) || !ItemArmorVolcanoHazmat.hasCompleteHazmat(entity)) {
            int damageTotal = (int)(damage * 2.0f);
            if (this.getEquipmentSlot() == EquipmentSlot.FEET && source.is(DamageTypeTags.IS_FALL)) {
                damageTotal = (int)((damage + 1.0f) / 2.0f);
            }
            if (entity instanceof ServerPlayer) {
                stack.hurtAndBreak(damageTotal, ((ServerPlayer)entity).serverLevel(), (ServerPlayer)entity, ignored -> {});
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (!event.getEntity().level().isClientSide() && event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            ItemStack armor = (ItemStack)player.getInventory().armor.get(0);
            if (armor.getItem() == this) {
                int fallDamage = (int)event.getDistance() - 3;
                if (fallDamage >= 8) {
                    return;
                }
                int armorDamage = (fallDamage + 1) / 2;
                if (armorDamage <= armor.getMaxDamage() - armor.getDamageValue() && armorDamage >= 0) {
                    armor.hurtAndBreak(armorDamage, player.serverLevel(), player, ignored -> {});
                    event.setCanceled(true);
                }
            }
        }
    }

    public boolean isRepairable() {
        return true;
    }

    @Override
    public int getArmorDisplay(Player player, ItemStack armor, int slot) {
        return 1;
    }

    @Override
    public void inventoryTick(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.inventoryTick(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        if (p_41407_ >= 36 && p_41407_ < 40 && p_41406_ instanceof Player) {
            Player player = (Player)p_41406_;
            this.onArmorTick(p_41404_, p_41405_, (Player)p_41406_);
        }
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.isClientSide && this.getEquipmentSlot() == EquipmentSlot.HEAD && player.isOnFire() && ItemArmorVolcanoHazmat.hasCompleteHazmat((LivingEntity)player)) {
            if (this.isInLava(player)) {
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 20, 0, true, true));
            }
            player.clearFire();
        }
    }

    public boolean isInLava(Player player) {
        int x = (int)Math.floor(player.getX());
        int y = (int)Math.floor(player.getY() + 0.02);
        int z = (int)Math.floor(player.getZ());
        FluidState state = player.level().getFluidState(new BlockPos(x, y, z));
        if (state.is(Fluids.LAVA)) {
            Integer level = state.getAmount();
            if (level > 8) {
                level = 0;
            }
            float height = (float)(y + 1) - (float)level.intValue() / 9.0f;
            return player.getY() < (double)height;
        }
        return false;
    }

    @Override
    public boolean addsProtection(LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
        return true;
    }
}

