/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.IUPotion;
import com.denfop.Localization;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.items.armour.ItemArmorEnergy;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class ItemSolarPanelHelmet
extends ItemArmorEnergy
implements IEnergyItem,
ISpecialArmor,
IUpgradeItem {
    protected static final Map<Holder<MobEffect>, Integer> potionRemovalCost = new HashMap<Holder<MobEffect>, Integer>();
    private final int solarType;
    private final String name;
    private double maxCharge;
    private double transferLimit;
    private int tier;
    private double genDay;
    private double genNight;
    private int energyPerDamage;
    private double damageAbsorptionRatio;
    private boolean sunIsUp;
    private boolean skyIsVisible;
    private boolean ret = false;
    private double storage;
    private double maxStorage;

    public ItemSolarPanelHelmet(int type, String name) {
        super("", ArmorItem.Type.HELMET, type == 1 ? 1000000.0 : (type == 2 ? 1.0E7 : (type == 3 ? 10000.0 : 1.0E8)), type == 1 ? 3000.0 : (type == 2 ? 10000.0 : (type == 3 ? 10000.0 : 38000.0)), type == 1 ? 1 : (type == 2 ? 2 : (type == 3 ? 3 : (type == 4 ? 5 : 7))));
        this.solarType = type;
        this.name = name;
        this.transferLimit = 3000.0;
        this.tier = 1;
        if (this.solarType == 1) {
            this.genDay = 5.0;
            this.genNight = this.genDay / 2.0;
            this.maxCharge = 1000000.0;
            this.energyPerDamage = 800;
            this.damageAbsorptionRatio = 0.9;
            this.storage = 0.0;
            this.maxStorage = 1600.0;
        }
        if (this.solarType == 2) {
            this.genDay = 20.0;
            this.genNight = this.genDay / 2.0;
            this.maxCharge = 1.0E7;
            this.transferLimit = 10000.0;
            this.tier = 2;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.storage = 0.0;
            this.maxStorage = 10000.0;
        }
        if (this.solarType == 3) {
            this.genDay = 80.0;
            this.genNight = this.genDay / 2.0;
            this.maxCharge = 1.0E7;
            this.transferLimit = 10000.0;
            this.tier = 3;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.storage = 0.0;
            this.maxStorage = 100000.0;
        }
        if (this.solarType == 4) {
            this.genDay = 1280.0;
            this.genNight = this.genDay / 2.0;
            this.transferLimit = 38000.0;
            this.maxCharge = 1.0E8;
            this.tier = 5;
            this.energyPerDamage = 800;
            this.damageAbsorptionRatio = 0.9;
            this.storage = 0.0;
            this.maxStorage = 2500000.0;
        }
        if (this.solarType == 5) {
            this.genDay = 5120.0;
            this.genNight = this.genDay / 2.0;
            this.transferLimit = 100000.0;
            this.maxCharge = 1.0E8;
            this.tier = 7;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.storage = 0.0;
            this.maxStorage = 5.0E8;
        }
        potionRemovalCost.put((Holder<MobEffect>)MobEffects.POISON, 100);
        potionRemovalCost.put((Holder<MobEffect>)IUPotion.rad, 20);
        potionRemovalCost.put((Holder<MobEffect>)MobEffects.WITHER, 100);
        potionRemovalCost.put((Holder<MobEffect>)MobEffects.HUNGER, 200);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.SOLAR_HELMET.list));
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ItemStack var4 = new ItemStack((ItemLike)this, 1);
            ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
            p_41392_.add((Object)var4);
            p_41392_.add((Object)new ItemStack((ItemLike)this, 1));
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        int prev = this.getDamage(stack);
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        CompoundTag nbtData = ModUtils.nbt(stack);
        if (!nbtData.getString("mode").isEmpty()) {
            return ResourceLocation.parse((String)("industrialupgrade:textures/armor/" + this.name + "_" + nbtData.getString("mode").toLowerCase() + ".png"));
        }
        return ResourceLocation.parse((String)("industrialupgrade:textures/armor/" + this.name + ".png"));
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    private double experimental_generating(Level world) {
        double k = 0.0;
        float celestialAngle = (float)world.getDayTime() % 24000.0f / 24000.0f;
        if ((celestialAngle *= 360.0f) <= 90.0f) {
            k = celestialAngle / 90.0f;
        } else if (celestialAngle > 90.0f && celestialAngle < 180.0f) {
            k = 1.0f - (celestialAngle -= 90.0f) / 90.0f;
        } else if (celestialAngle > 180.0f && celestialAngle < 270.0f) {
            k = (celestialAngle -= 180.0f) / 90.0f;
        } else if (celestialAngle > 270.0f && celestialAngle < 360.0f) {
            k = 1.0f - (celestialAngle -= 270.0f) / 90.0f;
        }
        return k;
    }

    public void onArmorTick(@Nonnull ItemStack itemStack, Level worldObj, @Nonnull Player player) {
        int repaired;
        if (worldObj.isClientSide) {
            return;
        }
        this.gainFuel(player);
        CompoundTag nbtData = ModUtils.nbt(itemStack);
        int resistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RESISTANCE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RESISTANCE, (ItemStack)itemStack).number : 0;
        int n = repaired = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.REPAIRED, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.REPAIRED, (ItemStack)itemStack).number : 0;
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.INVISIBILITY, itemStack)) {
            player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 300));
        }
        boolean Nightvision = (Boolean)itemStack.getOrDefault(DataComponentsInit.NIGHT_VISION, (Object)false);
        byte toggleTimer = nbtData.getByte("toggleTimer");
        if (IUCore.keyboard.isArmorKey(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = Nightvision = !Nightvision;
            if (!player.level().isClientSide()) {
                itemStack.set(DataComponentsInit.NIGHT_VISION, (Object)Nightvision);
                if (Nightvision) {
                    IUCore.proxy.messagePlayer(player, "Nightvision enabled.");
                } else {
                    IUCore.proxy.messagePlayer(player, "Nightvision disabled.");
                }
            }
        }
        if (!player.level().isClientSide() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.putByte("toggleTimer", toggleTimer);
        }
        if (Nightvision && !player.level().isClientSide() && ElectricItem.manager.use(itemStack, 1.0, (LivingEntity)player)) {
            boolean without;
            int x = Mth.floor((double)player.getX());
            int z = Mth.floor((double)player.getZ());
            int y = Mth.floor((double)player.getY());
            int skylight = player.level().getMaxLocalRawBrightness(new BlockPos(x, y, z));
            boolean with = this.solarType == 1;
            boolean bl = without = this.solarType == 2 || this.solarType == 3;
            if (without || with) {
                if (skylight > 8) {
                    IUCore.proxy.removePotion((LivingEntity)player, (Holder<MobEffect>)MobEffects.NIGHT_VISION);
                    if (with) {
                        player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0, true, true));
                    }
                } else {
                    if (with) {
                        IUCore.proxy.removePotion((LivingEntity)player, (Holder<MobEffect>)MobEffects.BLINDNESS);
                    }
                    player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300, 0));
                }
            } else {
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300, 0));
            }
            this.ret = true;
        }
        if (repaired != 0 && worldObj.dayTime() % 80L == 0L) {
            ElectricItem.manager.charge(itemStack, this.getMaxEnergy(itemStack) * 1.0E-5 * (double)repaired, Integer.MAX_VALUE, true, false);
        }
        if (resistance != 0) {
            player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300, resistance));
        }
        int genday = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.GENDAY, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.GENDAY, (ItemStack)itemStack).number : 0;
        int gennight = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.GENNIGHT, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.GENNIGHT, (ItemStack)itemStack).number : 0;
        int storage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.STORAGE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.STORAGE, (ItemStack)itemStack).number : 0;
        double k = this.experimental_generating(worldObj);
        if (this.sunIsUp && this.skyIsVisible) {
            this.storage = (Double)itemStack.getOrDefault(DataComponentsInit.STORAGE, (Object)0.0);
            this.storage += (this.genDay + this.genDay * 0.05 * (double)genday) * k;
            itemStack.set(DataComponentsInit.STORAGE, (Object)this.storage);
        }
        if (this.skyIsVisible) {
            this.storage = (Double)itemStack.getOrDefault(DataComponentsInit.STORAGE, (Object)0.0);
            this.storage += (this.genNight + this.genNight * 0.05 * (double)gennight) * k;
            itemStack.set(DataComponentsInit.STORAGE, (Object)this.storage);
        }
        if ((Double)itemStack.getOrDefault(DataComponentsInit.STORAGE, (Object)0.0) >= this.maxStorage + this.maxStorage * 0.05 * (double)storage) {
            itemStack.set(DataComponentsInit.STORAGE, (Object)(this.maxStorage + this.maxStorage * 0.05 * (double)storage));
        }
        if ((Double)itemStack.getOrDefault(DataComponentsInit.STORAGE, (Object)0.0) < 0.0) {
            itemStack.set(DataComponentsInit.STORAGE, (Object)0.0);
        }
        for (MobEffectInstance effect : new LinkedList(player.getActiveEffects())) {
            Integer cost = potionRemovalCost.get(effect.getEffect());
            if (cost == null || !ElectricItem.manager.canUse(itemStack, (cost = Integer.valueOf(cost * (effect.getAmplifier() + 1))).intValue())) continue;
            ElectricItem.manager.use(itemStack, cost.intValue(), null);
            IUCore.proxy.removePotion((LivingEntity)player, (Holder<MobEffect>)effect.getEffect());
            this.ret = true;
        }
        double tempstorage = (Double)itemStack.getOrDefault(DataComponentsInit.STORAGE, (Object)0.0);
        if (tempstorage > 0.0) {
            double sentPacket;
            double energyLeft = tempstorage;
            for (int i = 0; i < player.getInventory().armor.size(); ++i) {
                if (energyLeft > 0.0) {
                    if (((ItemStack)player.getInventory().armor.get(i)).isEmpty() || !(((ItemStack)player.getInventory().armor.get(i)).getItem() instanceof IEnergyItem) || !((sentPacket = ElectricItem.manager.charge((ItemStack)player.getInventory().armor.get(i), energyLeft, Integer.MAX_VALUE, true, false)) > 0.0)) continue;
                    itemStack.set(DataComponentsInit.STORAGE, (Object)(energyLeft -= sentPacket));
                    this.ret = true;
                    continue;
                }
                return;
            }
            for (int j = 0; j < player.getInventory().items.size(); ++j) {
                if (energyLeft > 0.0) {
                    if (((ItemStack)player.getInventory().items.get(j)).isEmpty() || !(((ItemStack)player.getInventory().items.get(j)).getItem() instanceof IEnergyItem) || !((sentPacket = ElectricItem.manager.charge((ItemStack)player.getInventory().items.get(j), energyLeft, Integer.MAX_VALUE, true, false)) > 0.0)) continue;
                    itemStack.set(DataComponentsInit.STORAGE, (Object)(energyLeft -= sentPacket));
                    this.ret = true;
                    continue;
                }
                return;
            }
        }
        if (this.ret) {
            player.containerMenu.broadcastChanges();
        }
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.NIGTHVISION, itemStack)) {
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300));
        }
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WATER, itemStack)) {
            player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 300));
        }
    }

    public void gainFuel(Player player) {
        if (player.level().getGameTime() % 128L == 0L) {
            this.updateVisibility(player);
        }
    }

    public void updateVisibility(Player player) {
        BlockPos pos = new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ());
        boolean noSunWorld = player.level().dimension() != Level.OVERWORLD;
        boolean rainWeather = player.level().isRaining() || player.level().isThundering();
        this.sunIsUp = player.level().isDay() && !rainWeather;
        this.skyIsVisible = player.level().canSeeSky(pos.above()) && player.level().getBlockState(pos.above()).getMapColor((BlockGetter)player.level(), pos.above()) == MapColor.NONE && !noSunWorld;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(LivingEntity player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)armor).number : 0;
        int energyPerDamage = (int)((double)this.getEnergyPerDamage() - (double)this.getEnergyPerDamage() * 0.2 * (double)protect);
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    @Override
    public int getArmorDisplay(Player player, @Nonnull ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    @Override
    public void damageArmor(LivingEntity entity, @Nonnull ItemStack stack, DamageSource source, float damage, int slot) {
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)stack).number : 0;
        ElectricItem.manager.discharge(stack, (double)damage * ((double)this.getEnergyPerDamage() - (double)this.getEnergyPerDamage() * 0.2 * (double)protect), Integer.MAX_VALUE, true, false, false);
    }

    @Override
    public int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return this.damageAbsorptionRatio;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.transferLimit;
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Item.TooltipContext p_41422_, List<Component> info, TooltipFlag p_41424_) {
        boolean auto;
        super.appendHoverText(itemStack, p_41422_, info, p_41424_);
        CompoundTag nbtData1 = ModUtils.nbt(itemStack);
        info.add((Component)Component.literal((String)(Localization.translate("iu.storage.helmet") + " " + ModUtils.getString((Double)itemStack.getOrDefault(DataComponentsInit.STORAGE, (Object)0.0)) + " EF")));
        boolean with = this.solarType == 1;
        boolean without = this.solarType == 2 || this.solarType == 3;
        boolean bl = auto = this.solarType > 3;
        if (with || without || auto) {
            info.add((Component)Component.literal((String)(Localization.translate("iu.special_armor_nightvision") + KeyboardClient.armormode.getKey().getDisplayName().getString())));
            if (with) {
                info.add((Component)Component.literal((String)Localization.translate("iu.special_armor_nightvision_1")));
            }
            if (without) {
                info.add((Component)Component.literal((String)Localization.translate("iu.special_armor_nightvision_2")));
            }
            if (auto) {
                info.add((Component)Component.literal((String)Localization.translate("iu.special_armor_nightvision_3")));
            }
        }
    }

    @Override
    public void inventoryTick(ItemStack itemStack, Level world, Entity p_41406_, int p_41407_, boolean p_41408_) {
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            NeoForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
        if (p_41407_ >= 36 && p_41407_ < 40 && p_41406_ instanceof Player) {
            Player player = (Player)p_41406_;
            this.onArmorTick(itemStack, world, (Player)p_41406_);
        }
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.SOLAR_HELMET.list;
    }
}

