/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.item.IEnergyItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.BaseEnergyItem;
import com.denfop.items.IProperties;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemBattery
extends BaseEnergyItem
implements IProperties {
    private static final int maxLevel = 4;
    public final boolean wirelessCharge;

    public ItemBattery(double maxCharge, double transferLimit, int tier, boolean wirelessCharge) {
        super(new Item.Properties().component(DataComponentsInit.MODE, (Object)0), maxCharge, transferLimit, tier);
        this.wirelessCharge = wirelessCharge;
        IUCore.proxy.addProperties(this);
    }

    public ItemBattery(double maxCharge, double transferLimit, int tier) {
        super(new Item.Properties().component(DataComponentsInit.MODE, (Object)0), maxCharge, transferLimit, tier);
        this.wirelessCharge = false;
        IUCore.proxy.addProperties(this);
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext world, List<Component> tooltip, TooltipFlag flag) {
        if (this.wirelessCharge) {
            int mode = (Integer)stack.getOrDefault(DataComponentsInit.MODE, (Object)0);
            if (mode > 4 || mode < 0) {
                mode = 0;
            }
            tooltip.add((Component)Component.translatable((String)"message.text.mode").append(": ").append((Component)Component.translatable((String)("message.battery.mode." + mode))).withStyle(ChatFormatting.GREEN));
            if (!Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"press.lshift"));
            } else {
                tooltip.add((Component)Component.translatable((String)"iu.changemode_key").append((Component)Component.translatable((String)"iu.changemode_rcm1")));
            }
        }
        super.appendHoverText(stack, world, tooltip, flag);
    }

    public void inventoryTick(ItemStack itemStack, Level world, Entity entity, int slot, boolean isSelected) {
        Player player;
        block13: {
            block12: {
                if (!(entity instanceof Player)) break block12;
                player = (Player)entity;
                if (!world.isClientSide && this.wirelessCharge) break block13;
            }
            return;
        }
        int mode = (Integer)itemStack.getOrDefault(DataComponentsInit.MODE, (Object)0);
        if (mode < 1 || mode > 4) {
            return;
        }
        if (world.getGameTime() % (long)(mode == 4 ? 40 : 10) == 0L) {
            boolean transferred = false;
            switch (mode) {
                case 1: {
                    transferred = this.chargeItems((Iterable<ItemStack>)player.getInventory().items, itemStack);
                    break;
                }
                case 2: {
                    transferred = this.chargeItems((Iterable<ItemStack>)player.getInventory().items, itemStack);
                    break;
                }
                case 3: {
                    transferred = this.chargeItems((Iterable<ItemStack>)player.getInventory().armor, itemStack);
                    break;
                }
                case 4: {
                    transferred = this.chargeItems((Iterable<ItemStack>)player.getInventory().armor, itemStack);
                    if (world.getGameTime() % 40L != 0L) break;
                    transferred |= this.chargeItems((Iterable<ItemStack>)player.getInventory().items, itemStack);
                }
            }
            if (transferred) {
                player.containerMenu.broadcastChanges();
            }
        }
    }

    private boolean chargeItems(Iterable<ItemStack> inventory, ItemStack battery) {
        boolean transferred = false;
        for (ItemStack stack : inventory) {
            double transfer;
            if (stack.isEmpty() || !(stack.getItem() instanceof IEnergyItem) || stack.getItem() instanceof ItemBattery || !((transfer = ElectricItem.manager.discharge(battery, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) > 0.0) || !((transfer = ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false)) > 0.0)) continue;
            ElectricItem.manager.discharge(battery, transfer, Integer.MAX_VALUE, true, true, false);
            transferred = true;
        }
        return transferred;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack;
        if (!world.isClientSide && this.wirelessCharge) {
            stack = player.getItemInHand(hand);
            int mode = (Integer)stack.get(DataComponentsInit.MODE);
            mode = (mode + 1) % 5;
            stack.set(DataComponentsInit.MODE, (Object)mode);
            player.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + Localization.translate("message.text.mode") + ": " + Localization.translate("message.battery.mode." + mode))), true);
        }
        stack = player.getItemInHand(hand);
        if (!world.isClientSide && ModUtils.getSize(stack) == 1) {
            if (ElectricItem.manager.getCharge(stack) > 0.0) {
                boolean transferred = false;
                for (int i = 0; i < 9; ++i) {
                    double transfer;
                    ItemStack target = (ItemStack)player.getInventory().items.get(i);
                    if (target.isEmpty() || !(target.getItem() instanceof IEnergyItem) || target == stack || ElectricItem.manager.discharge(target, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, true, true) > 0.0 || !((transfer = ElectricItem.manager.discharge(stack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) > 0.0) || !((transfer = ElectricItem.manager.charge(target, transfer, this.tier, true, false)) > 0.0)) continue;
                    ElectricItem.manager.discharge(stack, transfer, Integer.MAX_VALUE, true, true, false);
                    transferred = true;
                }
                if (transferred) {
                    player.containerMenu.broadcastChanges();
                }
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public String[] properties() {
        return new String[]{"level"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        double damage = ElectricItem.manager.getCharge(stack);
        double maxDamage = ElectricItem.manager.getMaxCharge(stack);
        return (float)((double)((int)(4.0 * damage / maxDamage)) * 0.25);
    }
}

