/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.datacomponent.ContainerItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.BaseEnergyItem;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.energy.ContainerMagnet;
import com.denfop.items.energy.ItemStackMagnet;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.IUpdatableItemStackEvent;
import com.denfop.utils.KeyboardIU;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class ItemMagnet
extends BaseEnergyItem
implements IItemStackInventory,
IUpdatableItemStackEvent,
IUpgradeItem {
    private final int radius;

    public ItemMagnet(double maxCharge, double transferLimit, int tier, int radius) {
        super(new Item.Properties().component(DataComponentsInit.MODE, (Object)0).component(DataComponentsInit.BLACK_LIST, (Object)false), maxCharge, transferLimit, tier);
        this.radius = radius;
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe(this, EnumUpgrades.MAGNET.list));
    }

    @Override
    public void updateField(String name, CustomPacketBuffer buffer, ItemStack stack) {
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu.energy." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public void updateEvent(int event, ItemStack stack) {
        stack.set(DataComponentsInit.BLACK_LIST, (Object)((Boolean)stack.getOrDefault(DataComponentsInit.BLACK_LIST, (Object)false) == false ? 1 : 0));
    }

    public void inventoryTick(ItemStack itemStack, Level p_77663_2_, Entity p_77663_3_, int slotIndex, boolean isCurrentItem) {
        ItemStackMagnet toolbox;
        int slotId;
        ItemStack stack;
        ContainerItem containerItem;
        if (!(p_77663_3_ instanceof Player)) {
            return;
        }
        if (p_77663_2_.isClientSide) {
            return;
        }
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            NeoForge.EVENT_BUS.post((Event)new EventItemLoad(p_77663_2_, this, itemStack));
        }
        Player player = (Player)p_77663_3_;
        int mode = (Integer)itemStack.getOrDefault(DataComponentsInit.MODE, (Object)0);
        if (mode != 0) {
            int radius1 = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SIZE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SIZE, (ItemStack)itemStack).number : 0;
            double energy = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, itemStack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)itemStack).number * 0.25 : 0.0);
            int radius = this.radius + radius1;
            AABB axisalignedbb = new AABB(player.getX() - (double)radius, player.getY() - (double)radius, player.getZ() - (double)radius, player.getX() + (double)radius, p_77663_3_.getY() + (double)radius, p_77663_3_.getZ() + (double)radius);
            LevelEntityGetter list1 = ((ServerLevel)p_77663_2_).getEntities();
            ArrayList list = Lists.newArrayList();
            list1.get(axisalignedbb, p_151522_ -> {
                if (p_151522_ instanceof ItemEntity) {
                    list.add(p_151522_);
                }
            });
            ItemStackMagnet inventory = (ItemStackMagnet)this.getInventory(player, itemStack);
            for (Entity entityinlist : list) {
                boolean zcoord;
                if (!(entityinlist instanceof ItemEntity)) continue;
                ItemEntity item = (ItemEntity)entityinlist;
                if (!ElectricItem.manager.canUse(itemStack, 200.0 * energy) || !this.canInsert(itemStack, ((ItemEntity)entityinlist).getItem(), inventory)) continue;
                if (mode == 1) {
                    item.absMoveTo(p_77663_3_.position().x, p_77663_3_.position().y, p_77663_3_.position().z, 0.0f, 0.0f);
                    if (!player.level().isClientSide) {
                        ((ServerPlayer)player).connection.send((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                    }
                    item.setPickUpDelay(0);
                    ElectricItem.manager.use(itemStack, 200.0 * energy, (LivingEntity)player);
                    continue;
                }
                if (mode != 2) continue;
                boolean xcoord = item.position().x + 2.0 >= p_77663_3_.position().x && item.position().x - 2.0 <= p_77663_3_.position().x;
                boolean bl = zcoord = item.position().z + 2.0 >= p_77663_3_.position().z && item.position().z - 2.0 <= p_77663_3_.position().z;
                if (xcoord || zcoord) continue;
                item.absMoveTo(p_77663_3_.position().x, p_77663_3_.position().y - 1.0, p_77663_3_.position().z);
                item.setPickUpDelay(10);
            }
        }
        if ((containerItem = ContainerItem.getContainer(stack = itemStack)).open() && (slotId = containerItem.slot_inventory()) != slotIndex && !p_77663_2_.isClientSide && !stack.isEmpty() && player.containerMenu instanceof ContainerMagnet && (toolbox = (ItemStackMagnet)((ContainerMagnet)player.containerMenu).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.closeContainer();
            containerItem.updateOpen(stack, false);
        }
    }

    private boolean canInsert(ItemStack itemstack, ItemStack itemStack1, ItemStackMagnet inventory) {
        boolean white = (Boolean)itemstack.getOrDefault(DataComponentsInit.BLACK_LIST, (Object)false);
        boolean can = false;
        if (white) {
            for (ItemStack stack1 : inventory.list) {
                if (stack1.isEmpty() || !stack1.is(itemStack1.getItem())) continue;
                can = true;
                break;
            }
        } else {
            for (ItemStack stack1 : inventory.list) {
                if (!stack1.isEmpty() && stack1.is(itemStack1.getItem())) {
                    can = false;
                    break;
                }
                can = true;
            }
        }
        return can;
    }

    public InteractionResultHolder<ItemStack> use(Level p_41432_, Player player, InteractionHand hand) {
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            int mode = (Integer)player.getItemInHand(hand).getOrDefault(DataComponentsInit.MODE, (Object)0);
            if (++mode > 2 || mode < 0) {
                mode = 0;
            }
            player.getItemInHand(hand).set(DataComponentsInit.MODE, (Object)mode);
            if (!p_41432_.isClientSide) {
                IUCore.proxy.messagePlayer(player, String.valueOf(ChatFormatting.GREEN) + Localization.translate("message.text.mode") + ": " + Localization.translate("message.magnet.mode." + mode));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
        }
        if (!p_41432_.isClientSide) {
            this.save(player.getItemInHand(hand), player);
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer(p_41432_.registryAccess());
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            player.openMenu((MenuProvider)this.getInventory(player, player.getItemInHand(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    public void save(ItemStack stack, Player player) {
        ContainerItem containerItem = ContainerItem.getContainer(stack);
        containerItem = containerItem.updateOpen(stack, true);
        containerItem.updateSlot(stack, player.getInventory().selected);
    }

    @Override
    public IAdvInventory getInventory(Player player, ItemStack stack) {
        return new ItemStackMagnet(player, stack, 0);
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, @Nonnull Player player) {
        ItemStackMagnet toolbox;
        if (!player.level().isClientSide && !stack.isEmpty() && player.containerMenu instanceof ContainerMagnet && (toolbox = (ItemStackMagnet)((ContainerMagnet)player.containerMenu).base).isThisContainer(stack)) {
            toolbox.saveAndThrow(stack);
            player.closeContainer();
        }
        return true;
    }

    public void appendHoverText(ItemStack p_41421_, @Nullable Item.TooltipContext p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        int mode = (Integer)p_41421_.getOrDefault(DataComponentsInit.MODE, (Object)0);
        if (mode > 2 || mode < 0) {
            mode = 0;
        }
        p_41423_.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + Localization.translate("message.text.mode") + ": " + Localization.translate("message.magnet.mode." + mode))));
        int radius1 = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SIZE, p_41421_) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SIZE, (ItemStack)p_41421_).number : 0;
        p_41423_.add((Component)Component.literal((String)(Localization.translate("iu.magnet.info") + (this.radius + radius1) + "x" + (this.radius + radius1))));
        if (!KeyboardIU.isKeyDown(340)) {
            p_41423_.add((Component)Component.literal((String)Localization.translate("press.lshift")));
        }
        if (KeyboardIU.isKeyDown(340)) {
            p_41423_.add((Component)Component.literal((String)(Localization.translate("iu.changemode_key") + Localization.translate("iu.changemode_rcm1"))));
        }
        super.appendHoverText(p_41421_, p_41422_, p_41423_, p_41424_);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return false;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.MAGNET.list;
    }
}

