/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.componets.AbstractComponent;
import com.denfop.items.BaseEnergyItem;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileMultiMachine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public class ItemPurifier
extends BaseEnergyItem
implements IUpgradeItem {
    public ItemPurifier(double maxCharge, double transferLimit, int tier) {
        super(maxCharge, transferLimit, 1);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe(this, EnumUpgrades.PURIFIER.list));
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.literal((String)Localization.translate("iu.purifier.info")));
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.PURIFIER.list;
    }

    public void inventoryTick(ItemStack itemStack, Level p_77663_2_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.inventoryTick(itemStack, p_77663_2_, p_41406_, p_41407_, p_41408_);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            NeoForge.EVENT_BUS.post((Event)new EventItemLoad(p_77663_2_, this, itemStack));
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Object base;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Direction side = context.getClickedFace();
        ItemStack itemstack = context.getItemInHand();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockEntity tile = world.getBlockEntity(pos);
        if (!(tile instanceof TileEntityInventory) && !(tile instanceof IManufacturerBlock)) {
            return InteractionResult.PASS;
        }
        double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, itemstack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)itemstack).number * 0.25 : 0.0);
        if (tile instanceof TileEntityBlock) {
            base = (TileEntityBlock)tile;
            double energy = 10000.0;
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PURIFIER, itemstack)) {
                energy = 0.0;
            }
            if (!((TileEntityBlock)((Object)base)).canEntityDestroy((Entity)player)) {
                return InteractionResult.FAIL;
            }
            for (AbstractComponent component : ((TileEntityBlock)((Object)base)).getComponentList()) {
                if (!component.canUsePurifier(player) || !ElectricItem.manager.canUse(itemstack, energy * coef)) continue;
                component.workPurifier();
                return InteractionResult.SUCCESS;
            }
        }
        if (tile instanceof TileMultiMachine) {
            base = (TileMultiMachine)tile;
            if (!ElectricItem.manager.canUse(itemstack, 500.0 * coef)) {
                return InteractionResult.PASS;
            }
            if (!player.isCrouching()) {
                ItemStack stack_quickly = ItemStack.EMPTY;
                ItemStack stack_modulesize = ItemStack.EMPTY;
                ItemStack stack_modulestorage = ItemStack.EMPTY;
                ItemStack panel = ItemStack.EMPTY;
                ItemStack module_infinity_water = ItemStack.EMPTY;
                ItemStack module_separate = ItemStack.EMPTY;
                if (((TileMultiMachine)base).multi_process.quickly) {
                    stack_quickly = new ItemStack((ItemLike)IUItem.module_quickly.getItem());
                }
                if (((TileMultiMachine)base).multi_process.modulesize) {
                    stack_modulesize = new ItemStack((ItemLike)IUItem.module_stack.getItem());
                }
                if (((TileMultiMachine)base).multi_process.modulestorage) {
                    stack_modulestorage = new ItemStack((ItemLike)IUItem.module_storage.getItem());
                }
                if (((TileMultiMachine)base).multi_process.modulestorage) {
                    module_infinity_water = new ItemStack((ItemLike)IUItem.module_infinity_water.getItem());
                }
                if (((TileMultiMachine)base).multi_process.module_separate) {
                    module_separate = new ItemStack((ItemLike)IUItem.module_separate.getItem());
                }
                if (((TileMultiMachine)base).solartype != null) {
                    panel = new ItemStack((ItemLike)IUItem.module6.getStack(((TileMultiMachine)base).solartype.meta), 1);
                }
                if (!(stack_quickly.isEmpty() && stack_modulesize.isEmpty() && panel.isEmpty() && module_infinity_water.isEmpty() && module_separate.isEmpty())) {
                    ItemEntity item = new ItemEntity(world, player.getX(), player.getY(), player.getZ(), ItemStack.EMPTY);
                    if (!stack_quickly.isEmpty()) {
                        item.setItem(stack_quickly);
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                        ((TileMultiMachine)base).multi_process.setQuickly(false);
                    } else if (!stack_modulesize.isEmpty()) {
                        item.setItem(stack_modulesize);
                        ((TileMultiMachine)base).multi_process.setModulesize(false);
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    } else if (!module_infinity_water.isEmpty()) {
                        item.setItem(module_infinity_water);
                        ((TileMultiMachine)base).multi_process.module_infinity_water = false;
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    } else if (!module_separate.isEmpty()) {
                        item.setItem(module_separate);
                        ((TileMultiMachine)base).multi_process.module_separate = false;
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    } else if (!panel.isEmpty()) {
                        item.setItem(panel);
                        ((TileMultiMachine)base).solartype = null;
                    } else if (!stack_modulestorage.isEmpty()) {
                        item.setItem(stack_modulestorage);
                        ((TileMultiMachine)base).multi_process.setModulestorage(false);
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (!player.getInventory().isEmpty()) {
                        item.setPickUpDelay(0);
                        world.addFreshEntity((Entity)item);
                        ElectricItem.manager.use(itemstack, 500.0 * coef, (LivingEntity)player);
                        if (player.level().isClientSide) {
                            player.playSound(EnumSound.purifier.getSoundEvent(), 1.0f, 1.0f);
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
            } else {
                ArrayList<ItemStack> stack_list = new ArrayList<ItemStack>();
                if (((TileMultiMachine)base).multi_process.quickly) {
                    stack_list.add(new ItemStack((ItemLike)IUItem.module_quickly.getItem()));
                    ((TileMultiMachine)base).multi_process.setQuickly(false);
                    ((TileMultiMachine)base).multi_process.shrinkModule(1);
                }
                if (((TileMultiMachine)base).multi_process.modulesize) {
                    stack_list.add(new ItemStack((ItemLike)IUItem.module_stack.getItem()));
                    ((TileMultiMachine)base).multi_process.setModulesize(false);
                    ((TileMultiMachine)base).multi_process.shrinkModule(1);
                }
                if (((TileMultiMachine)base).solartype != null) {
                    stack_list.add(new ItemStack((ItemLike)IUItem.module6.getStack(((TileMultiMachine)base).solartype.meta), 1));
                    ((TileMultiMachine)base).solartype = null;
                }
                if (((TileMultiMachine)base).multi_process.modulestorage) {
                    stack_list.add(new ItemStack((ItemLike)IUItem.module_storage.getItem()));
                    ((TileMultiMachine)base).multi_process.setModulestorage(false);
                    ((TileMultiMachine)base).multi_process.shrinkModule(1);
                }
                if (((TileMultiMachine)base).multi_process.module_infinity_water) {
                    stack_list.add(new ItemStack((ItemLike)IUItem.module_infinity_water.getItem()));
                    ((TileMultiMachine)base).multi_process.module_infinity_water = false;
                    ((TileMultiMachine)base).multi_process.shrinkModule(1);
                }
                if (((TileMultiMachine)base).multi_process.module_separate) {
                    stack_list.add(new ItemStack((ItemLike)IUItem.module_separate.getItem()));
                    ((TileMultiMachine)base).multi_process.module_separate = false;
                    ((TileMultiMachine)base).multi_process.shrinkModule(1);
                }
                for (ItemStack stack : stack_list) {
                    ItemEntity item = new ItemEntity(world, player.getX(), player.getY(), player.getZ(), stack);
                    if (!player.level().isClientSide) {
                        item.setPickUpDelay(0);
                        world.addFreshEntity((Entity)item);
                    }
                    if (!player.level().isClientSide) continue;
                    player.playSound(EnumSound.purifier.getSoundEvent(), 1.0f, 1.0f);
                }
                ElectricItem.manager.use(itemstack, 500.0 * coef, (LivingEntity)player);
                return InteractionResult.SUCCESS;
            }
            ElectricItem.manager.use(itemstack, 500.0 * coef, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        if (tile instanceof IManufacturerBlock) {
            base = (IManufacturerBlock)tile;
            if (player.isCrouching()) {
                this.dropUpgrade(world, player, (IManufacturerBlock)base);
            } else {
                this.dropSingleUpgrade(world, player, (IManufacturerBlock)base);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void dropUpgrade(Level world, Player player, IManufacturerBlock base) {
        int level = base.getLevelMechanism();
        if (level > 0) {
            this.dropItem(world, player, new ItemStack((ItemLike)IUItem.upgrade_speed_creation.getItem(), level));
            base.setLevelMech(0);
        }
    }

    private void dropSingleUpgrade(Level world, Player player, IManufacturerBlock base) {
        if (base.getLevelMechanism() > 0) {
            this.dropItem(world, player, new ItemStack((ItemLike)IUItem.upgrade_speed_creation.getItem(), 1));
            base.removeLevel(1);
        }
    }

    private void dropItem(Level world, Player player, ItemStack stack) {
        if (!stack.isEmpty() && !world.isClientSide) {
            ItemEntity itemEntity = new ItemEntity(world, player.getX(), player.getY(), player.getZ(), stack);
            itemEntity.setPickUpDelay(0);
            world.addFreshEntity((Entity)itemEntity);
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

