/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.windsystem.WindSystem;
import com.denfop.items.BaseEnergyItem;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemWindMeter
extends BaseEnergyItem {
    public ItemWindMeter() {
        super(5000.0, 500.0, 1);
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.literal((String)Localization.translate("iu.wind_meter.info")));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand p_41434_) {
        ItemStack stack = player.getItemInHand(p_41434_);
        if (world.isClientSide || world.dimension() != Level.OVERWORLD) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!ElectricItem.manager.canUse(stack, 10.0)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        ElectricItem.manager.use(stack, 10.0, (LivingEntity)player);
        IUCore.proxy.messagePlayer(player, Localization.translate("iu.wind_meter.info") + String.format("%.1f", WindSystem.windSystem.getWind_Strength()) + " m/s");
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }
}

