/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.pressure;

import com.denfop.ModConfig;
import com.denfop.api.pressure.IPressureAcceptor;
import com.denfop.api.pressure.IPressureConductor;
import com.denfop.api.pressure.IPressureEmitter;
import com.denfop.api.pressure.IPressureNet;
import com.denfop.api.pressure.IPressureSink;
import com.denfop.api.pressure.IPressureSource;
import com.denfop.api.pressure.IPressureTile;
import com.denfop.api.pressure.PressureTickList;
import com.denfop.api.sytem.InfoTile;
import com.denfop.pressure.PressurePath;
import com.denfop.pressure.PressureTick;
import com.denfop.world.WorldBaseGen;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;

public class PressureNetLocal
implements IPressureNet {
    final PressureTickList<PressureTick<IPressureSource, PressurePath>> senderPath = new PressureTickList();
    private final Map<BlockPos, IPressureTile> chunkCoordinatesTileMap;
    List<IPressureSource> sourceToUpdateList = new ArrayList<IPressureSource>();
    private int tick = 0;

    public PressureNetLocal() {
        this.chunkCoordinatesTileMap = new HashMap<BlockPos, IPressureTile>();
    }

    public void put(IPressureSource par1, List<PressurePath> par2) {
        this.senderPath.add(new PressureTick<IPressureSource, PressurePath>(par1, par2));
    }

    public boolean containsKey(PressureTick<IPressureSource, PressurePath> par1) {
        return this.senderPath.contains(par1);
    }

    public boolean containsKey(IPressureSource par1) {
        return this.senderPath.contains(new PressureTick(par1, null));
    }

    public void remove1(IPressureSource par1) {
        for (PressureTick pressureTick : this.senderPath) {
            if (pressureTick.getSource() != par1) continue;
            if (pressureTick.getList() != null) {
                for (PressurePath PressurePath2 : pressureTick.getList()) {
                    PressurePath2.target.getEnergyTickList().remove(pressureTick.getSource());
                }
            }
            pressureTick.setList(null);
            break;
        }
    }

    public void remove(IPressureSource par1) {
        PressureTick<IPressureSource, PressurePath> energyTick = this.senderPath.removeSource(par1);
        if (energyTick != null && energyTick.getList() != null) {
            for (PressurePath PressurePath2 : energyTick.getList()) {
                PressurePath2.target.getEnergyTickList().remove(energyTick.getSource());
            }
        }
    }

    public void removeAll(List<PressureTick<IPressureSource, PressurePath>> par1) {
        if (par1 == null) {
            return;
        }
        for (PressureTick<IPressureSource, PressurePath> IEnergySource2 : par1) {
            if (IEnergySource2.getList() != null) {
                for (PressurePath PressurePath2 : IEnergySource2.getList()) {
                    PressurePath2.target.getEnergyTickList().remove(IEnergySource2.getSource());
                }
            }
            IEnergySource2.setList(null);
        }
    }

    public List<PressurePath> getPaths(IPressureAcceptor par1) {
        ArrayList<PressurePath> paths = new ArrayList<PressurePath>();
        List<PressureTick<IPressureSource, PressurePath>> sources_list = this.getSources(par1);
        if (sources_list == null || sources_list.isEmpty()) {
            return paths;
        }
        for (PressureTick<IPressureSource, PressurePath> source : sources_list) {
            paths.addAll(source.getList());
        }
        return paths;
    }

    public List<PressureTick<IPressureSource, PressurePath>> getSources(IPressureAcceptor par1) {
        if (par1 instanceof IPressureSink) {
            LinkedList<PressureTick<IPressureSource, PressurePath>> list = new LinkedList<PressureTick<IPressureSource, PressurePath>>();
            for (PressureTick pressureTick : this.senderPath) {
                if (!((IPressureSink)par1).getEnergyTickList().contains(pressureTick.getSource())) continue;
                list.add(pressureTick);
            }
            return list;
        }
        if (par1 instanceof IPressureConductor) {
            LinkedList<PressureTick> list = new LinkedList<PressureTick>();
            for (PressureTick pressureTick : this.senderPath) {
                if (!pressureTick.getConductors().contains(par1)) continue;
                list.add(pressureTick);
            }
            return new ArrayList<PressureTick<IPressureSource, PressurePath>>(list);
        }
        return Collections.emptyList();
    }

    public void clear() {
        this.senderPath.clear();
    }

    public PressureTick<IPressureSource, PressurePath> get(IPressureSource tileEntity) {
        for (PressureTick pressureTick : this.senderPath) {
            if (pressureTick.getSource() != tileEntity) continue;
            return pressureTick;
        }
        return null;
    }

    public double emitEnergyFrom(IPressureSource energySource, double amount, PressureTick<IPressureSource, PressurePath> tick) {
        List energyPaths = tick.getList();
        if (energyPaths == null) {
            Tuple<List<PressurePath>, LinkedList<IPressureConductor>> tuples = this.discover(energySource, tick);
            energyPaths = (List)tuples.getA();
            LinkedList<IPressureConductor> conductors = tick.getConductors();
            if (conductors == null) {
                tick.setConductors((LinkedList)tuples.getB());
            } else {
                tick.setConductors((LinkedList)tuples.getB());
            }
            tick.setList(energyPaths);
        }
        if (amount > 0.0) {
            for (PressurePath energyPath : energyPaths) {
                if (amount <= 0.0) break;
                IPressureSink energySink = energyPath.target;
                double demandedEnergy = energySink.getDemandedPressure();
                if (demandedEnergy <= 0.0 || demandedEnergy != amount && ((Boolean)ModConfig.COMMON.pressureWork.get()).booleanValue()) continue;
                double energyProvided = Math.min(demandedEnergy, amount);
                energySink.receivedPressure(energyProvided);
                energyPath.tick(this.tick, energyProvided);
            }
        }
        return amount;
    }

    public void onTickEnd() {
        if (!this.sourceToUpdateList.isEmpty()) {
            for (IPressureSource iPressureSource : this.sourceToUpdateList) {
                this.remove1(iPressureSource);
            }
            this.sourceToUpdateList.clear();
        }
        for (PressureTick pressureTick : this.senderPath) {
            double offer;
            IPressureSource entry = (IPressureSource)pressureTick.getSource();
            if (pressureTick.getList() != null && pressureTick.getList().isEmpty() || entry == null || !((offer = entry.getOfferedPressure()) > 0.0)) continue;
            this.emitEnergyFrom(entry, offer, pressureTick);
        }
        ++this.tick;
    }

    public void onUnload() {
        this.senderPath.clear();
        this.chunkCoordinatesTileMap.clear();
    }

    public void removeTile(IPressureTile tile1) {
        this.removeTileEntity(tile1);
    }

    private void updateRemove(BlockPos pos, IPressureTile tile) {
        for (Direction dir : Direction.values()) {
            BlockPos pos1 = pos.offset(dir.getNormal());
            IPressureTile tile1 = this.chunkCoordinatesTileMap.get(pos1);
            if (tile1 == null) continue;
            tile1.RemoveTile(tile, dir.getOpposite());
        }
    }

    public void removeTileEntity(IPressureTile tile) {
        if (!this.chunkCoordinatesTileMap.containsKey(tile.getPos())) {
            return;
        }
        BlockPos coord = tile.getPos();
        this.chunkCoordinatesTileMap.remove(coord);
        if (tile instanceof IPressureAcceptor) {
            this.removeAll(this.getSources((IPressureAcceptor)tile));
        }
        if (tile instanceof IPressureSource) {
            this.remove((IPressureSource)tile);
        }
        this.updateRemove(coord, tile);
    }

    public Tuple<List<PressurePath>, LinkedList<IPressureConductor>> discover(IPressureSource emitter, PressureTick<IPressureSource, PressurePath> tick) {
        LinkedList<IPressureSource> tileEntitiesToCheck = new LinkedList<IPressureSource>();
        AbstractList energyPaths = new LinkedList();
        long id = WorldBaseGen.random.nextLong();
        emitter.setId(id);
        tileEntitiesToCheck.push(emitter);
        LinkedList set = new LinkedList();
        while (!tileEntitiesToCheck.isEmpty()) {
            IPressureTile currentTileEntity = (IPressureTile)tileEntitiesToCheck.pop();
            List<InfoTile<IPressureTile>> validReceivers = this.getValidReceivers(currentTileEntity);
            for (InfoTile<IPressureTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter || ((IPressureTile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((IPressureTile)validReceiver.tileEntity).setId(id);
                if (!(validReceiver.tileEntity instanceof IPressureSink)) continue;
                energyPaths.add(new PressurePath((IPressureSink)validReceiver.tileEntity, validReceiver.direction));
            }
        }
        energyPaths = new ArrayList(energyPaths);
        for (PressurePath energyPath : energyPaths) {
            energyPath.target.getEnergyTickList().add(tick.getSource());
        }
        return new Tuple((Object)energyPaths, set);
    }

    public List<InfoTile<IPressureTile>> getValidReceivers(IPressureTile emitter) {
        BlockPos tile1 = emitter.getPos();
        return emitter.getValidReceivers();
    }

    public void addTileEntity(BlockPos coords, IPressureTile tile) {
        if (this.chunkCoordinatesTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesTileMap.put(coords, tile);
        this.updateAdd(coords, tile);
        if (tile instanceof IPressureAcceptor) {
            this.onTileEntityAdded((IPressureAcceptor)tile);
        }
        if (tile instanceof IPressureSource) {
            this.senderPath.add(new PressureTick((IPressureSource)tile, null));
        }
    }

    private void updateAdd(BlockPos pos, IPressureTile tile) {
        for (Direction dir : Direction.values()) {
            IPressureAcceptor receiver2;
            IPressureEmitter sender2;
            BlockPos pos1 = pos.offset(dir.getNormal());
            IPressureTile tile1 = this.chunkCoordinatesTileMap.get(pos1);
            if (tile1 == null) continue;
            Direction inverseDirection2 = dir.getOpposite();
            if (tile1 instanceof IPressureEmitter && tile instanceof IPressureAcceptor) {
                sender2 = (IPressureEmitter)tile1;
                receiver2 = (IPressureAcceptor)tile;
                if (!sender2.emitsPressureTo(receiver2, dir.getOpposite()) || !receiver2.acceptsPressureFrom(sender2, inverseDirection2.getOpposite())) continue;
                tile1.AddTile(tile, dir.getOpposite());
                tile.AddTile(tile1, dir);
                continue;
            }
            if (!(tile1 instanceof IPressureAcceptor) || !(tile instanceof IPressureEmitter) || !(sender2 = (IPressureEmitter)tile).emitsPressureTo(receiver2 = (IPressureAcceptor)tile1, dir) || !receiver2.acceptsPressureFrom(sender2, inverseDirection2)) continue;
            tile1.AddTile(tile, dir.getOpposite());
            tile.AddTile(tile1, dir);
        }
    }

    public void onTileEntityAdded(IPressureAcceptor tile) {
        LinkedList<IPressureTile> tileEntitiesToCheck = new LinkedList<IPressureTile>();
        tileEntitiesToCheck.add(tile);
        long id = WorldBaseGen.random.nextLong();
        this.sourceToUpdateList = new LinkedList<IPressureSource>();
        while (!tileEntitiesToCheck.isEmpty()) {
            IPressureTile currentTileEntity = (IPressureTile)tileEntitiesToCheck.pop();
            List<InfoTile<IPressureTile>> validReceivers = currentTileEntity.getValidReceivers();
            for (InfoTile<IPressureTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == tile || ((IPressureTile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((IPressureTile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof IPressureSource) {
                    this.sourceToUpdateList.add((IPressureSource)validReceiver.tileEntity);
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof IPressureConductor)) continue;
                tileEntitiesToCheck.push((IPressureTile)validReceiver.tileEntity);
            }
        }
        this.sourceToUpdateList = new ArrayList<IPressureSource>(this.sourceToUpdateList);
    }

    @Override
    public IPressureTile getSubTile(Level var1, BlockPos var2) {
        return this.chunkCoordinatesTileMap.get(var2);
    }
}

