/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipes;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.blocks.BlockClassicOre;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public final class ScrapboxRecipeManager {
    public static ScrapboxRecipeManager instance;
    public final List<Drop> drops = new LinkedList<Drop>();

    public ScrapboxRecipeManager() {
        instance = this;
        this.addBuiltinDrops();
    }

    public boolean addRecipe(IInputItemStack input, Collection<ItemStack> output, CompoundTag metadata, boolean replace) {
        if (!input.matches(IUItem.scrapBox)) {
            throw new IllegalArgumentException("currently only scrap boxes are supported");
        }
        if (metadata != null && metadata.contains("weight")) {
            if (output.size() != 1) {
                throw new IllegalArgumentException("currently only a single drop stack is supported");
            }
            float weight = metadata.getFloat("weight");
            if (!(weight <= 0.0f || Float.isInfinite(weight) || Float.isNaN(weight))) {
                this.addDrop(output.iterator().next(), weight);
                return true;
            }
            throw new IllegalArgumentException("invalid weight");
        }
        throw new IllegalArgumentException("no weight metadata");
    }

    public boolean addRecipe(IInputItemStack input, CompoundTag metadata, boolean replace, ItemStack ... outputs) {
        return this.addRecipe(input, Arrays.asList(outputs), metadata, replace);
    }

    public ItemStack apply(ItemStack input) {
        if (!ModUtils.isEmpty(input) && input.is(IUItem.scrapBox.getItem())) {
            if (this.drops.isEmpty()) {
                return ItemStack.EMPTY;
            }
            float chance = IUCore.random.nextFloat() * Drop.topChance;
            int low = 0;
            int high = this.drops.size() - 1;
            while (low < high) {
                int mid = (high + low) / 2;
                if (chance < this.drops.get((int)mid).upperChanceBound) {
                    high = mid;
                    continue;
                }
                low = mid + 1;
            }
            return this.drops.get((int)low).item.copy();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getRandomDrop() {
        if (this.drops.isEmpty()) {
            return ItemStack.EMPTY;
        }
        float chance = WorldBaseGen.random.nextFloat() * Drop.topChance;
        int low = 0;
        int high = this.drops.size() - 1;
        while (low < high) {
            int mid = (high + low) / 2;
            if (chance < this.drops.get((int)mid).upperChanceBound) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return this.drops.get((int)low).item;
    }

    public boolean isIterable() {
        return false;
    }

    public void addDrop(ItemStack drop, float rawChance) {
        this.drops.add(new Drop(drop, rawChance));
    }

    public ItemStack getDrop(ItemStack input) {
        return this.apply(input);
    }

    public Map<ItemStack, Float> getDrops() {
        HashMap<ItemStack, Float> ret = new HashMap<ItemStack, Float>(this.drops.size());
        for (Drop drop : this.drops) {
            ret.put(drop.item, Float.valueOf(drop.originalChance / Drop.topChance));
        }
        return ret;
    }

    private void addBuiltinDrops() {
        this.addDrop(Items.WOODEN_HOE, 5.01f);
        this.addDrop(Blocks.DIRT, 5.0f);
        this.addDrop(Items.STICK, 4.0f);
        this.addDrop(Blocks.GRASS_BLOCK, 3.0f);
        this.addDrop(Blocks.GRAVEL, 3.0f);
        this.addDrop(Blocks.NETHERRACK, 2.0f);
        this.addDrop(Items.ROTTEN_FLESH, 2.0f);
        this.addDrop(Items.APPLE, 1.5f);
        this.addDrop(Items.BREAD, 1.5f);
        this.addDrop(Items.WOODEN_SWORD, 1.0f);
        this.addDrop(Items.WOODEN_SHOVEL, 1.0f);
        this.addDrop(Items.WOODEN_PICKAXE, 1.0f);
        this.addDrop(Blocks.SOUL_SAND, 1.0f);
        this.addDrop(Blocks.OAK_SIGN, 1.0f);
        this.addDrop(Items.LEATHER, 1.0f);
        this.addDrop(Items.FEATHER, 1.0f);
        this.addDrop(Items.BONE, 1.0f);
        this.addDrop(Items.COOKED_PORKCHOP, 0.9f);
        this.addDrop(Items.COOKED_BEEF, 0.9f);
        this.addDrop(Blocks.PUMPKIN, 0.9f);
        this.addDrop(Items.COOKED_CHICKEN, 0.9f);
        this.addDrop(Items.MINECART, 0.01f);
        this.addDrop(Items.REDSTONE, 0.9f);
        this.addDrop(IUItem.rubber, 0.8f);
        this.addDrop(Items.GLOWSTONE_DUST, 0.8f);
        this.addDrop(IUItem.coalDust, 0.8f);
        this.addDrop(IUItem.copperDust, 0.8f);
        this.addDrop(IUItem.tinDust, 0.8f);
        this.addDrop(IUItem.ironDust, 0.7f);
        this.addDrop(IUItem.goldDust, 0.7f);
        this.addDrop(Items.SLIME_BALL, 0.6f);
        this.addDrop(Blocks.IRON_ORE, 0.5f);
        this.addDrop(Items.GOLDEN_HELMET, 0.01f);
        this.addDrop(Blocks.GOLD_ORE, 0.5f);
        this.addDrop(Items.CAKE, 0.5f);
        this.addDrop(Items.DIAMOND, 0.1f);
        this.addDrop(Items.EMERALD, 0.05f);
        this.addDrop(Items.ENDER_PEARL, 0.08f);
        this.addDrop(Items.BLAZE_ROD, 0.04f);
        this.addDrop(Items.EGG, 0.8f);
        this.addDrop(Blocks.COPPER_ORE, 0.7f);
        this.addDrop(IUItem.classic_ore.getItemStack(BlockClassicOre.Type.tin), 0.7f);
    }

    private void addDrop(Block block, float rawChance) {
        this.addDrop(new ItemStack((ItemLike)block), rawChance);
    }

    private void addDrop(Item item, float rawChance) {
        this.addDrop(new ItemStack((ItemLike)item), rawChance);
    }

    private static class Drop {
        static float topChance;
        final ItemStack item;
        final float originalChance;
        final float upperChanceBound;

        Drop(ItemStack item, float chance) {
            this.item = item;
            this.originalChance = chance;
            this.upperChanceBound = topChance += chance;
        }
    }
}

