/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.base;

import com.denfop.tiles.base.IIsMolecular;
import com.denfop.tiles.base.TileEntityBlock;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class RenderCoreProcess<T extends TileEntityBlock>
implements BlockEntityRenderer<T> {
    private static final Map<List<Serializable>, Integer> textureSizeCache = new HashMap<List<Serializable>, Integer>();
    private static final ResourceLocation plazmaTextloc = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/block/plazma.png");
    private static final ResourceLocation particlesTextloc = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/block/particles.png");
    public static int size1 = -1;
    public static int size2 = -1;
    private final BlockEntityRendererProvider.Context contex;
    private final Random random = new Random();
    public int ticker;
    float rotation;
    float prevRotation;

    public RenderCoreProcess(BlockEntityRendererProvider.Context p_173636_) {
        this.contex = p_173636_;
    }

    public static int getTextureSize(String s, int dv) {
        Integer textureSize = textureSizeCache.get(Arrays.asList(s, dv));
        if (textureSize != null) {
            return textureSize;
        }
        try {
            InputStream inputstream = ((Resource)Minecraft.getInstance().getResourceManager().getResource(ResourceLocation.tryBuild((String)"industrialupgrade", (String)s)).get()).open();
            BufferedImage bi = ImageIO.read(inputstream);
            int size = bi.getWidth() / dv;
            textureSizeCache.put(Arrays.asList(s, dv), size);
            return size;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return 16;
        }
    }

    public void render(T te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay) {
        if (((TileEntityBlock)((Object)te)).getActive()) {
            this.renderCore(te, poseStack, bufferSource, packedLight, combinedOverlay, partialTicks);
            this.renderItem((IIsMolecular)te, poseStack, bufferSource, packedLight, combinedOverlay, partialTicks);
        }
    }

    public void renderItem(IIsMolecular te, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float partialTicks) {
        ItemStack itemStack = te.getItemStack();
        if (itemStack.isEmpty()) {
            return;
        }
        BakedModel bakedModel = te.getBakedModel();
        if (bakedModel != null) {
            boolean isGui3d = bakedModel.isGui3d();
            poseStack.pushPose();
            int count = this.transformModelCount(te, poseStack, buffer, partialTicks);
            for (int i = 0; i < count; ++i) {
                poseStack.pushPose();
                if (isGui3d) {
                    if (i > 0) {
                        float xOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        yOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        float zOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        poseStack.translate(xOffset, yOffset, zOffset);
                    }
                } else if (i > 0) {
                    float xOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.075f;
                    yOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.075f;
                    poseStack.translate(xOffset, yOffset, 0.0f);
                }
                BakedModel transformedModel = te.getTransformedModel();
                this.contex.getItemRenderer().render(itemStack, ItemDisplayContext.FIXED, false, poseStack, buffer, light, overlay, transformedModel);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }

    private int transformModelCount(IIsMolecular itemIn, PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        ItemStack itemStack = itemIn.getItemStack();
        Item item = itemStack.getItem();
        if (item == Items.AIR) {
            return 0;
        }
        int modelCount = 1;
        float offsetY = 1.0f;
        poseStack.translate(0.5, (double)(0.25f * offsetY) + 0.25, 0.5);
        poseStack.scale(0.4f, 0.4f, 0.4f);
        this.prevRotation = this.rotation = (this.prevRotation + (this.rotation - this.prevRotation) * partialTicks) % 360.0f;
        this.rotation += 0.15f;
        poseStack.mulPose(Axis.YP.rotationDegrees(this.rotation));
        return modelCount;
    }

    private void renderCore(T te, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay, float partialTicks) {
        ++this.ticker;
        if (this.ticker % 2 != 0) {
            return;
        }
        if (this.ticker > 161) {
            this.ticker = 1;
        }
        if (size1 == -1) {
            size1 = RenderCoreProcess.getTextureSize("textures/models/plazma.png", 64);
        }
        if (size1 == -2) {
            size2 = RenderCoreProcess.getTextureSize("textures/models/particles.png", 32);
        }
        Camera camera = this.contex.getEntityRenderer().camera;
        Quaternionf rotation = camera.rotation();
        float scaleCore = 0.35f;
        Matrix4f matrix = poseStack.last().pose();
        float posX = 0.5f;
        float posY = 0.5f;
        float posZ = 0.5f;
        Color color = new Color(0xC0FFFF);
        poseStack.pushPose();
        poseStack.scale(scaleCore, scaleCore, scaleCore);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)plazmaTextloc);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        int i = this.ticker % 16;
        float size4 = size1 * 4;
        float float_sizeMinus0_01 = (float)size1 - 0.01f;
        float x0 = ((float)(i % 4 * size1) + 0.0f) / size4;
        float x1 = ((float)(i % 4 * size1) + float_sizeMinus0_01) / size4;
        float x2 = ((float)i / 4.0f * (float)size1 + 0.0f) / size4;
        float x3 = ((float)i / 4.0f * (float)size1 + float_sizeMinus0_01) / size4;
        Vec3 lookVec = new Vec3(camera.getLookVector());
        Vec3 upVec = new Vec3(camera.getUpVector());
        Vec3 rightVec = new Vec3(camera.getLeftVector());
        float f1 = (float)rightVec.x;
        float f2 = (float)rightVec.y;
        float f3 = (float)rightVec.z;
        float f4 = (float)upVec.x;
        float f5 = (float)upVec.z;
        buffer.addVertex(matrix, (float)((double)posX + rightVec.x * (double)(-scaleCore) + upVec.x * (double)(-scaleCore)), (float)((double)posY + rightVec.y * (double)(-scaleCore) + upVec.y * (double)(-scaleCore)), (float)((double)posZ + rightVec.z * (double)(-scaleCore) + upVec.z * (double)(-scaleCore))).setUv(x1, x3).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        buffer.addVertex(matrix, (float)((double)posX + rightVec.x * (double)(-scaleCore) + upVec.x * (double)scaleCore), (float)((double)posY + rightVec.y * (double)(-scaleCore) + upVec.y * (double)scaleCore), (float)((double)posZ + rightVec.z * (double)(-scaleCore) + upVec.z * (double)scaleCore)).setUv(x1, x2).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        buffer.addVertex(matrix, (float)((double)posX + rightVec.x * (double)scaleCore + upVec.x * (double)scaleCore), (float)((double)posY + rightVec.y * (double)scaleCore + upVec.y * (double)scaleCore), (float)((double)posZ + rightVec.z * (double)scaleCore + upVec.z * (double)scaleCore)).setUv(x0, x2).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        buffer.addVertex(matrix, (float)((double)posX + rightVec.x * (double)scaleCore + upVec.x * (double)(-scaleCore)), (float)((double)posY + rightVec.y * (double)scaleCore + upVec.y * (double)(-scaleCore)), (float)((double)posZ + rightVec.z * (double)scaleCore + upVec.z * (double)(-scaleCore))).setUv(x0, x3).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        poseStack.popPose();
        poseStack.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        int qq = this.ticker % 16;
        i = 24 + qq;
        float size8 = size2 * 8;
        float_sizeMinus0_01 = (float)size2 - 0.01f;
        x0 = ((float)(i % 8 * size2) + 0.0f) / size8;
        x1 = ((float)(i % 8 * size2) + float_sizeMinus0_01) / size8;
        x2 = ((float)i / 8.0f * (float)size2 + 0.0f) / size8;
        x3 = ((float)i / 8.0f * (float)size2 + float_sizeMinus0_01) / size8;
        float var11 = Mth.sin((float)((float)this.ticker / 10.0f)) * 0.1f;
        scaleCore = 0.4f + var11;
        buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)plazmaTextloc);
        if (((IIsMolecular)te).getMode() != 0) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.tryBuild((String)"industrialupgrade", (String)("textures/models/particles" + ((IIsMolecular)te).getMode() + ".png")));
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)particlesTextloc);
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        buffer.addVertex(matrix, (float)((double)posX + rightVec.x * (double)(-scaleCore) + upVec.x * (double)(-scaleCore)), (float)((double)posY + rightVec.y * (double)(-scaleCore) + upVec.y * (double)(-scaleCore)), (float)((double)posZ + rightVec.z * (double)(-scaleCore) + upVec.z * (double)(-scaleCore))).setUv(x1, x3).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        buffer.addVertex(matrix, (float)((double)posX + rightVec.x * (double)(-scaleCore) + upVec.x * (double)scaleCore), (float)((double)posY + rightVec.y * (double)(-scaleCore) + upVec.y * (double)scaleCore), (float)((double)posZ + rightVec.z * (double)(-scaleCore) + upVec.z * (double)scaleCore)).setUv(x1, x2).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        buffer.addVertex(matrix, (float)((double)posX + rightVec.x * (double)scaleCore + upVec.x * (double)scaleCore), (float)((double)posY + rightVec.y * (double)scaleCore + upVec.y * (double)scaleCore), (float)((double)posZ + rightVec.z * (double)scaleCore + upVec.z * (double)scaleCore)).setUv(x0, x2).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        buffer.addVertex(matrix, (float)((double)posX + rightVec.x * (double)scaleCore + upVec.x * (double)(-scaleCore)), (float)((double)posY + rightVec.y * (double)scaleCore + upVec.y * (double)(-scaleCore)), (float)((double)posZ + rightVec.z * (double)scaleCore + upVec.z * (double)(-scaleCore))).setUv(x0, x3).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }
}

