/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.panel;

import com.denfop.gui.GuiCore;
import com.denfop.render.panel.DataPollution;
import com.denfop.render.panel.PollutionModel;
import com.denfop.tiles.panels.entity.TileSolarPanel;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class TileEntitySolarPanelRender
implements BlockEntityRenderer<TileSolarPanel> {
    public static final ResourceLocation texture = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/models/pollution.png");
    private final BlockEntityRendererProvider.Context contex;
    private float rotation = 0.0f;
    private float prevRotation = 0.0f;
    private Map<BlockPos, DataPollution> entries = new HashMap<BlockPos, DataPollution>();

    public TileEntitySolarPanelRender(BlockEntityRendererProvider.Context context) {
        this.contex = context;
    }

    public void render(TileSolarPanel te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!te.canRender()) {
            return;
        }
        poseStack.pushPose();
        GuiCore.bindTexture(texture);
        DataPollution dataPollution = this.entries.get(te.getBlockPos());
        if (dataPollution == null) {
            dataPollution = new DataPollution(te.timer.getIndexWork(), new PollutionModel(te.getWorld().random, te.timer.getIndexWork()));
            this.entries.put(te.getBlockPos(), dataPollution);
        }
        if (dataPollution.getIndex() != te.timer.getIndexWork()) {
            dataPollution.setIndex(te.timer.getIndexWork());
            dataPollution.setModel(null);
        }
        if (dataPollution.getModel() == null) {
            dataPollution.setModel(new PollutionModel(te.getWorld().random, te.timer.getIndexWork()));
        }
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        dataPollution.getModel().renderToBuffer(poseStack, consumer, packedLight, packedOverlay, -1);
        poseStack.popPose();
    }
}

