/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.TileMagnet;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TileEntityAntiMagnet
extends TileEntityInventory {
    private static final List<AABB> aabbs = Collections.singletonList(new AABB(0.0, 0.0, 0.0, 1.0, 1.4, 1.0));
    public String player = "";

    public TileEntityAntiMagnet(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.antimagnet, pos, state);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        return false;
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        return aabbs;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.antimagnet.info"));
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            this.player = player.getName().getString();
            for (int x = this.pos.getX() - 10; x <= this.pos.getX() + 10; ++x) {
                for (int y = this.pos.getY() - 10; y <= this.pos.getY() + 10; ++y) {
                    for (int z = this.pos.getZ() - 10; z <= this.pos.getZ() + 10; ++z) {
                        BlockEntity tileEntity = this.getWorld().getBlockEntity(new BlockPos(x, y, z));
                        if (tileEntity == null || new BlockPos(x, y, z).equals((Object)this.pos) || !(tileEntity instanceof TileMagnet)) continue;
                        TileMagnet tile = (TileMagnet)tileEntity;
                        if (tile.player.equals(this.player)) continue;
                        tile.work = false;
                    }
                }
            }
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.antimagnet;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.player = nbttagcompound.getString("player");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putString("player", this.player);
        return nbttagcompound;
    }
}

