/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerDigger;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiDigger;
import com.denfop.invslot.InvSlotDigger;
import com.denfop.invslot.InvSlotInput;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileEntityAutoDigger
extends TileEntityInventory {
    public final InvSlotOutput outputSlot;
    public final Energy energy;
    public final InvSlotInput inputslot;
    public final InvSlotDigger slot_upgrade;
    public boolean mac_enabled = false;
    public boolean comb_mac_enabled = false;
    public boolean furnace = false;
    public int chance = 0;
    public int col = 1;
    public BaseMachineRecipe[] baseMachineRecipe = new BaseMachineRecipe[16];
    public double consume = 500.0;
    public double energyconsume = 500.0;

    public TileEntityAutoDigger(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.auto_digger, pos, state);
        this.outputSlot = new InvSlotOutput(this, 48);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 500000.0, 14));
        this.inputslot = new InvSlotInput(this, 16);
        this.slot_upgrade = new InvSlotDigger(this);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.5));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.5));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.excavator.info"));
        tooltip.add(Localization.translate("iu.excavator.info1"));
        super.addInformation(stack, tooltip);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.auto_digger;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.slot_upgrade.update();
        this.inputslot.update();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        for (int k = 0; k < this.col; ++k) {
            for (int i = 0; i < this.inputslot.size(); ++i) {
                BaseMachineRecipe baseMachineRecipe1 = this.baseMachineRecipe[i];
                if (baseMachineRecipe1 == null || !this.energy.canUseEnergy(this.consume) || !this.outputSlot.canAdd(baseMachineRecipe1.getOutput().items)) continue;
                this.energy.useEnergy(this.consume);
                for (ItemStack stack : baseMachineRecipe1.getOutput().items) {
                    this.outputSlot.add(stack);
                }
                this.inputslot.get(i).shrink(1);
                if (!this.inputslot.get(i).isEmpty()) continue;
                this.baseMachineRecipe[i] = null;
            }
        }
        if (this.level.getGameTime() % 20L == 0L && !this.outputSlot.isEmpty()) {
            ModUtils.tick(this.outputSlot, this);
        }
    }

    public void setBaseMachineRecipe(int slotid, BaseMachineRecipe baseMachineRecipe) {
        this.baseMachineRecipe[slotid] = baseMachineRecipe;
    }

    public ContainerDigger getGuiContainer(Player entityPlayer) {
        return new ContainerDigger(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiDigger((ContainerDigger)menu);
    }
}

