/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerWirelessMatterCollector;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiWirelessMatterCollector;
import com.denfop.tiles.base.IMatter;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileMultiMatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TileEntityWirelessMatterCollector
extends TileEntityInventory {
    private final Fluids fluids;
    private final Fluids.InternalFluidTank fluidTank;
    private final Energy energy;
    private final ComponentVisibleArea visible;
    Map<ChunkPos, List<IMatter>> chunkPosListMap = new HashMap<ChunkPos, List<IMatter>>();

    public TileEntityWirelessMatterCollector(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.matter_collector, pos, state);
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("tank", 0xFA0000, Fluids.fluidPredicate((Fluid)FluidName.fluiduu_matter.getInstance().get()));
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 10000.0, 14));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.15));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.15));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.matter_collector.info"));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        ChunkPos chunkPos = new ChunkPos(this.pos);
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                int chunkX = (chunkPos.x + dx) * 16;
                int chunkZ = (chunkPos.z + dz) * 16;
                if (chunkX < minX) {
                    minX = chunkX;
                }
                if (chunkZ < minZ) {
                    minZ = chunkZ;
                }
                if (chunkX + 15 > maxX) {
                    maxX = chunkX + 15;
                }
                if (chunkZ + 15 <= maxZ) continue;
                maxZ = chunkZ + 15;
            }
        }
        this.visible.aabb = new AABB((double)minX, (double)this.level.getMinBuildHeight(), (double)minZ, (double)maxX, (double)this.level.getMaxBuildHeight(), (double)maxZ);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.matter_collector;
    }

    public ContainerWirelessMatterCollector getGuiContainer(Player var1) {
        return new ContainerWirelessMatterCollector(this, var1);
    }

    public Fluids.InternalFluidTank getFluidTank() {
        return this.fluidTank;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiWirelessMatterCollector((ContainerWirelessMatterCollector)menu);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.level.getGameTime() % 200L == 0L) {
            ChunkPos chunkPos = new ChunkPos(this.pos);
            Map<ChunkPos, List<IMatter>> map = TileMultiMatter.worldMatterMap.get(this.level.dimension());
            this.chunkPosListMap.clear();
            if (map != null) {
                for (int x = -1; x < 2; ++x) {
                    for (int z = -1; z < 2; ++z) {
                        ChunkPos chunkPos1 = new ChunkPos(chunkPos.x + x, chunkPos.z + z);
                        List<IMatter> list = map.get(chunkPos1);
                        if (list == null) continue;
                        this.chunkPosListMap.put(chunkPos1, list);
                    }
                }
            }
        }
        boolean active = false;
        if (this.energy.getEnergy() > 30.0) {
            block2: for (Map.Entry<ChunkPos, List<IMatter>> chunkPosListEntry : this.chunkPosListMap.entrySet()) {
                if (this.energy.getEnergy() < 30.0) break;
                for (IMatter matter : chunkPosListEntry.getValue()) {
                    if (this.energy.getEnergy() < 30.0) continue block2;
                    int amount = matter.getMatterTank().getFluidAmount();
                    if ((amount = Math.min(amount, this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount())) <= 0) continue;
                    this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluiduu_matter.getInstance().get(), amount), IFluidHandler.FluidAction.EXECUTE);
                    matter.getMatterTank().drain(amount, IFluidHandler.FluidAction.EXECUTE);
                    this.energy.useEnergy(30.0);
                    active = true;
                }
            }
        }
        this.setActive(active);
    }

    public int getFilled(int i) {
        return (int)((double)(i * this.getFluidTank().getFluidAmount()) / ((double)this.getFluidTank().getCapacity() * 1.0));
    }

    public int getIntegerPercentage() {
        return (int)((double)(100 * this.getFluidTank().getFluidAmount()) / ((double)this.getFluidTank().getCapacity() * 1.0));
    }

    public Energy getEnergy() {
        return this.energy;
    }
}

