/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.container.ContainerApothecaryBee;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiApothecaryBee;
import com.denfop.gui.GuiCore;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.bee.TileEntityApiary;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileEntityApothecaryBee
extends TileEntityInventory {
    private static final int RADIUS = 4;
    public final ComponentBaseEnergy energy;
    AABB searchArea;
    List<List<TileEntityApiary>> list;
    List<ChunkPos> chunks;
    private ComponentVisibleArea visible;

    public TileEntityApothecaryBee(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.apothecary_bee, pos, state);
        this.searchArea = new AABB(ModUtils.getVecFromVec3i((Vec3i)this.pos.offset(-4, -4, -4)), ModUtils.getVecFromVec3i((Vec3i)this.pos.offset(5, 5, 5)));
        this.list = new ArrayList<List<TileEntityApiary>>();
        this.energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.QUANTUM, this, 20000.0));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.apothecary_bee;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.apothecary_bee.info"));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.visible.aabb = this.searchArea;
        if (!this.getWorld().isClientSide) {
            AABB aabb = this.searchArea;
            int j2 = Mth.floor((double)((aabb.minX - 2.0) / 16.0));
            int k2 = Mth.ceil((double)((aabb.maxX + 2.0) / 16.0));
            int l2 = Mth.floor((double)((aabb.minZ - 2.0) / 16.0));
            int i3 = Mth.ceil((double)((aabb.maxZ + 2.0) / 16.0));
            this.chunks = new ArrayList<ChunkPos>();
            for (int j3 = j2; j3 < k2; ++j3) {
                for (int k3 = l2; k3 < i3; ++k3) {
                    LevelChunk chunk = this.level.getChunk(j3, k3);
                    if (this.chunks.contains(chunk.getPos())) continue;
                    this.chunks.add(chunk.getPos());
                }
            }
            for (ChunkPos chunk : this.chunks) {
                this.list.add(BeeNetwork.instance.getApiaryFromChunk(this.level, chunk));
            }
        }
    }

    public ContainerApothecaryBee getGuiContainer(Player var1) {
        return new ContainerApothecaryBee(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiApothecaryBee((ContainerApothecaryBee)menu);
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.getX() > this.searchArea.minX && (double)vec.getX() < this.searchArea.maxX) {
            if ((double)vec.getY() > this.searchArea.minY && (double)vec.getY() < this.searchArea.maxY) {
                return (double)vec.getZ() > this.searchArea.minZ && (double)vec.getZ() < this.searchArea.maxZ;
            }
            return false;
        }
        return false;
    }

    private void updateBee() {
        this.list.clear();
        for (ChunkPos chunk : this.chunks) {
            this.list.add(BeeNetwork.instance.getApiaryFromChunk(this.level, chunk));
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().getGameTime() % 100L == 0L) {
            this.updateBee();
        }
        if (this.getWorld().getGameTime() % 20L == 0L && this.energy.canUseEnergy(50.0)) {
            block0: for (List<TileEntityApiary> bees : this.list) {
                for (TileEntityApiary bee : bees) {
                    if (!(this.energy.getEnergy() > 50.0) || bee.ill <= 0) break block0;
                    if (!this.contains(bee.getPos())) continue;
                    bee.healBeesFromApothecary(this);
                }
            }
        }
    }
}

