/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine1;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerBaseWitherMaker;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiWitherMaker;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.recipe.IInputHandler;
import com.denfop.recipe.IInputItemStack;
import com.denfop.tiles.base.TileBaseWitherMaker;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ParticleUtils;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileWitherMaker
extends TileBaseWitherMaker
implements IHasRecipe {
    public static SoundEvent[] soundEvents = new SoundEvent[]{EnumSound.WitherIdle1.getSoundEvent(), EnumSound.WitherHurt3.getSoundEvent()};

    public TileWitherMaker(BlockPos pos, BlockState state) {
        super(1, 1500, 1, (IMultiTileBlock)BlockBaseMachine1.gen_wither, pos, state);
        this.inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "wither", (IUpdateTick)this);
        Recipes.recipes.addInitRecipes(this);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
    }

    public static void GenerationMicrochip(IInputItemStack container, IInputItemStack fill2, ItemStack output) {
        Recipes.recipes.addRecipe("wither", new BaseMachineRecipe(new Input(container, container, container, fill2, fill2, fill2, fill2), new RecipeOutput(null, output)));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getActive() && this.level.getGameTime() % 5L == 0L) {
            ParticleUtils.spawnWitherFabricatorParticles(this.level, this.pos, this.level.random);
        }
    }

    @Override
    public void initiate(int soundEvent) {
        if (soundEvent == 3) {
            this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
            if (this.getSound() == null) {
                return;
            }
            if (!this.getEnable()) {
                return;
            }
            this.getWorld().playSound(null, this.getBlockPos(), soundEvents[this.getWorld().random.nextInt(soundEvents.length)], SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
            if (this.getSound() == null) {
                return;
            }
            if (!this.getEnable()) {
                return;
            }
            if (soundEvent == 0) {
                this.getWorld().playSound(null, this.getBlockPos(), this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (soundEvent == 1) {
                new PacketStopSound(this.getWorld(), this.getBlockPos());
                this.getWorld().playSound(null, this.getBlockPos(), EnumSound.InterruptOne.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                new PacketStopSound(this.getWorld(), this.getBlockPos());
                this.getWorld().playSound(null, this.getBlockPos(), EnumSound.WitherDeath1.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine1.gen_wither;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        TileWitherMaker.GenerationMicrochip(input.getInput(new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL), 1), input.getInput(new ItemStack((ItemLike)Blocks.SOUL_SAND), 1), new ItemStack((ItemLike)Items.NETHER_STAR, 1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiWitherMaker((ContainerBaseWitherMaker)isAdmin);
    }

    public ContainerBaseWitherMaker getGuiContainer(Player entityPlayer) {
        return new ContainerBaseWitherMaker(entityPlayer, this);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }
}

