/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.generator.energy.fluid;

import com.denfop.ElectricItem;
import com.denfop.IUItem;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerGasGenerator;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiGasGenerator;
import com.denfop.invslot.InvSlotCharge;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileEntityLiquidTankInventory;
import java.io.IOException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileGasGenerator
extends TileEntityLiquidTankInventory
implements IAudioFixer,
IUpdatableTileEvent {
    public final InvSlotCharge chargeSlot = new InvSlotCharge(this, 14);
    public final InvSlotFluid fluidSlot;
    public final InvSlotOutput outputSlot;
    public final Energy energy;
    public final int production = Math.round(450.0f);
    private final AirPollutionComponent pollutionAir;
    private final SoilPollutionComponent pollutionSoil;
    public boolean addedToEnergyNet = false;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    private boolean sound = true;

    public TileGasGenerator(BlockPos pos, BlockState state) {
        super(24, BlockBaseMachine3.gas_generator, pos, state);
        this.fluidSlot = new InvSlotFluidByList((TileEntityInventory)this, "fluidSlot", 1, (Fluid)FluidName.fluidgas.getInstance().get(), InvSlotFluid.TypeFluidSlot.INPUT);
        this.outputSlot = new InvSlotOutput(this, 1);
        this.energy = this.addComponent(Energy.asBasicSource(this, 5.0E7, 3));
        ((Fluids.InternalFluidTank)this.getFluidTank()).setAcceptedFluids(Fluids.fluidPredicate((Fluid)FluidName.fluidgas.getInstance().get()));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.3));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.75));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.gas_generator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        this.sound = !this.sound;
        new PacketUpdateFieldTile(this, "sound", this.sound);
        if (!this.sound && this.getTypeAudio() == EnumTypeAudio.ON) {
            this.setType(EnumTypeAudio.OFF);
            this.initiate(2);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.getWorld().playSound(null, this.pos, this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.getWorld(), this.pos);
            this.getWorld().playSound(null, this.pos, EnumSound.InterruptOne.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.getWorld(), this.pos);
        }
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.gas.getSoundEvent();
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.sound = nbttagcompound.getBoolean("sound");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putBoolean("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.sound = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.sound);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        if (this.needsFluid() && this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        this.setActive(this.gainEnergy());
        if (this.energy.getEnergy() >= 1.0 && !this.chargeSlot.get(0).isEmpty()) {
            double used = ElectricItem.manager.charge(this.chargeSlot.get(0), this.energy.getEnergy(), 1, false, false);
            this.energy.useEnergy(used);
        }
        if (this.getWorld().getGameTime() % 60L == 0L) {
            this.initiate(2);
        }
    }

    public float getWrenchDropRate() {
        return 0.9f;
    }

    public boolean gainEnergy() {
        if (this.isConverting()) {
            this.energy.addEnergy(this.production);
            this.getFluidTank().drain(2, IFluidHandler.FluidAction.EXECUTE);
            if (this.getWorld().getGameTime() % 200L == 0L) {
                this.initiate(0);
            }
            return true;
        }
        this.initiate(2);
        return false;
    }

    public boolean isConverting() {
        return this.getTankAmount() > 0 && this.energy.getEnergy() + (double)this.production <= this.energy.getCapacity();
    }

    public int gaugeStorageScaled(int i) {
        return (int)(this.energy.getEnergy() * (double)i / this.energy.getCapacity());
    }

    public ContainerGasGenerator getGuiContainer(Player entityPlayer) {
        return new ContainerGasGenerator(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiGasGenerator((ContainerGasGenerator)menu);
    }

    @Override
    public void onNetworkEvent(int var1) {
    }
}

