/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class DataEntities {
    List<EntityType<?>> entityList;
    Map<ResourceLocation, EntityType<?>> mapList = new HashMap();

    public DataEntities() {
        this.entityList = new ArrayList(BuiltInRegistries.ENTITY_TYPE.stream().toList());
        this.entityList.forEach(entityType -> this.mapList.put(BuiltInRegistries.ENTITY_TYPE.getKey(entityType), (EntityType<?>)entityType));
    }

    public boolean contains(ResourceLocation location) {
        return this.mapList.containsKey(location);
    }

    public EntityType<?> getTypeFromResourceLocation(ResourceLocation location) {
        return this.mapList.get(location);
    }

    public Entity createEntityByIDFromName(ResourceLocation entityId, Level world) {
        EntityType<?> entityType = this.mapList.get(entityId);
        return entityType == null ? null : entityType.create(world);
    }
}

