/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.IMultiUpdateTick;
import com.denfop.api.recipe.IRecipeInputStack;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeArrayList;
import com.denfop.api.recipe.RecipeInputStack;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.componets.ProcessMultiComponent;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemRecipeSchedule;
import com.denfop.recipe.IInputItemStack;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class InvSlotMultiRecipes
extends InvSlot {
    private final IMultiUpdateTick tile;
    private final ProcessMultiComponent processMultiComponent;
    private final RecipeArrayList<IRecipeInputStack> default_accepts;
    public MachineRecipe recycler_output;
    MachineRecipe[] prev = new MachineRecipe[8];
    private RecipeArrayList<IRecipeInputStack> accepts;
    private List<BaseMachineRecipe> recipe_list;
    private IBaseRecipe recipe;
    private FluidTank tank;

    public InvSlotMultiRecipes(TileEntityInventory base, IBaseRecipe baseRecipe, IMultiUpdateTick tile, int size, ProcessMultiComponent processMultiComponent) {
        super(base, InvSlot.TypeItemSlot.INPUT, size);
        this.recipe = baseRecipe;
        this.recipe_list = Recipes.recipes.getRecipeList(this.recipe.getName());
        this.tile = tile;
        this.tank = null;
        this.accepts = Recipes.recipes.getMap_recipe_managers_itemStack(this.recipe.getName());
        this.default_accepts = this.accepts;
        this.recycler_output = new MachineRecipe(new BaseMachineRecipe(null, new RecipeOutput(null, IUItem.scrap)), Collections.singletonList(1));
        this.processMultiComponent = processMultiComponent;
    }

    @Override
    public boolean hasItemList() {
        return true;
    }

    @Override
    public List<IInputItemStack> getStacks(int index) {
        ArrayList<IInputItemStack> uniqueStacks = new ArrayList<IInputItemStack>();
        HashSet<IInputItemStack> seenStacks = new HashSet<IInputItemStack>();
        for (IInputItemStack input : this.accepts.stream().map(IRecipeInputStack::getInput).toList()) {
            boolean isNew = seenStacks.stream().noneMatch(existing -> existing.equals(input));
            if (!isNew) continue;
            seenStacks.add(input);
            uniqueStacks.add(input);
        }
        return uniqueStacks;
    }

    public InvSlotMultiRecipes(TileEntityInventory base, String baseRecipe, IMultiUpdateTick tile, int size, ProcessMultiComponent processMultiComponent) {
        this(base, Recipes.recipes.getRecipe(baseRecipe), tile, size, processMultiComponent);
    }

    public InvSlotMultiRecipes(TileEntityInventory base, String baseRecipe, IMultiUpdateTick tile, FluidTank tank, int size, ProcessMultiComponent processMultiComponent) {
        this(base, Recipes.recipes.getRecipe(baseRecipe), tile, size, processMultiComponent);
        this.tank = tank;
    }

    public void changeAccepts(ItemStack stack) {
        if (stack.m_41619_()) {
            this.accepts = this.default_accepts;
        } else {
            ItemRecipeSchedule itemRecipeSchedule = (ItemRecipeSchedule)stack.m_41720_();
            this.accepts = itemRecipeSchedule.getInputs(this.recipe, stack);
        }
    }

    public IBaseRecipe getRecipe() {
        return this.recipe;
    }

    public void load() {
        this.recipe_list = Recipes.recipes.getRecipeList(this.recipe.getName());
        if (this.recipe.getName().equals("recycler")) {
            this.recycler_output = new MachineRecipe(new BaseMachineRecipe(null, new RecipeOutput(null, IUItem.scrap)), Collections.singletonList(1));
        }
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        if (!this.recipe.getName().equals("recycler")) {
            ItemStack input = this.get(index);
            if (input.m_41619_()) {
                this.tile.setRecipeOutput(null, index);
            } else {
                MachineRecipe recipe = this.prev[index];
                if (recipe == null) {
                    this.prev[index] = this.process(index);
                    this.tile.setRecipeOutput(this.prev[index], index);
                } else if (recipe.getRecipe().input.getInputs().get(0).matches(input)) {
                    this.tile.setRecipeOutput(recipe, index);
                } else {
                    this.prev[index] = this.process(index);
                    this.tile.setRecipeOutput(this.prev[index], index);
                }
            }
        } else {
            this.processMultiComponent.getOutput(index);
        }
        this.tile.onUpdate();
        return content;
    }

    public BaseMachineRecipe consume(MachineRecipe recipe) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).m_41619_()) continue;
            return null;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>((Collection<ItemStack>)this.contents);
        if (this.tank == null) {
            return Recipes.recipes.getRecipeConsume(this.recipe, recipe, this.recipe.consume(), list);
        }
        return Recipes.recipes.getRecipeOutputFluid(this.recipe.getName(), this.recipe.consume(), list, this.tank);
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        if (this.recipe.getName().equals("recycler") && !itemStack.m_41619_()) {
            return true;
        }
        return !itemStack.m_41619_() && !(itemStack.m_41720_() instanceof IUpgradeItem) && (this.recipe.getName().equals("painter") || this.recipe.getName().equals("upgradeblock") || this.recipe.getName().equals("recycler") || (!this.recipe.getName().equals("furnace") ? this.accepts.contains(itemStack) : this.accepts.contains(new RecipeInputStack(itemStack))));
    }

    public void consume(int number, int amount) {
        this.consume(number, amount, false, false);
    }

    public void consume(int number, int amount, boolean simulate, boolean consumeContainers) {
        ItemStack stack = this.get(number);
        if (!stack.m_41619_() && stack.m_41613_() >= 1 && this.accepts(stack, number) && (stack.m_41613_() >= 1 || consumeContainers || !stack.m_41720_().hasCraftingRemainingItem(stack))) {
            int currentAmount = Math.min(amount, stack.m_41613_());
            if (!simulate) {
                if (stack.m_41613_() == currentAmount) {
                    if (!consumeContainers && stack.m_41720_().hasCraftingRemainingItem(stack)) {
                        this.set(number, stack.m_41720_().getCraftingRemainingItem(stack));
                    } else {
                        this.set(number, null);
                    }
                } else {
                    stack.m_41764_(stack.m_41613_() - currentAmount);
                }
            }
        }
    }

    @Override
    public ItemStack get(int index) {
        return super.get(index);
    }

    public boolean continue_proccess(InvSlotOutput slot, int slotid) {
        if (this.tile.getRecipeOutput(slotid) == null) {
            return false;
        }
        if (!this.recipe.getName().equals("recycler")) {
            return slot.addWithoutIgnoring(this.tile.getRecipeOutput((int)slotid).getRecipe().output.items, true) && this.get(slotid).m_41613_() >= this.tile.getRecipeOutput(slotid).getList().get(0);
        }
        return !this.get(slotid).m_41619_() && slot.canAdd(this.tile.getRecipeOutput((int)slotid).getRecipe().output.items);
    }

    public MachineRecipe process(int slotid) {
        if (this.get(slotid).m_41619_()) {
            return null;
        }
        return this.getOutputFor(slotid);
    }

    public MachineRecipe fastprocess(int slotid) {
        if (this.get(slotid).m_41619_()) {
            return null;
        }
        MachineRecipe output = this.getOutputFor(slotid);
        return output;
    }

    public MachineRecipe consume(int slotid) {
        if (this.get(slotid).m_41619_()) {
            if (this.fastprocess(slotid) == null) {
                return null;
            }
            throw new NullPointerException();
        }
        if (!this.recipe.getName().equals("recycler")) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(this.get(slotid));
            if (this.tank == null) {
                return Recipes.recipes.getMachineRecipeConsume(this.recipe, this.tile.getRecipeOutput(slotid), this.recipe.consume(), list);
            }
            return Recipes.recipes.getRecipeOutputMachineFluid(this.recipe.getName(), this.recipe.consume(), list, this.tank);
        }
        this.get(slotid).m_41774_(1);
        return this.recycler_output;
    }

    private MachineRecipe getOutputFor(int slotid) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.get(slotid));
        if (this.tank == null) {
            return Recipes.recipes.getRecipeMachineMultiOutput(this.recipe, this.recipe_list, false, list);
        }
        return Recipes.recipes.getRecipeOutputMachineFluid(this.recipe.getName(), false, list, this.tank);
    }

    public void setNameRecipe(String nameRecipe) {
        this.recipe = Recipes.recipes.getRecipe(nameRecipe);
        this.recipe_list = Recipes.recipes.getRecipeList(this.recipe.getName());
        this.accepts = Recipes.recipes.getMap_recipe_managers_itemStack(this.recipe.getName());
    }

    public void consume(int slotid, int size, Integer integer) {
        this.get(slotid).m_41774_(size * integer);
    }
}

