/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.api.heat.IHeatAcceptor;
import com.denfop.api.heat.IHeatEmitter;
import com.denfop.api.heat.IHeatSink;
import com.denfop.api.heat.IHeatSource;
import com.denfop.api.heat.IHeatTile;
import com.denfop.api.heat.event.HeatTileLoadEvent;
import com.denfop.api.heat.event.HeatTileUnloadEvent;
import com.denfop.api.sytem.InfoTile;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.TypePurifierJob;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class HeatComponent
extends AbstractComponent {
    public final Level world;
    public final boolean fullEnergy;
    private final double defaultCapacity;
    public double capacity;
    public double storage;
    public int sinkTier;
    public int sourceTier;
    public Set<Direction> sinkDirections;
    public Set<Direction> sourceDirections;
    public List<InvSlot> managedSlots;
    public boolean multiSource = false;
    public int sourcePackets = 1;
    public EnergyNetDelegate delegate;
    public boolean loaded;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    public boolean need;
    public boolean auto;
    public boolean allow;
    Random rand = new Random();
    Map<Direction, IHeatTile> energyHeatConductorMap = new HashMap<Direction, IHeatTile>();
    List<InfoTile<IHeatTile>> validHeatReceivers = new LinkedList<InfoTile<IHeatTile>>();
    private double coef;

    public HeatComponent(TileEntityInventory parent, double capacity) {
        this(parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public HeatComponent(TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int tier) {
        this(parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public HeatComponent(TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.capacity = capacity;
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        this.fullEnergy = fullEnergy;
        this.world = parent.m_58904_();
        this.defaultCapacity = capacity;
        this.need = true;
        this.allow = false;
        this.coef = 0.0;
    }

    public static HeatComponent asBasicSink(TileEntityInventory parent, double capacity) {
        return HeatComponent.asBasicSink(parent, capacity, 1);
    }

    public static HeatComponent asBasicSink(TileEntityInventory parent, double capacity, int tier) {
        return new HeatComponent(parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static HeatComponent asBasicSource(TileEntityInventory parent, double capacity) {
        return HeatComponent.asBasicSource(parent, capacity, 1);
    }

    public static HeatComponent asBasicSource(TileEntityInventory parent, double capacity, int tier) {
        return new HeatComponent(parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        this.storage = nbt.m_128459_("storage");
        this.capacity = nbt.m_128459_("capacity");
        this.need = nbt.m_128471_("need");
        this.allow = nbt.m_128471_("allow");
        this.auto = nbt.m_128471_("auto");
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer packet = super.updateComponent();
        packet.writeDouble(this.capacity);
        packet.writeDouble(this.storage);
        packet.writeBoolean(this.need);
        packet.writeBoolean(this.allow);
        packet.writeBoolean(this.auto);
        return packet;
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag ret = new CompoundTag();
        ret.m_128347_("storage", this.storage);
        ret.m_128347_("capacity", this.capacity);
        ret.m_128379_("need", this.need);
        ret.m_128379_("allow", this.allow);
        ret.m_128379_("auto", this.auto);
        return ret;
    }

    @Override
    public void onLoaded() {
        assert (this.delegate == null);
        if (this.capacity < this.defaultCapacity) {
            this.capacity = this.defaultCapacity;
        }
        if (!this.parent.m_58904_().f_46443_) {
            if (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty()) {
                this.createDelegate();
                this.validHeatReceivers.clear();
                this.energyHeatConductorMap.clear();
                MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this.delegate, this.parent.m_58904_()));
            }
            this.loaded = true;
            Level world = this.parent.m_58904_();
            BlockPos pos = this.parent.m_58899_();
            Biome biome = (Biome)world.m_204166_(pos).m_203334_();
            this.coef = biome.m_198904_(pos) ? -1.0 : (biome.m_198904_(pos) ? 1.0 : 0.0);
        }
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public boolean canUsePurifier(Player player) {
        return this.auto;
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        this.auto = false;
        return new ItemStack((ItemLike)IUItem.autoheater.getItem());
    }

    public void createDelegate() {
        if (this.delegate == null) {
            assert (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty());
            if (this.sinkDirections.isEmpty()) {
                this.delegate = new EnergyNetDelegateSource();
            } else if (this.sourceDirections.isEmpty()) {
                this.delegate = new EnergyNetDelegateSink();
            }
            if (this.delegate == null) {
                return;
            }
            this.delegate.m_142339_(this.parent.m_58904_());
        }
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> ret = super.getDrops();
        if (this.auto) {
            ret.add(new ItemStack((ItemLike)IUItem.autoheater.getItem()));
        }
        return ret;
    }

    @Override
    public boolean onBlockActivated(Player player, InteractionHand hand) {
        super.onBlockActivated(player, hand);
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_().equals(IUItem.autoheater.getItem()) && !this.auto) {
            this.auto = true;
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    @Override
    public void onUnloaded() {
        if (this.delegate != null) {
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this.delegate, this.parent.m_58904_()));
            this.delegate = null;
        }
        this.loaded = false;
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeDouble(this.capacity);
        buffer.writeDouble(this.storage);
        buffer.writeBoolean(this.need);
        buffer.writeBoolean(this.allow);
        buffer.writeBoolean(this.auto);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.capacity = is.readDouble();
        this.storage = is.readDouble();
        this.need = is.readBoolean();
        this.allow = is.readBoolean();
        this.auto = is.readBoolean();
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
        if (this.storage > this.capacity) {
            this.storage = this.capacity;
        }
    }

    public double getEnergy() {
        return this.storage;
    }

    public double getFillRatio() {
        return this.storage / this.capacity;
    }

    public double addEnergy(double amount) {
        this.storage += amount;
        if (this.coef != 0.0 && this.rand.nextInt(2) == 1) {
            this.storage += 7.0 * this.coef;
        }
        this.storage = Math.min(this.storage, this.capacity);
        this.storage = Math.max(this.storage, 0.0);
        return amount;
    }

    public boolean canUseEnergy(double amount) {
        return this.storage >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.storage >= amount) {
            this.storage -= amount;
            if (this.rand.nextInt(2) == 1 && this.coef == -1.0) {
                this.storage -= 1.0;
            }
            if (this.storage < 0.0) {
                this.storage = 0.0;
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.auto && this.getEnergy() + 1.0 <= this.getCapacity()) {
            this.addEnergy(2.0);
        }
    }

    public double useEnergy(double amount, boolean simulate) {
        double ret = Math.abs(Math.max(0.0, amount - this.storage) - amount);
        if (!simulate) {
            this.storage -= ret;
            if (this.rand.nextInt(2) == 1 && this.coef == -1.0) {
                this.storage -= 1.0;
            }
            if (this.storage < 0.0) {
                this.storage = 0.0;
            }
        }
        return ret;
    }

    public int getSinkTier() {
        return this.sinkTier;
    }

    public void setSinkTier(int tier) {
        this.sinkTier = tier;
    }

    public int getSourceTier() {
        return this.sourceTier;
    }

    public void setSourceTier(int tier) {
        this.sourceTier = tier;
    }

    public void setEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
        this.receivingDisabled = this.sendingSidabled;
    }

    public void setReceivingEnabled(boolean enabled) {
        this.receivingDisabled = !enabled;
    }

    public void setSendingEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
    }

    public void setDirections(Set<Direction> sinkDirections, Set<Direction> sourceDirections) {
        if (this.delegate != null) {
            assert (!this.parent.m_58904_().f_46443_);
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this.delegate, this.world));
        }
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        if (sinkDirections.isEmpty() && sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.createDelegate();
        }
        if (this.delegate != null) {
            assert (!this.parent.m_58904_().f_46443_);
            this.validHeatReceivers.clear();
            this.energyHeatConductorMap.clear();
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this.delegate, this.world));
        }
    }

    public Set<Direction> getSourceDirs() {
        return Collections.unmodifiableSet(this.sourceDirections);
    }

    public Set<Direction> getSinkDirs() {
        return Collections.unmodifiableSet(this.sinkDirections);
    }

    public IHeatTile getDelegate() {
        return this.delegate;
    }

    private abstract class EnergyNetDelegate
    extends BlockEntity
    implements IHeatTile {
        private EnergyNetDelegate() {
            super(HeatComponent.this.parent.m_58903_(), HeatComponent.this.parent.m_58899_(), HeatComponent.this.parent.m_58900_());
        }
    }

    private class EnergyNetDelegateSource
    extends EnergyNetDelegate
    implements IHeatSource {
        int hashCodeSource;
        private long id;

        private EnergyNetDelegateSource() {
        }

        public int getSourceTier() {
            return HeatComponent.this.sourceTier;
        }

        @Override
        public boolean emitsHeatTo(IHeatAcceptor receiver, Direction dir) {
            return HeatComponent.this.sourceDirections.contains(dir);
        }

        @Override
        public double getOfferedHeat() {
            return HeatComponent.this.storage;
        }

        @Override
        @NotNull
        public BlockPos getPos() {
            return HeatComponent.this.parent.m_58899_();
        }

        @Override
        public void drawHeat(double amount) {
        }

        @Override
        public long getIdNetwork() {
            return this.id;
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void setId(long id) {
            this.id = id;
        }

        @Override
        public void AddHeatTile(IHeatTile tile, Direction dir) {
            if (!this.m_58904_().f_46443_) {
                HeatComponent.this.energyHeatConductorMap.put(dir, tile);
                HeatComponent.this.validHeatReceivers.add(new InfoTile<IHeatTile>(tile, dir.m_122424_()));
            }
        }

        @Override
        public void RemoveHeatTile(IHeatTile tile, Direction dir) {
            if (!this.m_58904_().f_46443_) {
                HeatComponent.this.energyHeatConductorMap.remove(dir);
                Iterator<InfoTile<IHeatTile>> iter = HeatComponent.this.validHeatReceivers.iterator();
                while (iter.hasNext()) {
                    InfoTile<IHeatTile> tileInfoTile = iter.next();
                    if (tileInfoTile.tileEntity != tile) continue;
                    iter.remove();
                    break;
                }
            }
        }

        @Override
        public Map<Direction, IHeatTile> getHeatTiles() {
            return HeatComponent.this.energyHeatConductorMap;
        }

        @Override
        public List<InfoTile<IHeatTile>> getHeatValidReceivers() {
            return HeatComponent.this.validHeatReceivers;
        }

        @Override
        public boolean isAllowed() {
            return HeatComponent.this.allow;
        }

        @Override
        public boolean setAllowed(boolean allowed) {
            HeatComponent.this.allow = allowed;
            return HeatComponent.this.allow;
        }

        @Override
        public BlockEntity getTile() {
            return HeatComponent.this.parent;
        }
    }

    private class EnergyNetDelegateSink
    extends EnergyNetDelegate
    implements IHeatSink {
        List<IHeatSource> list = new LinkedList<IHeatSource>();
        int hashCodeSource;
        private long id;

        private EnergyNetDelegateSink() {
        }

        public int getSinkTier() {
            return HeatComponent.this.sinkTier;
        }

        @Override
        public boolean acceptsHeatFrom(IHeatEmitter emitter, Direction dir) {
            return HeatComponent.this.sinkDirections.contains(dir);
        }

        @Override
        public List<IHeatSource> getEnergyTickList() {
            return this.list;
        }

        @Override
        @NotNull
        public BlockPos getPos() {
            return HeatComponent.this.parent.m_58899_();
        }

        @Override
        public double getDemandedHeat() {
            return HeatComponent.this.capacity;
        }

        @Override
        public long getIdNetwork() {
            return this.id;
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void setId(long id) {
            this.id = id;
        }

        @Override
        public void AddHeatTile(IHeatTile tile, Direction dir) {
            if (!this.m_58904_().f_46443_) {
                HeatComponent.this.energyHeatConductorMap.put(dir, tile);
                HeatComponent.this.validHeatReceivers.add(new InfoTile<IHeatTile>(tile, dir.m_122424_()));
            }
        }

        @Override
        public void RemoveHeatTile(IHeatTile tile, Direction dir) {
            if (!this.m_58904_().f_46443_) {
                HeatComponent.this.energyHeatConductorMap.remove(dir);
                Iterator<InfoTile<IHeatTile>> iter = HeatComponent.this.validHeatReceivers.iterator();
                while (iter.hasNext()) {
                    InfoTile<IHeatTile> tileInfoTile = iter.next();
                    if (tileInfoTile.tileEntity != tile) continue;
                    iter.remove();
                    break;
                }
            }
        }

        @Override
        public Map<Direction, IHeatTile> getHeatTiles() {
            return HeatComponent.this.energyHeatConductorMap;
        }

        @Override
        public List<InfoTile<IHeatTile>> getHeatValidReceivers() {
            return HeatComponent.this.validHeatReceivers;
        }

        @Override
        public void receivedHeat(double amount) {
            this.setHeatStored(amount);
        }

        @Override
        public boolean needTemperature() {
            return HeatComponent.this.need;
        }

        public void setHeatStored(double amount) {
            if (HeatComponent.this.storage < amount) {
                HeatComponent.this.storage = amount;
            }
        }

        @Override
        public BlockEntity getTile() {
            return HeatComponent.this.parent;
        }
    }
}

