/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.ElectricItem;
import com.denfop.Localization;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.ScrollDirection;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiIU;
import com.denfop.items.relocator.ItemStackRelocator;
import com.denfop.items.relocator.Point;
import com.denfop.items.relocator.RelocatorNetwork;
import com.denfop.network.packet.PacketRelocatorTeleportPlayer;
import com.denfop.network.packet.PacketRemoveRelocatorPoint;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GuiRelocator<T extends ContainerBase<ItemStackRelocator>>
extends GuiIU<ContainerBase<ItemStackRelocator>> {
    private int value;

    public GuiRelocator(ContainerBase<ItemStackRelocator> guiContainer) {
        super(guiContainer);
        this.f_97726_ = 176;
        this.f_97727_ = 98;
        this.componentList.clear();
        if (((ItemStackRelocator)guiContainer.base).player.m_9236_().f_46443_) {
            ((ItemStackRelocator)this.container.base).points = new ArrayList<Point>(RelocatorNetwork.instance.getPoints(((ItemStackRelocator)guiContainer.base).player));
            this.value = 0;
        }
    }

    @Override
    public boolean m_6050_(double d, double d2, double d3) {
        ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
        int mouseX = (int)(d - (double)this.guiLeft);
        int mouseY = (int)(d2 - (double)this.guiTop);
        if (mouseX >= 7 && mouseY >= 18 && mouseX <= 168 && mouseY <= 78) {
            if (scrollDirection == ScrollDirection.up) {
                --this.value;
                this.value = Math.max(this.value, 0);
            } else if (scrollDirection == ScrollDirection.down) {
                ++this.value;
                this.value = Math.min(this.value, ((ItemStackRelocator)this.container.base).points.size() / 4);
            }
        }
        return super.m_6050_(d, d2, d3);
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        List<Point> pointList = ((ItemStackRelocator)this.container.base).points;
        int xMin = (this.f_96543_ - this.f_97726_) / 2;
        int yMin = (this.f_96544_ - this.f_97727_) / 2;
        int x = i - xMin;
        int y = j - yMin;
        for (int index = 4 * this.value; index < Math.min(4 + 4 * this.value, pointList.size()); ++index) {
            int x1 = 10;
            int y1 = 20 + 15 * (index % 4);
            int x2 = 153;
            int y2 = 20 + 15 * (index % 4);
            if (x >= x2 && x <= x2 + 12 && y >= y2 && y <= y2 + 11) {
                new PacketRelocatorTeleportPlayer((Player)this.f_96541_.f_91074_, pointList.get(index));
                ItemStack stack = ((ItemStackRelocator)this.container.base).itemStack1;
                if (ElectricItem.manager.canUse(stack, 1000000.0)) {
                    this.f_96541_.f_91074_.m_6915_();
                }
            }
            if (x < x1 || x > x1 + 12 || y < y1 || y > y1 + 11) continue;
            new PacketRemoveRelocatorPoint((Player)this.f_96541_.f_91074_, pointList.get(index));
            this.f_96541_.f_91074_.m_6915_();
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        List<Point> pointList = ((ItemStackRelocator)this.container.base).points = new ArrayList<Point>(RelocatorNetwork.instance.getPoints(((ItemStackRelocator)this.container.base).player));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 4 * this.value; i < Math.min(4 + 4 * this.value, pointList.size()); ++i) {
            String originalName = pointList.get(i).getName();
            String truncatedName = originalName.length() > 10 ? originalName.substring(0, 10) : originalName;
            Point point = pointList.get(i);
            this.draw(poseStack, truncatedName, 24, 22 + 15 * (i % 4), ModUtils.convertRGBcolorToInt(255, 255, 255));
            ((Area)new Area(this, 7, 22 + 20 * (i % 4), 160, 14).withTooltip(point.getPos().toString().substring(8))).drawForeground(poseStack, par1, par2);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        this.bindTexture();
        poseStack.m_280218_(currentTexture, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        String name = Localization.translate(((ItemStackRelocator)this.container.base).itemStack1.m_41778_());
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        PoseStack pose = poseStack.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        int centerX = this.guiLeft + this.f_97726_ / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop + 8) / scale);
        poseStack.m_280056_(Minecraft.m_91087_().f_91062_, name, textX, textY, ModUtils.convertRGBcolorToInt(255, 255, 255), false);
        pose.m_85841_(1.0f / scale, 1.0f / scale, 1.0f);
        pose.m_85849_();
        this.bindTexture();
        List<Point> pointList = ((ItemStackRelocator)this.container.base).points;
        for (int i = 4 * this.value; i < Math.min(4 + 4 * this.value, pointList.size()); ++i) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 8, this.guiTop + 19 + 15 * (i % 4), 8, 171, 160, 14);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guirelocator.png");
    }
}

