/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Area;
import com.denfop.container.ContainerSolarGeneratorEnergy;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileSolarGeneratorEnergy;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiSolarGeneratorEnergy<T extends ContainerSolarGeneratorEnergy>
extends GuiIU<ContainerSolarGeneratorEnergy> {
    private static final ResourceLocation background = new ResourceLocation("industrialupgrade", "textures/gui/SunnariumGenerator.png".toLowerCase());
    private final ContainerSolarGeneratorEnergy container;
    private final String name;

    public GuiSolarGeneratorEnergy(ContainerSolarGeneratorEnergy container1) {
        super(container1, ((TileSolarGeneratorEnergy)container1.base).getStyle());
        this.componentList.clear();
        this.container = container1;
        this.name = Localization.translate(((TileSolarGeneratorEnergy)container1.base).getName());
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft(), this.guiTop(), 0, 0, this.f_97726_, this.f_97727_);
        String name = Localization.translate(((TileSolarGeneratorEnergy)this.container.base).getName());
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        PoseStack pose = poseStack.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        int centerX = this.guiLeft() + this.f_97726_ / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop() + 6) / scale);
        this.draw(poseStack, name, textX, textY, 0x404040);
        pose.m_85849_();
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(poseStack, mouseX, mouseY);
        this.handleUpgradeTooltip(mouseX, mouseY);
        String tooltip = "SE: " + ModUtils.getString(((TileSolarGeneratorEnergy)this.container.base).sunenergy.getEnergy());
        ((Area)new Area(this, 66, 33, 53, 10).withTooltip(tooltip)).drawForeground(poseStack, mouseX, mouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.draw(poseStack, Localization.translate("gui.SuperSolarPanel.generating") + ": " + (int)((TileSolarGeneratorEnergy)this.container.base).generation + Localization.translate("iu.machines_work_energy_type_se"), 29, 61, ModUtils.convertRGBcolorToInt(13, 229, 34));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.solar_generator_info"));
            List<String> compatibleUpgrades = ListInformationUtils.solar;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiSolarGeneratorEnergy.bindTexture(background);
        int j = this.guiLeft();
        int k = this.guiTop();
        this.drawBackground(poseStack);
        GuiSolarGeneratorEnergy.bindTexture(background);
        if (((TileSolarGeneratorEnergy)this.container.base).sunenergy.getEnergy() > 0.0) {
            int i1 = (int)(52.0 * ((TileSolarGeneratorEnergy)this.container.base).sunenergy.getFillRatio());
            this.drawTexturedModalRect(poseStack, j + 66, k + 33, 179, 3, i1 + 1, 10);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiSolarGeneratorEnergy.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, j + 3, k + 3, 0, 0, 10, 10);
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }
}

