/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jade;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.agriculture.ICrop;
import com.denfop.api.bee.IBee;
import com.denfop.api.cool.ICoolSource;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyConductor;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.NodeStats;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.sytem.EnergyBase;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.sytem.IConductor;
import com.denfop.api.sytem.ITile;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.ProcessMultiComponent;
import com.denfop.integration.jade.Progress;
import com.denfop.recipe.IInputItemStack;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileEntityAnvil;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileEntityStrongAnvil;
import com.denfop.tiles.bee.TileEntityApiary;
import com.denfop.tiles.crop.TileEntityCrop;
import com.denfop.tiles.mechanism.TileEntityCompressor;
import com.denfop.tiles.mechanism.TileEntityDryer;
import com.denfop.tiles.mechanism.TileEntityMacerator;
import com.denfop.tiles.mechanism.TileEntityPrimalLaserPolisher;
import com.denfop.tiles.mechanism.TileEntityPrimalWireInsulator;
import com.denfop.tiles.mechanism.TileEntityRollingMachine;
import com.denfop.tiles.mechanism.TileEntitySqueezer;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.IProgressStyle;

public class BlockComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final BlockComponentProvider INSTANCE = new BlockComponentProvider();

    public ResourceLocation getUid() {
        return new ResourceLocation("industrialupgrade", "component_provider_blockentity");
    }

    public boolean isRequired() {
        return true;
    }

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        IElementHelper elements = IElementHelper.get();
        CompoundTag data = blockAccessor.getServerData();
        if (data.m_128441_("info")) {
            ListTag listTag = data.m_128437_("info", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.m_128728_(i);
                this.writeData(compoundTag, iTooltip, blockAccessor, iPluginConfig, elements);
            }
        }
    }

    private void writeData(CompoundTag compoundTag, ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig, IElementHelper elements) {
        Object o = this.decode(compoundTag);
        if (o instanceof String) {
            iTooltip.add(elements.text((Component)Component.m_237113_((String)((String)o))));
        } else if (o instanceof Double) {
            iTooltip.add(elements.text((Component)Component.m_237113_((String)String.valueOf((Double)o))));
        } else if (o instanceof Integer) {
            iTooltip.add(elements.text((Component)Component.m_237113_((String)String.valueOf((Integer)o))));
        } else if (o instanceof Progress) {
            Progress progressType = (Progress)o;
            float progress = (float)progressType.getProgress() * 1.0f / (float)progressType.getMax();
            MutableComponent label = Component.m_237113_((String)(progressType.getPrefix() + ChatFormatting.WHITE + progressType.getProgress() + " " + progressType.getSuffix()));
            IProgressStyle style = iTooltip.getElementHelper().progressStyle().color(ModUtils.convertRGBAcolorToInt(progressType.getR(), progressType.getG(), progressType.getB()), ModUtils.convertRGBAcolorToInt(progressType.getR(), progressType.getG(), progressType.getB()));
            iTooltip.add(elements.progress(progress, (Component)label, style, (IBoxStyle)BoxStyle.DEFAULT, false));
        } else if (o instanceof ItemStack) {
            iTooltip.add(elements.item((ItemStack)o));
        }
    }

    public Object decode(CompoundTag compoundTag) {
        byte type = compoundTag.m_128445_("type_field");
        switch (type) {
            case 0: {
                return compoundTag.m_128461_("value_field");
            }
            case 1: {
                return compoundTag.m_128451_("value_field");
            }
            case 2: {
                return compoundTag.m_128459_("value_field");
            }
            case 3: {
                return ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("value_field"));
            }
            case 4: {
                return compoundTag.m_128448_("value_field");
            }
            case 5: {
                int progress = compoundTag.m_128451_("value_field");
                int max = compoundTag.m_128451_("value_field1");
                String suffix = compoundTag.m_128461_("value_field2");
                int r = compoundTag.m_128451_("value_field3");
                int g = compoundTag.m_128451_("value_field4");
                int b = compoundTag.m_128451_("value_field5");
                String prefix = compoundTag.m_128461_("value_field7");
                return new Progress(progress, max, suffix, r, g, b, prefix);
            }
        }
        return null;
    }

    public void encode(Object o, ListTag listTag) {
        CompoundTag compoundTag = new CompoundTag();
        if (o instanceof String) {
            compoundTag.m_128344_("type_field", (byte)0);
            compoundTag.m_128359_("value_field", (String)o);
        } else if (o instanceof Integer) {
            compoundTag.m_128344_("type_field", (byte)1);
            compoundTag.m_128405_("value_field", ((Integer)o).intValue());
        } else if (o instanceof Double) {
            compoundTag.m_128344_("type_field", (byte)2);
            compoundTag.m_128347_("value_field", ((Double)o).doubleValue());
        } else if (o instanceof ItemStack) {
            compoundTag.m_128344_("type_field", (byte)3);
            compoundTag.m_128365_("value_field", (Tag)((ItemStack)o).m_41739_(new CompoundTag()));
        } else if (o instanceof Short) {
            compoundTag.m_128344_("type_field", (byte)4);
            compoundTag.m_128376_("value_field", ((Short)o).shortValue());
        } else if (o instanceof Progress) {
            compoundTag.m_128344_("type_field", (byte)5);
            Progress progress = (Progress)o;
            compoundTag.m_128405_("value_field", progress.getProgress());
            compoundTag.m_128405_("value_field1", progress.getMax());
            compoundTag.m_128359_("value_field2", progress.getSuffix());
            compoundTag.m_128405_("value_field3", progress.getR());
            compoundTag.m_128405_("value_field4", progress.getG());
            compoundTag.m_128405_("value_field5", progress.getB());
            compoundTag.m_128359_("value_field7", progress.getPrefix());
        }
        listTag.add((Object)compoundTag);
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
        Level level = accessor.getLevel();
        BlockEntity blockEntity = accessor.getBlockEntity();
        Player entityPlayer = accessor.getPlayer();
        if (blockEntity instanceof TileEntityBlock) {
            TileEntityApiary apiary;
            TileEntityCrop tileEntityCrop;
            Double percent;
            TileEntityInventory anvil;
            ListTag listTag = new ListTag();
            TileEntityBlock te = (TileEntityBlock)blockEntity;
            if (te.wrenchCanRemove(entityPlayer)) {
                this.encode(ChatFormatting.WHITE + Localization.translate("iu.wrench.info"), listTag);
            }
            ComponentProgress component = te.getComp(ComponentProgress.class);
            ComponentProcess component1 = te.getComp(ComponentProcess.class);
            ProcessMultiComponent component2 = te.getComp(ProcessMultiComponent.class);
            if (te instanceof TileEntityAnvil) {
                TileEntityAnvil anvil2 = (TileEntityAnvil)te;
                Double percent2 = anvil2.data.getOrDefault(entityPlayer.m_20148_(), 0.0);
                String percentString = String.format("%.1f", percent2);
                this.encode(ChatFormatting.GREEN + Localization.translate("iu.primitive_master") + " " + (String)percentString, listTag);
                this.encode(ChatFormatting.GRAY + Localization.translate("iu.primitive_anvil_durability") + " " + anvil2.durability, listTag);
                this.encode(new Progress(anvil2.progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            Level world = level;
            if (te instanceof IEnergyConductor) {
                NodeStats node = EnergyNetGlobal.instance.getNodeStats((IEnergyTile)((Object)te), te.getWorld());
                this.encode(new Progress((int)node.getEnergyOut(), (int)((IEnergyConductor)((Object)te)).getConductorBreakdownEnergy(), "EF", 33, 91, 199), listTag);
            }
            if (te instanceof IConductor) {
                IConductor conductor = (IConductor)((Object)te);
                if (conductor.hasEnergies()) {
                    for (EnergyType type : conductor.getEnergies()) {
                        NodeStats node = EnergyBase.getGlobal(type).getNodeStats((ITile)((Object)te), world);
                        if (node == null) continue;
                        if (type == EnergyType.QUANTUM) {
                            this.encode(new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "QE", 91, 94, 98), listTag);
                            continue;
                        }
                        if (type == EnergyType.SOLARIUM) {
                            this.encode(new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "SE", 224, 212, 18), listTag);
                            continue;
                        }
                        if (type == EnergyType.EXPERIENCE) {
                            this.encode(new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "EE", 76, 172, 32), listTag);
                            continue;
                        }
                        if (type == EnergyType.RADIATION) {
                            this.encode(new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "\u2622", 42, 196, 45), listTag);
                            continue;
                        }
                        if (type != EnergyType.POSITRONS) continue;
                        this.encode(new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "e\u207a", 192, 0, 218), listTag);
                    }
                } else {
                    EnergyType type = conductor.getEnergyType();
                    NodeStats node = EnergyBase.getGlobal(type).getNodeStats((ITile)((Object)te), world);
                    if (type == EnergyType.QUANTUM) {
                        this.encode(new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "QE", 91, 94, 98), listTag);
                    } else if (type == EnergyType.SOLARIUM) {
                        this.encode(new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "SE", 224, 212, 18), listTag);
                    } else if (type == EnergyType.EXPERIENCE) {
                        this.encode(new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "EE", 76, 172, 32), listTag);
                    } else if (type == EnergyType.RADIATION) {
                        this.encode(new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "\u2622", 42, 196, 45), listTag);
                    } else if (type == EnergyType.POSITRONS) {
                        this.encode(new Progress((int)node.getEnergyOut(), (int)conductor.getConductorBreakdownEnergy(type), "e\u207a", 192, 0, 218), listTag);
                    }
                }
            }
            if (te instanceof TileEntityStrongAnvil) {
                anvil = (TileEntityStrongAnvil)te;
                percent = anvil.data.getOrDefault(entityPlayer.m_20148_(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(ChatFormatting.GREEN + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(new Progress(anvil.progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof TileEntityCrop && (tileEntityCrop = (TileEntityCrop)te).getCrop() != null) {
                boolean isWeed;
                ItemStack stack;
                ICrop crop = tileEntityCrop.getCrop();
                int tick = crop.getTick();
                int maxTick = crop.getMaxTick();
                this.encode(new Progress(tick, maxTick, " / " + maxTick + " " + Localization.translate("iu.crop.oneprobe.growth"), -23296), listTag);
                ItemStack soil = crop.getSoil().getStack();
                if (!soil.m_41619_()) {
                    this.encode(ChatFormatting.YELLOW + Localization.translate("iu.crop.oneprobe.soil"), listTag);
                    this.encode(soil, listTag);
                }
                if (!crop.getDrops().isEmpty() && !(stack = crop.getDrops().get(0)).m_41619_()) {
                    this.encode(ChatFormatting.AQUA + Localization.translate("iu.crop.oneprobe.drop"), listTag);
                    this.encode(stack, listTag);
                }
                this.encode(ChatFormatting.GREEN + Localization.translate("iu.crop.oneprobe.using") + " " + Localization.translate("iu.crop.oneprobe.fertilizer") + " " + tileEntityCrop.getPestUse() + " / 40", listTag);
                this.encode(new ItemStack((ItemLike)IUItem.fertilizer.getItem()), listTag);
                int pesticidesTime = tileEntityCrop.getTickPest();
                int maxPesticidesTime = 7000;
                this.encode(Localization.translate("iu.crop.oneprobe.pesticide_time"), listTag);
                this.encode(new Progress(pesticidesTime == 0 ? pesticidesTime : maxPesticidesTime - pesticidesTime, maxPesticidesTime, " / " + maxPesticidesTime + " t", -16711936), listTag);
                int generation = crop.getGeneration();
                this.encode(ChatFormatting.LIGHT_PURPLE + Localization.translate("iu.crop.oneprobe.generation") + generation, listTag);
                this.encode(ChatFormatting.YELLOW + Localization.translate("iu.crop.oneprobe.genes") + tileEntityCrop.getGenome().getGeneticTraitsMap().values().size(), listTag);
                boolean bl = isWeed = crop.getId() == 3;
                if (isWeed) {
                    this.encode(ChatFormatting.RED + Localization.translate("iu.crop.oneprobe.weed_warning"), listTag);
                }
            }
            if (te instanceof TileEntityApiary && (apiary = (TileEntityApiary)te).getQueen() != null) {
                IBee queen = apiary.getQueen();
                this.encode(ChatFormatting.GOLD + Localization.translate("iu.crop.oneprobe.queen") + ChatFormatting.BOLD + queen.getName(), listTag);
                this.encode(new Progress((int)apiary.food, apiary.maxFood, " / " + apiary.maxFood + " " + Localization.translate("iu.crop.oneprobe.honey"), -23296), listTag);
                this.encode(new Progress((int)apiary.royalJelly, apiary.maxJelly, " / " + apiary.maxJelly + " " + Localization.translate("iu.crop.oneprobe.royal_jelly"), ModUtils.convertRGBAcolorToInt(146, 146, 146)), listTag);
                this.encode(ChatFormatting.GREEN + Localization.translate("iu.crop.oneprobe.workers") + apiary.workers, listTag);
                this.encode(ChatFormatting.YELLOW + Localization.translate("iu.crop.oneprobe.builders") + apiary.builders, listTag);
                this.encode(ChatFormatting.RED + Localization.translate("iu.crop.oneprobe.guards") + apiary.attacks, listTag);
                this.encode(ChatFormatting.BLUE + Localization.translate("iu.crop.oneprobe.medics") + apiary.doctors, listTag);
                this.encode(ChatFormatting.DARK_RED + Localization.translate("iu.crop.oneprobe.sick") + apiary.ill, listTag);
                this.encode(ChatFormatting.LIGHT_PURPLE + Localization.translate("iu.crop.oneprobe.new_bees") + apiary.birthBeeList.size(), listTag);
                String nameMainFlower = Localization.translate("crop." + queen.getCropFlower().getName());
                this.encode(ChatFormatting.AQUA + Localization.translate("iu.crop.oneprobe.main_flower") + nameMainFlower, listTag);
                InvSlotOutput stacks = apiary.invSlotProduct;
                this.encode(ChatFormatting.GOLD + Localization.translate("iu.crop.oneprobe.products"), listTag);
                boolean hasProducts = false;
                for (ItemStack stack : stacks) {
                    if (stack.m_41619_()) continue;
                    this.encode(stack, listTag);
                    hasProducts = true;
                }
                if (!hasProducts) {
                    this.encode(ChatFormatting.DARK_GRAY + Localization.translate("iu.crop.oneprobe.no_resources"), listTag);
                }
                this.encode(ChatFormatting.GOLD + Localization.translate("iu.crop.oneprobe.frames"), listTag);
                boolean hasFrames = false;
                for (ItemStack stack : apiary.frameSlot) {
                    if (stack.m_41619_()) continue;
                    this.encode(stack, listTag);
                    hasFrames = true;
                }
                if (!hasFrames) {
                    this.encode(ChatFormatting.DARK_GRAY + Localization.translate("iu.crop.oneprobe.no_frames"), listTag);
                }
                this.encode(ChatFormatting.YELLOW + Localization.translate("iu.crop.oneprobe.genes_count") + apiary.getGenome().getGeneticTraitsMap().values().size(), listTag);
            }
            if (te instanceof TileEntityCompressor) {
                anvil = (TileEntityCompressor)te;
                percent = ((TileEntityCompressor)anvil).data.getOrDefault(entityPlayer.m_20148_(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(ChatFormatting.GREEN + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(ChatFormatting.GRAY + Localization.translate("iu.primitive_anvil_durability") + " " + ((TileEntityCompressor)anvil).durability, listTag);
                this.encode(new Progress(((TileEntityCompressor)anvil).progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof TileEntityMacerator) {
                anvil = (TileEntityMacerator)te;
                percent = ((TileEntityMacerator)anvil).data.getOrDefault(entityPlayer.m_20148_(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(ChatFormatting.GREEN + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(ChatFormatting.GRAY + Localization.translate("iu.primitive_anvil_durability") + " " + ((TileEntityMacerator)anvil).durability, listTag);
                this.encode(new Progress(((TileEntityMacerator)anvil).progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof TileEntityPrimalWireInsulator) {
                anvil = (TileEntityPrimalWireInsulator)te;
                percent = ((TileEntityPrimalWireInsulator)anvil).data.getOrDefault(entityPlayer.m_20148_(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(ChatFormatting.GREEN + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(new Progress(((TileEntityPrimalWireInsulator)anvil).progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof TileEntityRollingMachine) {
                anvil = (TileEntityRollingMachine)te;
                percent = ((TileEntityRollingMachine)anvil).data.getOrDefault(entityPlayer.m_20148_(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(ChatFormatting.GREEN + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(new Progress(((TileEntityRollingMachine)anvil).progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof TileEntityPrimalLaserPolisher) {
                anvil = (TileEntityPrimalLaserPolisher)te;
                percent = ((TileEntityPrimalLaserPolisher)anvil).data.getOrDefault(entityPlayer.m_20148_(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(ChatFormatting.GREEN + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(new Progress(((TileEntityPrimalLaserPolisher)anvil).progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof TileEntitySqueezer) {
                anvil = (TileEntitySqueezer)te;
                percent = ((TileEntitySqueezer)anvil).data.getOrDefault(entityPlayer.m_20148_(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(ChatFormatting.GREEN + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(new Progress(((TileEntitySqueezer)anvil).progress, 150, " / 150", 0x5AFFFF), listTag);
            }
            if (te instanceof TileEntityDryer) {
                anvil = (TileEntityDryer)te;
                percent = ((TileEntityDryer)anvil).data.getOrDefault(entityPlayer.m_20148_(), 0.0);
                String percentString = String.format("%.1f", percent);
                this.encode(ChatFormatting.GREEN + Localization.translate("iu.primitive_master") + " " + percentString, listTag);
                this.encode(new Progress(((TileEntityDryer)anvil).progress, 100, " / 100", 0x5AFFFF), listTag);
            }
            if (te instanceof IManufacturerBlock) {
                IManufacturerBlock manufacturerBlock = (IManufacturerBlock)((Object)te);
                this.encode(ChatFormatting.WHITE + Localization.translate("iu.manufacturer_level.info") + manufacturerBlock.getLevelMechanism() + "/10", listTag);
            }
            if (component != null) {
                IUpdateTick updateTick;
                double progress = component.getBar();
                int percentage = (int)(progress * 100.0);
                this.encode(new Progress(component.getProgress(), component.getMaxValue(), "t", 255, 255, 255), listTag);
                if (component1 != null && (updateTick = (IUpdateTick)((Object)component1.getParent())).getRecipeOutput() != null) {
                    List<IInputItemStack> inputs = updateTick.getRecipeOutput().getRecipe().input.getInputs();
                    List<ItemStack> outputs = updateTick.getRecipeOutput().getRecipe().output.items;
                    if (!inputs.isEmpty()) {
                        this.encode(ChatFormatting.YELLOW + Localization.translate("iu.probe.recipe.input") + " ", listTag);
                        for (IInputItemStack input : inputs) {
                            int index = (int)(level.m_46467_() % (long)input.getInputs().size());
                            this.encode(input.getInputs().get(index), listTag);
                        }
                    }
                    if (!outputs.isEmpty()) {
                        this.encode(ChatFormatting.AQUA + Localization.translate("iu.probe.recipe.output") + " ", listTag);
                        int index = (int)(level.m_46467_() % (long)outputs.size());
                        this.encode(outputs.get(index), listTag);
                    }
                }
                this.encode(ChatFormatting.GREEN + Localization.translate("iu.probe.recipe.progress") + " " + percentage + "%", listTag);
            }
            if (te instanceof TileEntityInventory) {
                ArrayList<String> stringList = new ArrayList<String>();
                ((TileEntityInventory)te).addInformation(((TileEntityInventory)te).getPickBlock(null, null), stringList);
                for (String s : stringList) {
                    this.encode(s, listTag);
                }
                for (AbstractComponent comp : te.getComponentList()) {
                    if (comp instanceof Energy) {
                        this.encode(new Progress((int)((Energy)comp).getEnergy(), (int)((Energy)comp).getCapacity(), "EF", 33, 91, 199), listTag);
                    }
                    if (comp instanceof ComponentBaseEnergy) {
                        ComponentBaseEnergy componentBaseEnergy = (ComponentBaseEnergy)comp;
                        if (componentBaseEnergy.getType() == EnergyType.QUANTUM) {
                            this.encode(new Progress((int)((ComponentBaseEnergy)comp).getEnergy(), (int)((ComponentBaseEnergy)comp).getCapacity(), "QE", 91, 94, 98), listTag);
                        } else if (componentBaseEnergy.getType() == EnergyType.SOLARIUM) {
                            this.encode(new Progress((int)((ComponentBaseEnergy)comp).getEnergy(), (int)((ComponentBaseEnergy)comp).getCapacity(), "SE", 224, 212, 18), listTag);
                        } else if (componentBaseEnergy.getType() == EnergyType.EXPERIENCE) {
                            this.encode(new Progress((int)((ComponentBaseEnergy)comp).getEnergy(), (int)((ComponentBaseEnergy)comp).getCapacity(), "EE", 76, 172, 32), listTag);
                        } else if (componentBaseEnergy.getType() == EnergyType.RADIATION) {
                            this.encode(new Progress((int)((ComponentBaseEnergy)comp).getEnergy(), (int)((ComponentBaseEnergy)comp).getCapacity(), "\u2622", 42, 196, 45), listTag);
                        } else if (componentBaseEnergy.getType() == EnergyType.POSITRONS) {
                            this.encode(new Progress((int)((ComponentBaseEnergy)comp).getEnergy(), (int)((ComponentBaseEnergy)comp).getCapacity(), "e\u207a", 192, 0, 218), listTag);
                        }
                    }
                    if (comp instanceof CoolComponent) {
                        CoolComponent coolComponent = (CoolComponent)comp;
                        boolean isRefrigerator = coolComponent.delegate instanceof ICoolSource;
                        if (!coolComponent.upgrade) {
                            if (!isRefrigerator) {
                                this.encode(new Progress((int)coolComponent.getEnergy(), (int)coolComponent.getCapacity(), "\u00b0C", 190, 23, 20, Localization.translate("iu.temperature")), listTag);
                            } else {
                                this.encode(new Progress((int)coolComponent.getEnergy(), (int)coolComponent.getCapacity(), "\u00b0C", 33, 98, 208, Localization.translate("iu.temperature") + (coolComponent.getEnergy() > 0.0 ? "-" : "")), listTag);
                            }
                        }
                    }
                    if (!(comp instanceof HeatComponent)) continue;
                    HeatComponent heatComponent = (HeatComponent)comp;
                    this.encode(new Progress((int)heatComponent.getEnergy(), (int)heatComponent.getCapacity(), "\u00b0C", 208, 61, 33, Localization.translate("iu.temperature")), listTag);
                }
            }
            compoundTag.m_128365_("info", (Tag)listTag);
        }
    }
}

