/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.cokeoven;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.cokeoven.CokeOvenHandler;
import com.denfop.tiles.mechanism.TileEntityLaserPolisher;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;

public class CokeOvenCategory
extends GuiIU
implements IRecipeCategory<CokeOvenHandler> {
    private final IDrawableStatic bg;
    private int progress = 0;
    JeiInform jeiInform;

    public CokeOvenCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileEntityLaserPolisher)BlockBaseMachine3.laser_polisher.getDummyTe()).getGuiContainer1((Player)Minecraft.m_91087_().f_91074_));
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guicokeoven.png"), 5, 5, 168, 92);
    }

    public RecipeType<CokeOvenHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(new ItemStack(IUItem.cokeoven.getItem(), 1).m_41778_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(CokeOvenHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        int xScale = (int)(38.0 * (double)this.progress / 100.0);
        if ((double)xScale >= 38.0) {
            this.progress = 0;
        }
        CokeOvenCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 83, 41, 177, 19, xScale, 11);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CokeOvenHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 57, 38).addItemStack(recipe.getStack());
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 17).setFluidRenderer(10000L, true, 12, 47).addFluidStack((Fluid)FluidName.fluidsteam.getInstance().get(), 1000L);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 128, 17).setFluidRenderer(10000L, true, 12, 47).addFluidStack(recipe.getOutput().getFluid(), (long)recipe.getOutput().getAmount());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guicokeoven.png");
    }
}

