/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.quantummolecular;

import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class QuantumMolecularHandler {
    private static final List<QuantumMolecularHandler> recipes = new ArrayList<QuantumMolecularHandler>();
    private final double energy;
    private final ItemStack input;
    private final ItemStack input1;
    private final ItemStack output;
    public final String inputText;
    public final String inputText1;
    public final String outputText;
    public final String totalEU;

    public QuantumMolecularHandler(ItemStack input, ItemStack input1, ItemStack output, double energy) {
        this.input = input;
        this.input1 = input1;
        this.output = output;
        this.energy = energy;
        String inputText = null;
        String inputText1 = null;
        if (!this.input.m_41619_() && !this.input1.m_41619_()) {
            inputText = input.m_41611_().getString();
            inputText1 = input1.m_41611_().getString();
        }
        this.inputText = Localization.translate("gui.MolecularTransformer.input") + ": " + inputText;
        this.inputText1 = Localization.translate("gui.MolecularTransformer.input") + ": " + inputText1;
        this.outputText = Localization.translate("gui.MolecularTransformer.output") + ": " + output.m_41611_().getString();
        this.totalEU = String.format("%s %s %s", Localization.translate("gui.MolecularTransformer.energyPerOperation") + ":", ModUtils.getString(energy), Localization.translate("iu.generic.text.EF"));
    }

    public static List<QuantumMolecularHandler> getRecipes() {
        if (recipes.isEmpty()) {
            QuantumMolecularHandler.initRecipes();
        }
        return recipes;
    }

    public static QuantumMolecularHandler addRecipe(ItemStack input, ItemStack input1, ItemStack output, double energy) {
        QuantumMolecularHandler recipe = new QuantumMolecularHandler(input, input1, output, energy);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static QuantumMolecularHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (QuantumMolecularHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("quantummolecular")) {
            QuantumMolecularHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.input.getInputs().get(1).getInputs().get(0), container.getOutput().items.get(0), container.getOutput().metadata.m_128459_("energy"));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getInput1() {
        return this.input1;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

