/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.sunnarium;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.sunnarium.SunnariumHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.tiles.mechanism.TileEntityStampMechanism;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SunnariumCategory
extends GuiIU
implements IRecipeCategory<SunnariumHandler> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;
    JeiInform jeiInform;

    public SunnariumCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileEntityStampMechanism)BlockBaseMachine3.stamp_mechanism.getDummyTe()).getGuiContainer((Player)Minecraft.m_91087_().f_91074_));
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/GuiSunnariumMaker".toLowerCase() + ".png"), 3, 3, 140, 77);
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
    }

    public RecipeType<SunnariumHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.sunnariumpanelmaker).m_41778_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(SunnariumHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        int xScale = (int)(17.0f * (float)this.progress / 100.0f);
        int xScale1 = (int)(13.0f * (float)this.progress / 100.0f);
        if ((float)xScale > 17.0f) {
            this.progress = 0;
        }
        SunnariumCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 9, 73 - energylevel, 176, 14 - energylevel, 14, energylevel);
        this.drawTexturedModalRect(stack, 46, 21, 177, 20, xScale + 1, 33);
        this.drawTexturedModalRect(stack, 82, 21, 177, 56, xScale1 + 1, 33);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SunnariumHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 29, 18).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 65, 18).addItemStack(recipe.getInput1());
        builder.addSlot(RecipeIngredientRole.INPUT, 29, 40).addItemStack(recipe.getInput2());
        builder.addSlot(RecipeIngredientRole.INPUT, 65, 40).addItemStack(recipe.getInput3());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 100, 29).addItemStack(recipe.getOutput());
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(recipe.getContainer().input.getAllStackInputs());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GuiSunnariumMaker.png".toLowerCase());
    }
}

