/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.IUItem;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.invslot.InvSlot;
import com.denfop.items.modules.ItemAdditionModule;
import com.denfop.items.modules.ItemQuarryModule;
import com.denfop.tiles.base.TileAnalyzer;
import com.denfop.tiles.mechanism.quarry.TileBaseQuantumQuarry;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;

public class InvSlotAnalyzer
extends InvSlot
implements ITypeSlot {
    private final int type;
    private final TileAnalyzer tile;
    private int stackSizeLimit;

    public InvSlotAnalyzer(TileAnalyzer base1, String name, int count, int type) {
        super(base1, InvSlot.TypeItemSlot.INPUT, count);
        this.type = type;
        this.stackSizeLimit = 1;
        this.tile = base1;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        if (this.type == 0) {
            return EnumTypeSlot.QUARRY1;
        }
        return EnumTypeSlot.BLOCKS;
    }

    @Override
    public void update() {
        if (this.type == 0) {
            this.tile.blacklist = this.getblacklist();
            this.tile.whitelist = this.getwhitelist();
            this.tile.size = this.getChunksize();
            this.tile.lucky = this.lucky();
            this.tile.macerator = this.macerator();
            this.tile.comb_macerator = this.comb_macerator();
            this.tile.polisher = this.polisher();
            this.tile.consume = this.getenergycost();
            this.tile.update_chunk();
            this.tile.furnace = this.getFurnaceModule();
        }
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        if (this.type == 0) {
            this.tile.blacklist = this.getblacklist();
            this.tile.whitelist = this.getwhitelist();
            this.tile.size = this.getChunksize();
            this.tile.lucky = this.lucky();
            this.tile.consume = this.getenergycost();
            this.tile.macerator = this.macerator();
            this.tile.polisher = this.polisher();
            this.tile.comb_macerator = this.comb_macerator();
            this.tile.furnace = this.getFurnaceModule();
        }
        return content;
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        if (this.type == 0) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i).m_41619_() || !(itemStack.m_41720_() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) != IUItem.module9.getMeta((ItemQuarryModule)itemStack.m_41720_()) || this.get(i).m_41720_() != itemStack.m_41720_()) continue;
                return false;
            }
            return itemStack.m_41720_() instanceof ItemQuarryModule || itemStack.m_41720_().equals(IUItem.quarrymodule.getItem()) || itemStack.m_41720_() instanceof ItemAdditionModule && IUItem.module7.getMeta((ItemAdditionModule)itemStack.m_41720_()) == 10;
        }
        if (this.type == 1) {
            if (itemStack.m_220173_().m_203616_().collect(Collectors.toList()).size() > 0) {
                List id = itemStack.m_220173_().m_203616_().collect(Collectors.toList());
                String name = ((TagKey)id.get(0)).f_203868_().m_135815_();
                return name.startsWith("ore");
            }
            return false;
        }
        return false;
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    public boolean quarry() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !this.get(i).m_41720_().equals(IUItem.quarrymodule.getItem())) continue;
            return true;
        }
        return false;
    }

    public boolean macerator() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) != 14) continue;
            return true;
        }
        return false;
    }

    public boolean comb_macerator() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) != 15) continue;
            return true;
        }
        return false;
    }

    public boolean polisher() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) != 16) continue;
            return true;
        }
        return false;
    }

    public int lucky() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) < 6 || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) >= 9) continue;
            return IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) - 5;
        }
        return 0;
    }

    public boolean getFurnaceModule() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) != 0) continue;
            return true;
        }
        return false;
    }

    public List<String> getblacklist() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) != 12) continue;
            CompoundTag nbt = ModUtils.nbt(this.get(i));
            int size = nbt.m_128451_("size");
            for (int j = 0; j < size; ++j) {
                String l = "number_" + j;
                String temp = ModUtils.NBTGetString(this.get(i), l);
                list.add(temp);
            }
        }
        return list;
    }

    public List<String> getwhitelist() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) != 13) continue;
            CompoundTag nbt = ModUtils.nbt(this.get(i));
            int size = nbt.m_128451_("size");
            for (int j = 0; j < size; ++j) {
                String l = "number_" + j;
                String temp = ModUtils.NBTGetString(this.get(i), l);
                list.add(temp);
            }
            break;
        }
        return list;
    }

    public boolean CheckBlackList(List<String> list, String name) {
        if (list.isEmpty()) {
            return false;
        }
        return !list.contains(name);
    }

    public boolean CheckWhiteList(List<String> list, String name) {
        if (list.isEmpty()) {
            return true;
        }
        return list.contains(name);
    }

    public int getChunksize() {
        int size = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) <= 8 || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) > 11) continue;
            size = IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) - 8;
            return size;
        }
        return size;
    }

    public boolean getwirelessmodule() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemAdditionModule) || IUItem.module7.getMeta((ItemAdditionModule)this.get(i).m_41720_()) != 10) continue;
            return true;
        }
        return false;
    }

    public List<Integer> wirelessmodule() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemAdditionModule) || IUItem.module7.getMeta((ItemAdditionModule)this.get(i).m_41720_()) != 10) continue;
            CompoundTag nbttagcompound = ModUtils.nbt(this.get(i));
            int x = nbttagcompound.m_128451_("Xcoord");
            int y = nbttagcompound.m_128451_("Ycoord");
            int z = nbttagcompound.m_128451_("Zcoord");
            if (x == 0 || y == 0 || z == 0) break;
            list.add(x);
            list.add(y);
            list.add(z);
            break;
        }
        return list;
    }

    public double getenergycost(TileBaseQuantumQuarry target1) {
        double energy = target1.energyconsume;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) <= 0 || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) >= 6) continue;
            double proccent = IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_());
            proccent *= 0.05;
            proccent *= energy;
            proccent = energy - proccent;
            return proccent;
        }
        return energy;
    }

    public double getenergycost() {
        double energy = 1000.0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) <= 0 || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_()) >= 6) continue;
            double proccent = IUItem.module9.getMeta((ItemQuarryModule)this.get(i).m_41720_());
            proccent *= 0.05;
            proccent *= energy;
            proccent = energy - proccent;
            return proccent;
        }
        return energy;
    }
}

