/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.IUItem;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.Redstone;
import com.denfop.invslot.HandlerInventory;
import com.denfop.invslot.InvSlot;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.ItemStackUpgradeModules;
import com.denfop.tiles.base.FakePlayerSpawner;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class InvSlotUpgrade
extends InvSlot
implements ITypeSlot {
    private final TileEntityInventory tile;
    private final Map<Direction, HandlerInventory> iItemHandlerMap;
    private final Map<IItemHandler, Integer> slotHandler;
    private final Direction[] enumFacings = Direction.values();
    private final Map<Direction, IFluidHandler> iFluidHandlerMap;
    private final Fluids fluids;
    private final List<Fluids.InternalFluidTank> fluidTankList = new ArrayList<Fluids.InternalFluidTank>();
    private final IItemHandler main_handler;
    public boolean isUpdate = false;
    public int extraProcessTime;
    public double processTimeMultiplier;
    public double extraEnergyDemand;
    public double energyDemandMultiplier;
    public double extraEnergyStorage;
    public double operationsPerTick;
    public double operationLength;
    public double energyConsume;
    public double energyStorageMultiplier;
    public int extraTier;
    public int tick = 0;
    public boolean update = false;
    List<InvSlotOutput> slots = new ArrayList<InvSlotOutput>();
    List<InvSlot> inv_slots = new ArrayList<InvSlot>();
    private Direction[] facings;
    private List<List<ItemStack>> whiteList;
    private List<List<Fluid>> whiteList1;
    private boolean ejectorUpgrade;
    private boolean fluidEjectorUpgrade;
    private boolean pullingUpgrade;
    private boolean fluidPullingUpgrade;

    public InvSlotUpgrade(TileEntityInventory base, int count) {
        super(base, InvSlot.TypeItemSlot.INPUT, count);
        this.resetRates();
        this.facings = new Direction[count];
        this.whiteList = new ArrayList(Collections.nCopies(count, Collections.emptyList()));
        this.whiteList1 = new ArrayList(Collections.nCopies(count, Collections.emptyList()));
        base.getInvSlots().forEach(slot -> {
            if (slot instanceof InvSlotOutput) {
                this.slots.add((InvSlotOutput)slot);
            }
        });
        base.getInvSlots().forEach(slot -> {
            if (slot.canInput()) {
                this.inv_slots.add((InvSlot)slot);
            }
        });
        this.main_handler = (IItemHandler)base.getCapability(ForgeCapabilities.ITEM_HANDLER, base.getFacing()).orElse(null);
        this.fluids = base.getParent().getComp(Fluids.class);
        if (this.fluids != null) {
            this.fluids.getAllTanks().forEach(this.fluidTankList::add);
        }
        this.tile = base;
        this.slotHandler = new HashMap<IItemHandler, Integer>();
        this.iItemHandlerMap = new HashMap<Direction, HandlerInventory>();
        this.iFluidHandlerMap = new HashMap<Direction, IFluidHandler>();
    }

    private static int applyModifier(int base, int extra) {
        double ret = Math.round((double)base + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private static double applyModifier(double base, double extra, double multiplier) {
        return Math.round((base + extra) * multiplier);
    }

    public static Direction getDirection(ItemStack stack) {
        byte rawDir = ModUtils.nbt(stack).m_128445_("dir");
        return rawDir >= 1 && rawDir <= 6 ? Direction.values()[rawDir - 1] : null;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        return EnumTypeSlot.UPGRADE;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        Item rawItem = stack.m_41720_();
        if (!(rawItem instanceof IUpgradeItem)) {
            return false;
        }
        IUpgradeItem item = (IUpgradeItem)rawItem;
        return item.isSuitableFor(stack, ((IUpgradableBlock)((Object)this.base)).getUpgradableProperties());
    }

    @Override
    public boolean add(List<ItemStack> stacks) {
        return this.add(stacks, false);
    }

    @Override
    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    @Override
    public boolean canAdd(List<ItemStack> stacks) {
        boolean can = true;
        for (ItemStack stack : stacks) {
            can = can && this.canAdd(stack);
        }
        return can;
    }

    @Override
    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    @Override
    public void onChanged() {
        this.resetRates();
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemStack = this.get(i);
            if (ModUtils.isEmpty(itemStack)) continue;
            IUpgradeItem upgrade = (IUpgradeItem)itemStack.m_41720_();
            int size = ModUtils.getSize(itemStack);
            this.extraProcessTime = upgrade.getProcessTimeMultiplier(itemStack) < 1.0 ? (this.extraProcessTime += size) : 0;
            this.processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(itemStack), size);
            this.extraEnergyDemand = upgrade.getProcessTimeMultiplier(itemStack) < 1.0 ? (this.extraEnergyDemand += (double)size) : 0.0;
            this.energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(itemStack), size) * this.operationsPerTick;
            this.extraEnergyStorage += upgrade.getExtraEnergyStorage(itemStack) * (double)size;
            this.energyStorageMultiplier *= Math.pow(1.0, size);
            this.extraTier += upgrade.getExtraTier(itemStack) * size;
        }
        for (AbstractComponent abstractComponent : ((TileEntityInventory)this.base.getParent()).getComps()) {
            if (!(abstractComponent instanceof Redstone)) continue;
            Redstone rs = (Redstone)abstractComponent;
            rs.update();
        }
        if (this.tile.getWorld() instanceof ServerLevel) {
            for (int i = 0; i < this.size(); ++i) {
                ArrayList<Fluid> fluidStacks1;
                List<FluidStack> fluidStacks;
                List<Object> stacks;
                IItemStackInventory inventory;
                ItemStack itemStack = this.get(i);
                if (itemStack.m_150930_(IUItem.ejectorUpgrade.m_41720_())) {
                    this.ejectorUpgrade = true;
                    this.facings[i] = InvSlotUpgrade.getDirection(itemStack);
                    inventory = (IItemStackInventory)itemStack.m_41720_();
                    stacks = Arrays.asList(((ItemStackUpgradeModules)inventory.getInventory((Player)new FakePlayerSpawner(this.tile.getWorld()), itemStack)).getInventory());
                    stacks = stacks.stream().filter(stack1 -> !stack1.m_41619_()).collect(Collectors.toList());
                    this.whiteList.set(i, stacks);
                    continue;
                }
                if (itemStack.m_150930_(IUItem.fluidEjectorUpgrade.m_41720_())) {
                    this.fluidEjectorUpgrade = true;
                    this.facings[i] = InvSlotUpgrade.getDirection(itemStack);
                    inventory = (IItemStackInventory)itemStack.m_41720_();
                    fluidStacks = ((ItemStackUpgradeModules)inventory.getInventory((Player)new FakePlayerSpawner((Level)this.tile.getWorld()), (ItemStack)itemStack)).fluidStackList;
                    fluidStacks1 = new ArrayList<Fluid>();
                    for (FluidStack stacks2 : fluidStacks) {
                        if (stacks2 == null) continue;
                        fluidStacks1.add(stacks2.getFluid());
                    }
                    this.whiteList1.set(i, fluidStacks1);
                    continue;
                }
                if (itemStack.m_150930_(IUItem.pullingUpgrade.m_41720_())) {
                    this.pullingUpgrade = true;
                    this.facings[i] = InvSlotUpgrade.getDirection(itemStack);
                    inventory = (IItemStackInventory)itemStack.m_41720_();
                    stacks = Arrays.asList(((ItemStackUpgradeModules)inventory.getInventory((Player)new FakePlayerSpawner(this.tile.getWorld()), itemStack)).getInventory());
                    stacks = stacks.stream().filter(stack1 -> !stack1.m_41619_()).collect(Collectors.toList());
                    this.whiteList.set(i, stacks);
                    continue;
                }
                if (!itemStack.m_150930_(IUItem.fluidpullingUpgrade.m_41720_())) continue;
                this.fluidPullingUpgrade = true;
                this.facings[i] = InvSlotUpgrade.getDirection(itemStack);
                inventory = (IItemStackInventory)itemStack.m_41720_();
                fluidStacks = ((ItemStackUpgradeModules)inventory.getInventory((Player)new FakePlayerSpawner((Level)this.tile.getWorld()), (ItemStack)itemStack)).fluidStackList;
                fluidStacks1 = new ArrayList();
                for (FluidStack stacks2 : fluidStacks) {
                    if (stacks2 == null) continue;
                    fluidStacks1.add(stacks2.getFluid());
                }
                this.whiteList1.set(i, fluidStacks1);
            }
        }
    }

    private void resetRates() {
        this.extraProcessTime = 0;
        this.processTimeMultiplier = 1.0;
        this.extraEnergyDemand = 0.0;
        this.energyDemandMultiplier = 1.0;
        this.extraEnergyStorage = 0.0;
        this.energyStorageMultiplier = 1.0;
        this.extraTier = 0;
        this.ejectorUpgrade = false;
        this.fluidEjectorUpgrade = false;
        this.fluidPullingUpgrade = false;
        this.pullingUpgrade = false;
        this.facings = new Direction[this.size()];
    }

    public int getOperationsPerTick1(int defaultOperationLength) {
        if (this.isUpdate) {
            this.operationsPerTick = defaultOperationLength == 0 ? 64.0 : (double)this.getOpsPerTick(this.getStackOpLen(defaultOperationLength));
        }
        return (int)this.operationsPerTick;
    }

    public int getOperationLength1(int defaultOperationLength) {
        if (this.isUpdate) {
            if (defaultOperationLength == 0) {
                this.operationLength = 1.0;
            } else {
                double stackOpLen = this.getStackOpLen(defaultOperationLength);
                int opsPerTick = this.getOpsPerTick(stackOpLen);
                this.operationLength = Math.max(1, (int)Math.round(stackOpLen * (double)opsPerTick / 64.0));
            }
        }
        return (int)this.operationLength;
    }

    public int getOperationsPerTick(int defaultOperationLength) {
        this.operationsPerTick = defaultOperationLength == 0 ? 64.0 : (double)this.getOpsPerTick(this.getStackOpLen(defaultOperationLength));
        return (int)this.operationsPerTick;
    }

    public int getOperationLength(int defaultOperationLength) {
        if (defaultOperationLength == 0) {
            this.operationLength = 1.0;
        } else {
            double stackOpLen = this.getStackOpLen(defaultOperationLength);
            int opsPerTick = this.getOpsPerTick(stackOpLen);
            this.operationLength = Math.max(1, (int)Math.round(stackOpLen * (double)opsPerTick / 64.0));
        }
        return (int)this.operationLength;
    }

    private double getStackOpLen(int defaultOperationLength) {
        return ((double)defaultOperationLength + (double)this.extraProcessTime) * 64.0 * this.processTimeMultiplier;
    }

    private int getOpsPerTick(double stackOpLen) {
        return (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
    }

    public double getEnergyDemand(int defaultEnergyDemand) {
        return InvSlotUpgrade.applyModifier(defaultEnergyDemand, this.extraEnergyDemand, this.energyDemandMultiplier);
    }

    public double getEnergyDemand(double defaultEnergyDemand) {
        this.energyConsume = InvSlotUpgrade.applyModifier(defaultEnergyDemand, this.extraEnergyDemand, this.energyDemandMultiplier);
        return this.energyConsume;
    }

    public double getEnergyDemand1(double defaultEnergyDemand) {
        if (this.isUpdate) {
            this.energyConsume = InvSlotUpgrade.applyModifier(defaultEnergyDemand, this.extraEnergyDemand, this.energyDemandMultiplier);
        }
        return this.energyConsume;
    }

    public double getEnergyStorage(int defaultEnergyStorage) {
        return InvSlotUpgrade.applyModifier(defaultEnergyStorage, this.extraEnergyStorage, this.energyStorageMultiplier);
    }

    public double getEnergyStorage(double defaultEnergyStorage) {
        return InvSlotUpgrade.applyModifier(defaultEnergyStorage, this.extraEnergyStorage, this.energyStorageMultiplier);
    }

    public int getTier(int defaultTier) {
        return InvSlotUpgrade.applyModifier(defaultTier, this.extraTier);
    }

    public boolean tickNoMark() {
        boolean ret = false;
        ++this.tick;
        if (this.tick % 20 == 0) {
            IItemHandler handler;
            BlockEntity tile1;
            BlockPos pos;
            if (this.ejectorUpgrade || this.pullingUpgrade) {
                this.iItemHandlerMap.clear();
                this.slotHandler.clear();
                for (Direction facing : this.enumFacings) {
                    pos = this.tile.m_58899_().m_121955_(facing.m_122436_());
                    tile1 = this.tile.m_58904_().m_7702_(pos);
                    handler = this.getItemHandler(tile1, facing.m_122424_());
                    if (!(tile1 instanceof Container)) {
                        if (handler == null) {
                            this.iItemHandlerMap.put(facing, null);
                        } else {
                            this.iItemHandlerMap.put(facing, new HandlerInventory(handler, null));
                        }
                    } else {
                        this.iItemHandlerMap.put(facing, new HandlerInventory(handler, (Container)tile1));
                    }
                    if (handler == null) continue;
                    this.slotHandler.put(handler, handler.getSlots());
                }
            }
            if (this.fluidEjectorUpgrade || this.fluidPullingUpgrade) {
                this.iFluidHandlerMap.clear();
                for (Direction facing : this.enumFacings) {
                    pos = this.tile.m_58899_().m_121955_(facing.m_122436_());
                    tile1 = this.tile.m_58904_().m_7702_(pos);
                    handler = this.getFluidHandler(tile1, facing.m_122424_());
                    this.iFluidHandlerMap.put(facing, (IFluidHandler)handler);
                }
            }
            this.tick = 0;
        }
        boolean update = false;
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = this.get(i);
            if (ModUtils.isEmpty(stack) || !(stack.m_41720_() instanceof IUpgradeItem)) continue;
            update = true;
            if (this.tick % 2 == 0 && stack.m_150930_(IUItem.ejectorUpgrade.m_41720_())) {
                this.tick(i);
            } else if (this.tick % 2 == 0 && stack.m_150930_(IUItem.fluidEjectorUpgrade.m_41720_())) {
                this.tick_fluid(i);
            } else if (this.tick % 2 == 0 && stack.m_150930_(IUItem.pullingUpgrade.m_41720_())) {
                this.tickPullIn(i);
            } else if (this.tick % 2 == 0 && stack.m_150930_(IUItem.fluidpullingUpgrade.m_41720_())) {
                this.tickPullIn_fluid(i);
            }
            ret = true;
        }
        if (this.update != update) {
            this.update = update;
            return true;
        }
        return ret;
    }

    private void tickPullIn_fluid(int i) {
        Direction facing = this.facings[i];
        List<Fluid> itemStackList = this.whiteList1.get(i);
        if (facing != null) {
            IFluidHandler handler = this.iFluidHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            if (this.fluids == null) {
                return;
            }
            if (handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                return;
            }
            for (int ii = 0; ii < handler.getTanks(); ++ii) {
                @NotNull FluidStack fluidTankProperties = handler.getFluidInTank(ii);
                if (fluidTankProperties.copy().isEmpty()) continue;
                for (Fluids.InternalFluidTank tank : this.fluidTankList) {
                    FluidStack fluid;
                    if (tank.getFluidAmount() >= tank.getCapacity() || (fluid = handler.drain(fluidTankProperties.copy(), IFluidHandler.FluidAction.SIMULATE)).isEmpty() || fluid.getAmount() <= 0 || !tank.canDrain(facing.m_122424_()) || !tank.isFluidValid(fluid) || !itemStackList.isEmpty() && !itemStackList.contains(fluid.getFluid())) continue;
                    int amount = tank.getCapacity() - tank.getFluidAmount();
                    FluidStack fluidStack = handler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                    tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        } else {
            for (Direction facing1 : this.enumFacings) {
                IFluidHandler handler = this.iFluidHandlerMap.get(facing1);
                if (handler == null || handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
                if (this.fluids == null) {
                    return;
                }
                for (int ii = 0; ii < handler.getTanks(); ++ii) {
                    @NotNull FluidStack fluidTankProperties = handler.getFluidInTank(ii);
                    if (fluidTankProperties.copy().isEmpty()) continue;
                    for (Fluids.InternalFluidTank tank : this.fluidTankList) {
                        FluidStack fluid;
                        if (tank.getFluidAmount() >= tank.getCapacity() || (fluid = handler.drain(fluidTankProperties.copy(), IFluidHandler.FluidAction.SIMULATE)).isEmpty() || fluid.getAmount() <= 0 || !tank.acceptsFluid(fluid.getFluid()) || !itemStackList.isEmpty() && !itemStackList.contains(fluid.getFluid())) continue;
                        int amount = tank.getCapacity() - tank.getFluidAmount();
                        FluidStack fluidStack = handler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    }
                }
            }
        }
    }

    public IItemHandler getItemHandler(@Nullable BlockEntity tile, Direction side) {
        if (tile == null) {
            return null;
        }
        IItemHandler handler = (IItemHandler)tile.getCapability(ForgeCapabilities.ITEM_HANDLER, side).orElse(null);
        if (handler == null) {
            if (side != null && tile instanceof WorldlyContainer) {
                handler = new SidedInvWrapper((WorldlyContainer)tile, side);
            } else if (tile instanceof Container) {
                handler = new InvWrapper((Container)tile);
            }
        }
        return handler;
    }

    public IFluidHandler getFluidHandler(@Nullable BlockEntity tile, Direction side) {
        if (tile == null) {
            return null;
        }
        return (IFluidHandler)tile.getCapability(ForgeCapabilities.FLUID_HANDLER, side).orElse(null);
    }

    public boolean canItemStacksStack(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.m_41619_() || a.m_41720_() != b.m_41720_() || a.m_41782_() != b.m_41782_()) {
            return false;
        }
        return !a.m_41782_() || a.m_41783_().equals((Object)b.m_41783_());
    }

    private void tickPullIn(int i) {
        Direction facing = this.facings[i];
        List<ItemStack> itemStackList = this.whiteList.get(i);
        if (facing != null) {
            HandlerInventory handler = this.iItemHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            if (handler.getInventory() != null && handler.getInventory() instanceof TileEntityInventory) {
                List<InvSlot> inputs = ((TileEntityInventory)this.base.getParent()).getInputSlots();
                TileEntityInventory inventory = (TileEntityInventory)handler.getInventory();
                List<InvSlot> outputs = inventory.getOutputSlots();
                for (InvSlot slot : outputs) {
                    for (InvSlot invSlot : inputs) {
                        ItemStack input;
                        if (invSlot.acceptAllOrIndex()) {
                            for (int j = 0; j < slot.size(); ++j) {
                                ItemStack output = slot.get(j);
                                if (output.m_41619_()) continue;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    for (ItemStack stack : itemStackList) {
                                        if (stack.m_41720_() != output.m_41720_()) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue;
                                }
                                if (!invSlot.accepts(output, 0)) continue;
                                for (int jj = 0; jj < invSlot.size() && !output.m_41619_(); ++jj) {
                                    int maxCount;
                                    input = invSlot.get(jj);
                                    if (input.m_41619_()) {
                                        if (!invSlot.add(output)) continue;
                                        slot.set(j, ItemStack.f_41583_);
                                        output = ItemStack.f_41583_;
                                        continue;
                                    }
                                    if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                                    input.m_41769_(maxCount);
                                    output.m_41774_(maxCount);
                                }
                            }
                            continue;
                        }
                        block9: for (int jj = 0; jj < slot.size(); ++jj) {
                            ItemStack output;
                            for (int j = 0; j < invSlot.size() && !(output = slot.get(jj)).m_41619_(); ++j) {
                                int maxCount;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    input = itemStackList.iterator();
                                    while (input.hasNext()) {
                                        ItemStack stack = (ItemStack)input.next();
                                        if (stack.m_41720_() != output.m_41720_()) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue block9;
                                }
                                if ((input = invSlot.get(j)).m_41619_()) {
                                    if (!invSlot.accepts(output, j) || !invSlot.add(output)) continue;
                                    slot.set(jj, ItemStack.f_41583_);
                                    output = ItemStack.f_41583_;
                                    continue;
                                }
                                if (output.m_41720_() != input.m_41720_() || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                                input.m_41769_(maxCount);
                                output.m_41774_(maxCount);
                            }
                        }
                    }
                }
            } else {
                int slots = 0;
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception inventory) {
                    // empty catch block
                }
                for (int j = 0; j < slots; ++j) {
                    ItemStack took1;
                    ItemStack took = handler.getHandler().extractItem(j, 64, true);
                    if (took.m_41619_()) continue;
                    boolean find = false;
                    if (!itemStackList.isEmpty()) {
                        for (ItemStack stack : itemStackList) {
                            if (!stack.m_150930_(took.m_41720_())) continue;
                            find = true;
                            break;
                        }
                        if (!find) continue;
                    }
                    if ((took1 = ModUtils.insertItem(this.main_handler, took, true, this.main_handler.getSlots())).m_41619_()) {
                        took = handler.getHandler().extractItem(j, took.m_41613_(), false);
                        ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                        continue;
                    }
                    if (took1 == took) continue;
                    int count = took1.m_41613_() - took.m_41613_();
                    count = Math.abs(count);
                    took = handler.getHandler().extractItem(j, count, false);
                    ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                }
            }
        } else {
            for (Direction facing1 : this.enumFacings) {
                HandlerInventory handler = this.iItemHandlerMap.get(facing1);
                if (handler == null) continue;
                if (handler.getInventory() != null && handler.getInventory() instanceof TileEntityInventory) {
                    List<InvSlot> inputs = ((TileEntityInventory)this.base.getParent()).getInputSlots();
                    TileEntityInventory inventory = (TileEntityInventory)handler.getInventory();
                    List<InvSlot> outputs = inventory.getOutputSlots();
                    for (InvSlot slot : outputs) {
                        for (InvSlot invSlot : inputs) {
                            ItemStack input;
                            if (invSlot.acceptAllOrIndex()) {
                                for (int j = 0; j < slot.size(); ++j) {
                                    ItemStack output = slot.get(j);
                                    if (output.m_41619_()) continue;
                                    boolean find = false;
                                    if (!itemStackList.isEmpty()) {
                                        for (ItemStack stack : itemStackList) {
                                            if (!stack.m_150930_(output.m_41720_())) continue;
                                            find = true;
                                            break;
                                        }
                                        if (!find) continue;
                                    }
                                    if (!invSlot.accepts(output, 0)) continue;
                                    for (int jj = 0; jj < invSlot.size() && !output.m_41619_(); ++jj) {
                                        int maxCount;
                                        input = invSlot.get(jj);
                                        if (input.m_41619_()) {
                                            if (!invSlot.add(output)) continue;
                                            slot.set(j, ItemStack.f_41583_);
                                            output = ItemStack.f_41583_;
                                            continue;
                                        }
                                        if (!output.m_150930_(input.m_41720_()) || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                                        input.m_41769_(maxCount);
                                        output.m_41774_(maxCount);
                                    }
                                }
                                continue;
                            }
                            block20: for (int jj = 0; jj < slot.size(); ++jj) {
                                ItemStack output;
                                for (int j = 0; j < invSlot.size() && !(output = slot.get(jj)).m_41619_(); ++j) {
                                    int maxCount;
                                    boolean find = false;
                                    if (!itemStackList.isEmpty()) {
                                        input = itemStackList.iterator();
                                        while (input.hasNext()) {
                                            ItemStack stack = (ItemStack)input.next();
                                            if (!stack.m_150930_(output.m_41720_())) continue;
                                            find = true;
                                            break;
                                        }
                                        if (!find) continue block20;
                                    }
                                    if ((input = invSlot.get(j)).m_41619_()) {
                                        if (!invSlot.accepts(output, j) || !invSlot.add(output)) continue;
                                        slot.set(jj, ItemStack.f_41583_);
                                        output = ItemStack.f_41583_;
                                        continue;
                                    }
                                    if (!output.m_150930_(input.m_41720_()) || input.m_41613_() == input.m_41741_() || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                                    input.m_41769_(maxCount);
                                    output.m_41774_(maxCount);
                                }
                            }
                        }
                    }
                    continue;
                }
                int slots = 0;
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception inventory) {
                    // empty catch block
                }
                for (int j = 0; j < slots; ++j) {
                    ItemStack took = handler.getHandler().extractItem(j, 64, true);
                    if (took.m_41619_()) continue;
                    ItemStack took1 = ModUtils.insertItem(this.main_handler, took, true, this.main_handler.getSlots());
                    if (took1.m_41619_()) {
                        boolean find = false;
                        if (!itemStackList.isEmpty()) {
                            for (ItemStack stack : itemStackList) {
                                if (!stack.m_150930_(took.m_41720_())) continue;
                                find = true;
                                break;
                            }
                            if (!find) continue;
                        }
                        took = handler.getHandler().extractItem(j, took.m_41613_(), false);
                        ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                        continue;
                    }
                    if (took1 == took) continue;
                    int count = took1.m_41613_() - took.m_41613_();
                    count = Math.abs(count);
                    took = handler.getHandler().extractItem(j, count, false);
                    ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                }
            }
        }
    }

    private void tick(int i) {
        Direction facing = this.facings[i];
        List<ItemStack> itemStackList = this.whiteList.get(i);
        if (facing != null) {
            HandlerInventory handler = this.iItemHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            int slots = 0;
            if (handler.getInventory() != null && handler.getInventory() instanceof TileEntityInventory) {
                TileEntityInventory inventory = (TileEntityInventory)handler.getInventory();
                for (InvSlotOutput slot : this.slots) {
                    for (InvSlot invSlot : inventory.getInputSlots()) {
                        if (invSlot.acceptAllOrIndex()) {
                            for (int j = 0; j < slot.size(); ++j) {
                                ItemStack output = slot.get(j);
                                if (output.m_41619_()) continue;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    for (ItemStack stack : itemStackList) {
                                        if (!stack.m_150930_(output.m_41720_())) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue;
                                }
                                if (!invSlot.accepts(output, 0)) continue;
                                for (int jj = 0; jj < invSlot.size() && !output.m_41619_(); ++jj) {
                                    int maxCount;
                                    ItemStack input = invSlot.get(jj);
                                    if (input.m_41619_()) {
                                        if (!invSlot.add(output)) continue;
                                        slot.set(j, ItemStack.f_41583_);
                                        output = ItemStack.f_41583_;
                                        continue;
                                    }
                                    if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                                    input.m_41769_(maxCount);
                                    output.m_41774_(maxCount);
                                }
                            }
                            continue;
                        }
                        block9: for (int jj = 0; jj < slot.size(); ++jj) {
                            for (int j = 0; j < invSlot.size(); ++j) {
                                int maxCount;
                                ItemStack output = slot.get(jj);
                                ItemStack input = invSlot.get(j);
                                if (output.m_41619_()) continue block9;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    for (ItemStack stack : itemStackList) {
                                        if (!stack.m_150930_(output.m_41720_())) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue block9;
                                }
                                if (input.m_41619_()) {
                                    if (!invSlot.accepts(output, j) || !invSlot.add(output)) continue;
                                    slot.set(jj, ItemStack.f_41583_);
                                    output = ItemStack.f_41583_;
                                    continue;
                                }
                                if (!output.m_150930_(input.m_41720_()) || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                                input.m_41769_(maxCount);
                                output.m_41774_(maxCount);
                            }
                        }
                    }
                }
            } else {
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (handler.getInventory() != null) {
                    for (InvSlotOutput slot : this.slots) {
                        for (int j = 0; j < slot.size(); ++j) {
                            ItemStack stack;
                            ItemStack took = slot.get(j);
                            if (took.m_41619_()) continue;
                            boolean find = false;
                            if (!itemStackList.isEmpty()) {
                                for (ItemStack stack2 : itemStackList) {
                                    if (!stack2.m_150930_(took.m_41720_())) continue;
                                    find = true;
                                    break;
                                }
                                if (!find) continue;
                            }
                            if ((stack = this.insertItem1(handler, took, true, slots)).m_41619_()) {
                                slot.set(j, ItemStack.f_41583_);
                                this.insertItem1(handler, took, false, slots);
                                continue;
                            }
                            if (stack == took) continue;
                            int col = slot.get(j).m_41613_() - stack.m_41613_();
                            slot.get(j).m_41774_(col);
                            stack.m_41764_(col);
                            this.insertItem1(handler, stack, false, slots);
                        }
                    }
                } else {
                    for (InvSlotOutput slot : this.slots) {
                        for (int j = 0; j < slot.size(); ++j) {
                            ItemStack took = slot.get(j);
                            if (took.m_41619_()) continue;
                            boolean find = false;
                            if (!itemStackList.isEmpty()) {
                                for (ItemStack stack : itemStackList) {
                                    if (!stack.m_150930_(took.m_41720_())) continue;
                                    find = true;
                                    break;
                                }
                                if (!find) continue;
                            }
                            took = took.m_41777_();
                            ItemStack stack = ModUtils.insertItem(handler.getHandler(), took, true, slots);
                            if (stack.m_41619_()) {
                                slot.set(j, ItemStack.f_41583_);
                                ModUtils.insertItem(handler.getHandler(), took, false, slots);
                                continue;
                            }
                            if (stack == took) continue;
                            int col = slot.get(j).m_41613_() - stack.m_41613_();
                            slot.get(j).m_41774_(col);
                            stack.m_41764_(col);
                            ModUtils.insertItem(handler.getHandler(), stack, false, slots);
                        }
                    }
                }
            }
        } else {
            for (Direction facing1 : this.enumFacings) {
                ItemStack took;
                HandlerInventory handler = this.iItemHandlerMap.get(facing1);
                if (handler == null) continue;
                int slots = 0;
                if (handler.getInventory() != null && handler.getInventory() instanceof TileEntityInventory) {
                    TileEntityInventory inventory = (TileEntityInventory)handler.getInventory();
                    for (InvSlotOutput slot : this.slots) {
                        for (InvSlot invSlot : inventory.getInputSlots()) {
                            ItemStack input;
                            if (invSlot.acceptAllOrIndex()) {
                                for (int j = 0; j < slot.size(); ++j) {
                                    ItemStack output = slot.get(j);
                                    if (output.m_41619_()) continue;
                                    boolean find = false;
                                    if (!itemStackList.isEmpty()) {
                                        for (ItemStack stack : itemStackList) {
                                            if (!stack.m_150930_(output.m_41720_())) continue;
                                            find = true;
                                            break;
                                        }
                                        if (!find) continue;
                                    }
                                    if (!invSlot.accepts(output, 0)) continue;
                                    for (int jj = 0; jj < invSlot.size() && !output.m_41619_(); ++jj) {
                                        int maxCount;
                                        input = invSlot.get(jj);
                                        if (input.m_41619_()) {
                                            if (!invSlot.add(output)) continue;
                                            slot.set(j, ItemStack.f_41583_);
                                            output = ItemStack.f_41583_;
                                            continue;
                                        }
                                        if (!output.m_150930_(input.m_41720_()) || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                                        input.m_41769_(maxCount);
                                        output.m_41774_(maxCount);
                                    }
                                }
                                continue;
                            }
                            block24: for (int jj = 0; jj < slot.size(); ++jj) {
                                ItemStack output;
                                for (int j = 0; j < invSlot.size() && !(output = slot.get(jj)).m_41619_(); ++j) {
                                    int maxCount;
                                    boolean find = false;
                                    if (!itemStackList.isEmpty()) {
                                        input = itemStackList.iterator();
                                        while (input.hasNext()) {
                                            ItemStack stack = (ItemStack)input.next();
                                            if (!stack.m_150930_(output.m_41720_())) continue;
                                            find = true;
                                            break;
                                        }
                                        if (!find) continue block24;
                                    }
                                    if ((input = invSlot.get(j)).m_41619_()) {
                                        if (!invSlot.accepts(output, j) || !invSlot.add(output)) continue;
                                        slot.set(jj, ItemStack.f_41583_);
                                        output = ItemStack.f_41583_;
                                        continue;
                                    }
                                    if (!output.m_150930_(input.m_41720_()) || (maxCount = Math.min(input.m_41741_() - input.m_41613_(), output.m_41613_())) <= 0) continue;
                                    input.m_41769_(maxCount);
                                    output.m_41774_(maxCount);
                                }
                            }
                        }
                    }
                    continue;
                }
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (handler.getInventory() != null) {
                    for (InvSlotOutput slot : this.slots) {
                        for (int j = 0; j < slot.size(); ++j) {
                            ItemStack stack;
                            took = slot.get(j);
                            if (took.m_41619_()) continue;
                            boolean find = false;
                            if (!itemStackList.isEmpty()) {
                                for (ItemStack stack3 : itemStackList) {
                                    if (!stack3.m_150930_(took.m_41720_())) continue;
                                    find = true;
                                    break;
                                }
                                if (!find) continue;
                            }
                            if ((stack = this.insertItem1(handler, took, true, slots)).m_41619_()) {
                                slot.set(j, ItemStack.f_41583_);
                                this.insertItem1(handler, took, false, slots);
                                continue;
                            }
                            if (stack == took) continue;
                            int count = slot.get(j).m_41613_() - stack.m_41613_();
                            slot.get(j).m_41774_(count);
                            stack.m_41764_(count);
                            this.insertItem1(handler, stack, false, slots);
                        }
                    }
                    continue;
                }
                for (InvSlotOutput slot : this.slots) {
                    for (int j = 0; j < slot.size(); ++j) {
                        took = slot.get(j);
                        if (took.m_41619_()) continue;
                        boolean find = false;
                        if (!itemStackList.isEmpty()) {
                            for (ItemStack stack : itemStackList) {
                                if (!stack.m_150930_(took.m_41720_())) continue;
                                find = true;
                                break;
                            }
                            if (!find) continue;
                        }
                        took = took.m_41777_();
                        ItemStack stack = ModUtils.insertItem(handler.getHandler(), took, true, slots);
                        if (stack.m_41619_()) {
                            slot.set(j, ItemStack.f_41583_);
                            ModUtils.insertItem(handler.getHandler(), took, false, slots);
                            continue;
                        }
                        if (stack == took) continue;
                        slot.get(j).m_41774_(stack.m_41613_());
                        ModUtils.insertItem(handler.getHandler(), stack, false, slots);
                    }
                }
            }
        }
    }

    private void tick_fluid(int i) {
        Direction facing = this.facings[i];
        List<Fluid> itemStackList = this.whiteList1.get(i);
        if (facing != null) {
            IFluidHandler handler = this.iFluidHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            if (this.fluids == null) {
                return;
            }
            for (Fluids.InternalFluidTank tank : this.fluidTankList) {
                int amount;
                if (tank.getFluidAmount() <= 0 || !itemStackList.isEmpty() && !itemStackList.contains(tank.getFluid().getFluid()) || (amount = handler.fill(tank.getFluid(), IFluidHandler.FluidAction.SIMULATE)) <= 0 || !tank.canDrain(facing)) continue;
                tank.drain(handler.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            }
        } else {
            for (Direction facing1 : this.enumFacings) {
                IFluidHandler handler = this.iFluidHandlerMap.get(facing1);
                if (handler == null) continue;
                if (this.fluids == null) {
                    return;
                }
                for (Fluids.InternalFluidTank tank : this.fluidTankList) {
                    int amount;
                    if (tank.getFluidAmount() <= 0 || !itemStackList.isEmpty() && !itemStackList.contains(tank.getFluid().getFluid()) || (amount = handler.fill(tank.getFluid(), IFluidHandler.FluidAction.SIMULATE)) <= 0 || !tank.canDrain(facing1)) continue;
                    tank.drain(handler.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }

    @Nonnull
    public ItemStack insertItem1(HandlerInventory dest, @Nonnull ItemStack stack, boolean simulate, int slot) {
        if (dest == null || stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < slot; ++i) {
            ItemStack stack2 = this.insertItem2(dest, i, stack, simulate);
            if (stack2.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (stack2 == stack) continue;
            return stack2;
        }
        return stack;
    }

    @Nonnull
    public ItemStack insertItem2(HandlerInventory dest1, int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack stackInSlot;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        IItemHandler dest = dest1.getHandler();
        Container inventory = dest1.getInventory();
        int maxSlots = dest.getSlots();
        try {
            stackInSlot = inventory.m_8020_(slot);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            stackInSlot = dest.getStackInSlot(slot);
        }
        if (!stackInSlot.m_41619_()) {
            int max = stackInSlot.m_41741_();
            int limit = dest.getSlotLimit(slot);
            if (stackInSlot.m_41613_() >= Math.min(max, limit)) {
                return stack;
            }
            if (simulate && !inventory.m_7013_(slot, stack)) {
                return stack;
            }
            if (!this.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            int m = Math.min(max, limit) - stackInSlot.m_41613_();
            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    inventory.m_6836_(slot, copy);
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack copy = stack.m_41620_(m);
                copy.m_41769_(stackInSlot.m_41613_());
                inventory.m_6836_(slot, copy);
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!inventory.m_7013_(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.m_41741_(), dest.getSlotLimit(slot));
        if (m < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                inventory.m_6836_(slot, stack.m_41620_(m));
            }
            return stack;
        }
        if (!simulate) {
            try {
                inventory.m_6836_(slot, stack);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                dest.insertItem(slot, stack, false);
            }
        }
        return ItemStack.f_41583_;
    }

    public double getEnergyStorage(int defaultEnergyStorage, int defaultOperationLength, int defaultEnergyDemand) {
        int opLen = this.getOperationLength(defaultOperationLength);
        double energyDemand = this.getEnergyDemand(defaultEnergyDemand);
        return InvSlotUpgrade.applyModifier(defaultEnergyStorage, this.extraEnergyStorage + (double)opLen * energyDemand, this.energyStorageMultiplier);
    }
}

