/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.reactors;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.IUPotion;
import com.denfop.Localization;
import com.denfop.api.item.IHazmatLike;
import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.items.reactors.IRadioactiveItemType;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.utils.ModUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemBaseRod
extends ItemDamage
implements IRadioactiveItemType,
IReactorItem,
IItemTab {
    public final int numberOfCells;
    private final int heat;
    private final float power;
    private final int level;
    private final double radiation;
    double[] p = new double[]{5.0, 20.0, 60.0, 200.0};

    public ItemBaseRod(int cells, int heat, float power, int level) {
        super(new Item.Properties().m_41487_(1).setNoRepair(), 1);
        this.heat = heat;
        this.power = power;
        this.numberOfCells = cells;
        this.level = level;
        this.radiation = power * (float)level * (float)cells;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ReactorsTab;
    }

    @Override
    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public boolean m_142522_(@Nonnull ItemStack stack) {
        return false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotIndex, boolean isCurrentItem) {
        LivingEntity entityLiving;
        if (entity instanceof LivingEntity && !IHazmatLike.hasCompleteHazmat(entityLiving = (LivingEntity)entity)) {
            IUPotion.radiation.applyEffect(entityLiving, this.getRadiationDuration());
        }
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        double temp = Math.log10(this.numberOfCells);
        double temp1 = Math.log10(2.0);
        double m = temp / temp1;
        p_41423_.add((Component)Component.m_237113_((String)(Localization.translate("reactor.info") + ModUtils.getString(this.p[(int)m] * (double)this.power * (double)this.level * 1.25) + " EF")));
        p_41423_.add((Component)Component.m_237113_((String)(Localization.translate("reactor.rod.radiation") + (int)this.radiation)));
        p_41423_.add((Component)Component.m_237113_((String)(Localization.translate("reactor.rod.heat") + this.heat)));
        p_41423_.add((Component)Component.m_237113_((String)(Localization.translate("reactor.rod_level") + this.level)));
        p_41423_.add((Component)Component.m_237113_((String)Localization.translate("reactor.rod_level1")));
    }

    @Override
    public int getRadiationDuration() {
        return 200;
    }

    @Override
    public int getRadiationAmplifier() {
        return 100;
    }

    @Override
    public EnumTypeComponent getType() {
        return EnumTypeComponent.ROD;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public double getRadiation() {
        return this.radiation;
    }

    @Override
    public int getAutoRepair(IAdvReactor reactor) {
        return 0;
    }

    @Override
    public int getRepairOther(IAdvReactor reactor) {
        return 0;
    }

    @Override
    public int getDamageCFromHeat(int heat, IAdvReactor reactor) {
        return 1;
    }

    @Override
    public int getHeat(IAdvReactor reactor) {
        return this.heat;
    }

    @Override
    public double getHeatRemovePercent(IAdvReactor reactor) {
        return 0.0;
    }

    @Override
    public void damageItem(ItemStack stack, int damage) {
    }

    @Override
    public boolean updatableItem() {
        return true;
    }

    @Override
    public boolean caneExtractHeat() {
        return true;
    }

    @Override
    public double getEnergyProduction(IAdvReactor reactor) {
        double temp = Math.log10(this.numberOfCells);
        double temp1 = Math.log10(2.0);
        double m = temp / temp1;
        return this.p[(int)m] * (double)this.power * (double)this.level * 1.25;
    }

    @Override
    public boolean needClear(ItemStack stack) {
        return this.getMaxCustomDamage(stack) - this.getCustomDamage(stack) == 0;
    }
}

