/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.research.api.IResearchTable;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.tiles.base.TileEntityBlock;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketReturnRoversToPlanet
implements IPacket {
    public PacketReturnRoversToPlanet() {
    }

    public PacketReturnRoversToPlanet(IResearchTable base, Player player, IBody iBody) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(customPacketBuffer, ((TileEntityBlock)((Object)base)).getWorld());
            EncoderHandler.encode(customPacketBuffer, ((TileEntityBlock)((Object)base)).getPos());
            EncoderHandler.encode(customPacketBuffer, player.m_20148_());
            customPacketBuffer.writeBoolean(iBody != null);
            if (iBody != null) {
                customPacketBuffer.writeString(iBody.getName());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IUCore.network.getClient().sendPacket(customPacketBuffer);
    }

    @Override
    public byte getId() {
        return 43;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            boolean hasBody;
            Level world = (Level)DecoderHandler.decode(customPacketBuffer);
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            UUID uuid = (UUID)DecoderHandler.decode(customPacketBuffer);
            if (entityPlayer.m_20148_().equals(uuid) && (hasBody = customPacketBuffer.readBoolean())) {
                IResearchTable tileEntityResearchTableSpace;
                String body = customPacketBuffer.readString();
                IBody body1 = SpaceNet.instance.getBodyFromName(body);
                BlockEntity tile = world.m_7702_(pos);
                if (tile instanceof IResearchTable && (tileEntityResearchTableSpace = (IResearchTable)tile).getPlayer().equals(uuid)) {
                    SpaceNet.instance.getResearchSystem().returnOperation(body1, tileEntityResearchTableSpace);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.CLIENT;
    }
}

