/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.oilquarry;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.vein.Type;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.IUFluid;
import com.denfop.tiles.base.TileQuarryVein;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

public class QuarryOilRenderer
implements BlockEntityRenderer<TileQuarryVein> {
    private final BlockEntityRendererProvider.Context contex;
    private float rotation = 0.0f;
    private float prevRotation = 0.0f;

    public QuarryOilRenderer(BlockEntityRendererProvider.Context context) {
        this.contex = context;
    }

    public void render(TileQuarryVein tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (tile.vein == null || !tile.vein.get()) {
            return;
        }
        if (tile.vein.getType() != Type.EMPTY) {
            String typeString;
            String varietyString;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 1.35, 0.5);
            poseStack.m_85841_(0.25f, 0.25f, 0.25f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(this.rotation));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(this.rotation));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(this.rotation));
            BlockState state = null;
            if (state == null) {
                state = tile.vein.getType() == Type.VEIN ? (tile.vein.isOldMineral() ? IUItem.heavyore.getStateFromMeta(tile.vein.getMeta()) : IUItem.mineral.getStateFromMeta(tile.vein.getMeta())) : (tile.vein.getType() == Type.OIL ? IUItem.oilblock.getBlock(0).m_49966_() : IUItem.gasBlock.getBlock(0).m_49966_());
            }
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            BakedModel model = dispatcher.m_110910_(state);
            dispatcher.m_110937_().m_111067_(poseStack.m_85850_(), bufferSource.m_6299_(RenderType.m_110463_()), state, model, 1.0f, 1.0f, 1.0f, packedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
            this.rotation += 0.25f;
            Component stack = null;
            if (tile.vein.getType() == Type.VEIN) {
                stack = tile.vein.isOldMineral() ? new ItemStack((ItemLike)IUItem.heavyore.getItem(tile.vein.getMeta()), 1).m_41611_() : new ItemStack((ItemLike)IUItem.mineral.getItem(tile.vein.getMeta()), 1).m_41611_();
            } else if (tile.vein.getType() == Type.OIL) {
                stack = new ItemStack((ItemLike)IUItem.oilblock.getItem()).m_41611_();
            } else if (tile.vein.getType() == Type.GAS) {
                stack = ((IUFluid)((Object)FluidName.fluidgas.getInstance().get())).getFluidType().getDescription();
            }
            int col = tile.vein.getCol();
            boolean isOil = tile.vein.getType() == Type.OIL || tile.vein.getType() == Type.GAS;
            int colmax = tile.vein.getMaxCol();
            int variety = tile.vein.getMeta() / 3;
            int type = tile.vein.getMeta() % 3;
            String string = varietyString = variety == 0 ? "iu.sweet_oil" : "iu.sour_oil";
            String string2 = type == 0 ? "iu.light_oil" : (typeString = type == 1 ? "iu.medium_oil" : "iu.heavy_oil");
            Object itextcomponent = isOil ? (tile.vein.getType() != Type.GAS ? Component.m_237113_((String)(Localization.translate(varietyString) + " " + Localization.translate(typeString))).m_7220_(stack) : stack) : stack;
            MutableComponent itextcomponent1 = Component.m_237113_((String)(col + (isOil ? "mb" : "") + "/" + colmax + (isOil ? "mb" : "")));
            poseStack.m_85837_(0.5, (double)2.15f, 0.5);
            this.drawNameplate((Component)itextcomponent, poseStack, bufferSource, packedLight);
            poseStack.m_252880_(0.0f, -0.25f, 0.0f);
            this.drawNameplate((Component)itextcomponent1, poseStack, bufferSource, packedLight);
        }
    }

    private void drawNameplate(Component text, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(this.contex.m_234446_().m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        Font font = this.contex.m_173586_();
        float f2 = -font.m_92852_((FormattedText)text) / 2;
        font.m_272077_(text, f2, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, Font.DisplayMode.NORMAL, j, packedLight);
        font.m_272077_(text, f2, 0.0f, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.m_85849_();
    }
}

