/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.water;

import com.denfop.api.windsystem.IWindRotor;
import com.denfop.render.windgenerator.RotorModel;
import com.denfop.tiles.mechanism.water.TileBaseWaterGenerator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class WaterGeneratorRenderer
implements BlockEntityRenderer<TileBaseWaterGenerator> {
    private static final Map<Integer, RotorModel> rotorModels = new HashMap<Integer, RotorModel>();

    public WaterGeneratorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileBaseWaterGenerator tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        TileBaseWaterGenerator windGen = tile;
        Level world = tile.m_58904_();
        BlockPos pos = tile.m_58899_();
        if (tile.getRotor() == null) {
            return;
        }
        int diameter = 3;
        if (diameter == 0) {
            return;
        }
        float angle = windGen.getAngle();
        ResourceLocation rotorTexture = windGen.getRotorRenderTexture();
        RotorModel model = rotorModels.computeIfAbsent(diameter, RotorModel::new);
        Direction facing = windGen.getFacing();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5, 0.0);
        switch (facing) {
            case NORTH: {
                poseStack.m_85837_(0.5, 0.0, 0.0);
                break;
            }
            case EAST: {
                poseStack.m_85837_(1.0, 0.0, 0.5);
                break;
            }
            case SOUTH: {
                poseStack.m_85837_(0.5, 0.0, 1.0);
                break;
            }
            case WEST: {
                poseStack.m_85837_(0.0, 0.0, 0.5);
            }
        }
        switch (facing) {
            case NORTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-180.0f));
                break;
            }
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-270.0f));
                break;
            }
            case UP: {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
            }
        }
        if (windGen.getSpace()) {
            angle = windGen.getAngle();
            IWindRotor rotor = tile.getRotor();
            if (rotor.getMaxCustomDamage(tile.slot.get(0)) - rotor.getCustomDamage(tile.slot.get(0)) == 0) {
                angle = 0.0f;
            }
            if (!Minecraft.m_91087_().m_91104_()) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(angle));
            }
        }
        poseStack.m_252880_(-0.2f, 0.0f, 0.0f);
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)rotorTexture));
        model.m_7695_(poseStack, buffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(TileBaseWaterGenerator tile) {
        return true;
    }
}

