/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.FluidName;
import com.denfop.componets.Fluids;
import com.denfop.componets.HeatComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerHeatMachine;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiHeatMachine;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileBaseHeatMachine
extends TileElectricMachine
implements IUpdatableTileEvent {
    public final boolean hasFluid;
    public final HeatComponent heat;
    public short maxtemperature;
    public boolean auto;
    public FluidTank fluidTank;
    public Fluids fluids = null;
    public InvSlotFluid fluidSlot;
    public int coef = 1;
    public boolean work = true;

    public TileBaseHeatMachine(boolean hasFluid, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(hasFluid ? 0.0 : 10000.0, 14, 1, block, pos, state);
        this.hasFluid = hasFluid;
        if (this.hasFluid) {
            this.fluids = this.addComponent(new Fluids(this));
            this.fluidTank = this.fluids.addTank("fluidTank", 12000, InvSlot.TypeItemSlot.INPUT, Fluids.fluidPredicate(new Fluid[]{(Fluid)FluidName.fluidpahoehoe_lava.getInstance().get(), net.minecraft.world.level.material.Fluids.f_76195_, (Fluid)FluidName.fluiddizel.getInstance().get(), (Fluid)FluidName.fluidbenz.getInstance().get(), (Fluid)FluidName.fluidbiogas.getInstance().get(), (Fluid)FluidName.fluidbiomass.getInstance().get()}));
            this.fluidSlot = new InvSlotFluidByList((TileEntityInventory)this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.INPUT, new Fluid[]{(Fluid)FluidName.fluidpahoehoe_lava.getInstance().get(), net.minecraft.world.level.material.Fluids.f_76195_, (Fluid)FluidName.fluiddizel.getInstance().get(), (Fluid)FluidName.fluidbenz.getInstance().get(), (Fluid)FluidName.fluidbiogas.getInstance().get(), (Fluid)FluidName.fluidbiomass.getInstance().get()});
        }
        this.maxtemperature = (short)1000;
        this.heat = this.addComponent(HeatComponent.asBasicSource(this, 1000.0));
        this.auto = false;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.auto = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.maxtemperature = (Short)DecoderHandler.decode(customPacketBuffer);
            this.work = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.auto);
            EncoderHandler.encode(packet, this.maxtemperature);
            EncoderHandler.encode(packet, this.work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.coef = (int)Math.max(Math.ceil(this.heat.storage / 2000.0), 1.0);
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (i == 0.0) {
            this.maxtemperature = (short)(this.maxtemperature + 1000);
            if (this.maxtemperature > 10000) {
                this.maxtemperature = (short)10000;
            }
            this.heat.setCapacity(this.maxtemperature);
        }
        if (i == 1.0) {
            this.maxtemperature = (short)(this.maxtemperature - 1000);
            if (this.maxtemperature < 1000) {
                this.maxtemperature = (short)1000;
            }
            this.heat.setCapacity(this.maxtemperature);
        }
        if (i == 2.0) {
            this.work = !this.work;
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (this.hasFluid) {
            this.fluidTank.readFromNBT(nbttagcompound.m_128469_("fluidTank"));
        }
        this.maxtemperature = nbttagcompound.m_128448_("maxtemperature");
        this.auto = nbttagcompound.m_128471_("auto");
        this.work = nbttagcompound.m_128471_("work");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.hasFluid) {
            CompoundTag fluidTankTag = new CompoundTag();
            this.fluidTank.writeToNBT(fluidTankTag);
            nbttagcompound.m_128365_("fluidTank", (Tag)fluidTankTag);
        }
        nbttagcompound.m_128376_("maxtemperature", this.maxtemperature);
        nbttagcompound.m_128379_("auto", this.auto);
        nbttagcompound.m_128379_("work", this.work);
        return nbttagcompound;
    }

    public boolean process() {
        if (!this.hasFluid ? this.energy != null && this.energy.getEnergy() < 50.0 : this.fluidTank.getFluid().isEmpty() || this.fluidTank.getFluidAmount() == 0) {
            return false;
        }
        short temp = (short)this.heat.getEnergy();
        if (temp >= this.maxtemperature) {
            return false;
        }
        if (this.heat.allow || this.work) {
            if (this.hasFluid) {
                if (this.getFluidTank().getFluidAmount() >= 1) {
                    this.heat.addEnergy(5.0);
                    this.getFluidTank().drain(this.coef, IFluidHandler.FluidAction.EXECUTE);
                    return true;
                }
            } else if (this.energy.getEnergy() >= (double)(30 * this.coef)) {
                this.heat.addEnergy(5.0);
                this.energy.useEnergy(30 * this.coef);
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        boolean active;
        super.updateEntityServer();
        if (this.hasFluid) {
            MutableObject output = new MutableObject();
            if (this.fluidTank.getFluidAmount() + 1000 <= this.fluidTank.getCapacity() && this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
                this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
                if (output.getValue() != null) {
                    this.outputSlot.add((ItemStack)output.getValue());
                }
            }
        }
        if ((active = this.process()) != this.getActive()) {
            this.setActive(active);
        }
        if (this.f_58857_.m_46467_() % 60L == 0L && this.heat.getEnergy() > 0.0) {
            this.heat.useEnergy(1.0);
        }
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public ContainerHeatMachine getGuiContainer(Player entityPlayer) {
        return new ContainerHeatMachine(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiHeatMachine((ContainerHeatMachine)menu);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

