/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockConverterMatter;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerConverterSolidMatter;
import com.denfop.gui.GuiConverterSolidMatter;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlotConverterSolidMatter;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.register.RegisterOreDictionary;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Precision;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileConverterSolidMatter
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IHasRecipe {
    public final InvSlotConverterSolidMatter MatterSlot;
    public final InvSlotRecipes inputSlot;
    public final InvSlotUpgrade upgradeSlot;
    public final int defaultOperationLength;
    public final int defaultEnergyConsume;
    public double[] quantitysolid = new double[8];
    public int energyConsume = 2;
    public double defaultEnergyStorage = 50000.0;
    public double progress = 0.0;
    public double guiProgress = 0.0;
    public int operationLength = 100;
    public int operationsPerTick;
    public MachineRecipe output;
    public boolean required = false;
    public double[] outputmatter = new double[9];

    public TileConverterSolidMatter(BlockPos pos, BlockState state) {
        super(50000.0, 14, 1, BlockConverterMatter.converter_matter, pos, state);
        this.MatterSlot = new InvSlotConverterSolidMatter(this);
        this.upgradeSlot = new InvSlotUpgrade(this, 3);
        this.inputSlot = new InvSlotRecipes((TileEntityInventory)this, "converter", (IUpdateTick)this);
        this.defaultOperationLength = 100;
        this.defaultEnergyConsume = 2;
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addrecipe(ItemStack stack, double matter, double sunmatter, double aquamatter, double nethermatter, double nightmatter, double earthmatter, double endmatter, double aermatter) {
        CompoundTag nbt = new CompoundTag();
        double[] quantitysolid = new double[]{Precision.round(matter, 2), Precision.round(sunmatter, 2), Precision.round(aquamatter, 2), Precision.round(nethermatter, 2), Precision.round(nightmatter, 2), Precision.round(earthmatter, 2), Precision.round(endmatter, 2), Precision.round(aermatter, 2)};
        for (int i = 0; i < quantitysolid.length; ++i) {
            ModUtils.SetDoubleWithoutItem(nbt, "quantitysolid_" + i, quantitysolid[i]);
        }
        IInputHandler input = Recipes.inputFactory;
        if (stack.m_41619_()) {
            return;
        }
        Recipes.recipes.addRecipe("converter", new BaseMachineRecipe(new Input(input.getInput(stack)), new RecipeOutput(nbt, stack)));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.quantitysolid = (double[])DecoderHandler.decode(customPacketBuffer);
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.quantitysolid);
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockConverterMatter.converter_matter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.convertersolidmatter.getBlock();
    }

    @Override
    public void init() {
        int i;
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50069_), 0.2, 0.0, 0.0, 0.0, 0.0, 0.15, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50652_), 0.1, 0.0, 0.0, 0.0, 0.0, 0.05, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50134_), 0.1, 0.0, 0.0, 0.05, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50034_), 0.5, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 1.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_49994_), 0.5, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_49995_), 1.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_49997_), 1.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50074_), 180.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50075_), 24.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42417_), 20.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42416_), 2.67, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42415_), 50.0, 0.0, 10.0, 0.0, 0.0, 40.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42616_), 70.0, 0.0, 10.0, 0.0, 0.0, 40.0, 0.0, 200.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50090_), 500.0, 0.0, 100.0, 0.0, 0.0, 400.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50268_), 700.0, 0.0, 100.0, 0.0, 0.0, 400.0, 0.0, 200.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42413_), 1.5, 0.0, 0.0, 0.0, 0.0, 0.55, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42534_), 5.0, 0.0, 0.0, 0.0, 1.0, 7.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42451_, 1), 0.5, 0.5, 0.0, 0.0, 0.0, 1.7, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50353_), 15.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42401_), 150.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 200.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42454_), 150.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 50.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42518_), 100.0, 0.0, 200.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42585_), 100.0, 0.0, 0.0, 1000.0, 500.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42500_), 20.0, 0.0, 0.0, 0.0, 100.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42498_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42497_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42496_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42495_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42494_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42493_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42492_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42491_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42490_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42489_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42540_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42539_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42538_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42537_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42536_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42535_), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42484_), 1.0, 0.0, 0.0, 0.0, 0.0, 0.25, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50135_), 0.0, 0.0, 0.0, 150.0, 50.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50197_), 0.0, 0.0, 0.0, 250.0, 100.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42461_), 0.0, 0.0, 40.0, 0.0, 0.0, 0.0, 0.0, 20.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42460_), 0.0, 0.0, 40.0, 0.0, 0.0, 0.0, 0.0, 20.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42048_), 0.0, 0.0, 40.0, 40.0, 0.0, 0.0, 0.0, 20.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42403_), 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50060_), 50.0, 0.0, 0.0, 0.0, 10.0, 60.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50330_), 5.0, 5.0, 0.0, 0.0, 0.0, 15.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50333_), 30.0, 0.0, 0.0, 300.0, 20.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42692_), 7.5, 0.0, 0.0, 75.0, 5.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42398_), 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50705_), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50741_), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50742_), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50743_), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50744_), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50745_), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50133_), 1000.0, 1000.0, 1000.0, 0.0, 0.0, 0.0, 0.0, 2000.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50186_), 1000.0, 1000.0, 1000.0, 0.0, 0.0, 0.0, 0.0, 2000.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42405_), 1000.0, 2000.0, 500.0, 0.0, 0.0, 0.0, 0.0, 2000.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_41909_), 300.0, 200.0, 500.0, 0.0, 0.0, 0.0, 0.0, 500.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42402_), 300.0, 200.0, 500.0, 0.0, 0.0, 0.0, 0.0, 500.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50041_), 600.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 800.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42588_), 1000.0, 0.0, 0.0, 2500.0, 2000.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50141_), 30.0, 20.0, 0.0, 300.0, 20.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50058_), 2.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50259_), 0.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.25, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42525_), 7.5, 5.0, 0.0, 75.0, 5.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.copperBlock, 8.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.tinBlock, 10.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.bronzeBlock, 10.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.advironblock, 20.0, 0.0, 0.0, 0.0, 0.0, 8.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.uraniumBlock, 15.0, 0.0, 0.0, 0.0, 0.0, 8.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.leadBlock, 80.0, 0.0, 0.0, 0.0, 0.0, 40.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.copperIngot, 0.8888888888888888, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.tinIngot, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.bronzeIngot, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.advIronIngot, 2.2222222222222223, 0.0, 0.0, 0.0, 0.0, 0.8888888888888888, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.itemiu.getStack(2), 1), 1.6666666666666667, 0.0, 0.0, 0.0, 0.0, 0.8888888888888888, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.leadIngot, 8.88888888888889, 0.0, 0.0, 0.0, 0.0, 4.444444444444445, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.platecopper, 0.8888888888888888, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.platetin, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.platebronze, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.plateadviron, 2.2222222222222223, 0.0, 0.0, 0.0, 0.0, 0.8888888888888888, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.platelead, 8.88888888888889, 0.0, 0.0, 0.0, 0.0, 4.444444444444445, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.casingcopper, 0.4444444444444444, 0.0, 0.0, 0.0, 0.0, 0.2222222222222222, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.casingtin, 0.5555555555555556, 0.0, 0.0, 0.0, 0.0, 0.2222222222222222, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.casingbronze, 0.5555555555555556, 0.0, 0.0, 0.0, 0.0, 0.2222222222222222, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.casingadviron, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.casinglead, 4.444444444444445, 0.0, 0.0, 0.0, 0.0, 2.2222222222222223, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.copperCableItem, 0.4444444444444444, 0.0, 0.0, 0.0, 0.0, 0.2222222222222222, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.tinCableItem, 0.37037037037037035, 0.0, 0.0, 0.0, 0.0, 0.14814814814814814, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.goldCableItem, 5.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.ironCableItem, 0.6675, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.plategold, 20.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.plateiron, 2.67, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.rubber, 150.0, 0.0, 40.0, 0.0, 0.0, 0.0, 0.0, 50.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.f_42584_), 0.0, 0.0, 0.0, 0.0, 250.0, 0.0, 2000.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.f_50080_), 0.0, 0.0, 0.0, 0.0, 30.0, 10.0, 10.0, 0.0);
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.iuingot.getStack(i), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        }
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.iuingot.getStack(25), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.iuingot.getStack(26), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.iuingot.getStack(27), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        for (i = 0; i < RegisterOreDictionary.list_baseore1.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.iuingot.getStack(i + 28), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        }
        for (i = 0; i < RegisterOreDictionary.list_baseore1.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.stik.getStack(i + 22), 1), 6.0, 0.0, 0.0, 0.0, 0.0, 18.0, 0.0, 0.0);
        }
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.stik.getStack(i), 1), 6.0, 0.0, 0.0, 0.0, 0.0, 18.0, 0.0, 0.0);
        }
        for (i = 0; i < RegisterOreDictionary.list_baseore1.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.plate.getStack(i + 31), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        }
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.plate.getStack(i), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        }
        for (i = 0; i < RegisterOreDictionary.list_baseore1.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.doubleplate.getStack(i + 31), 1), 108.0, 0.0, 0.0, 0.0, 0.0, 288.0, 0.0, 0.0);
        }
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.doubleplate.getStack(i), 1), 108.0, 0.0, 0.0, 0.0, 0.0, 288.0, 0.0, 0.0);
        }
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.casing.getStack(i), 1), 6.0, 0.0, 0.0, 0.0, 0.0, 18.0, 0.0, 0.0);
        }
        for (i = 0; i < RegisterOreDictionary.list_baseore1.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.casing.getStack(i + 29), 1), 6.0, 0.0, 0.0, 0.0, 0.0, 18.0, 0.0, 0.0);
        }
        IUItem.machineRecipe = Recipes.recipes.getRecipeStack("converter");
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.operationLength = this.upgradeSlot.getOperationLength(this.defaultOperationLength);
        this.energyConsume = (int)this.upgradeSlot.getEnergyDemand(2);
    }

    public double getProgress() {
        return this.guiProgress;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        MachineRecipe output = this.output;
        if (output != null && this.outputSlot.canAdd(this.output.getRecipe().output.items) && !this.inputSlot.isEmpty() && this.required) {
            double p;
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.f_58857_.m_46467_() % 20L == 0L) {
                this.MatterSlot.getmatter();
            }
            if (this.useEnergy(this.energyConsume, false) && this.required) {
                this.progress += 1.0;
                this.useEnergy(this.energyConsume, true);
            }
            if ((p = this.progress / (double)this.operationLength) <= 1.0) {
                this.guiProgress = p;
            }
            if (p > 1.0) {
                this.guiProgress = 1.0;
            }
            if (this.progress >= (double)this.operationLength && this.required) {
                this.operate(output);
                this.progress = 0.0;
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
        this.setOverclockRates();
    }

    private void useMatter() {
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            int n = i;
            this.quantitysolid[n] = this.quantitysolid[n] - this.outputmatter[i];
        }
    }

    public void getrequiredmatter(RecipeOutput output) {
        if (output == null) {
            this.required = false;
            return;
        }
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            if (this.quantitysolid[i] >= this.outputmatter[i]) continue;
            this.required = false;
            return;
        }
        this.required = true;
    }

    public void operate(MachineRecipe output) {
        List<ItemStack> processResult = output.getRecipe().output.items;
        this.operateOnce(processResult);
    }

    public void operateOnce(List<ItemStack> processResult) {
        this.useMatter();
        this.outputSlot.add(processResult);
        this.getrequiredmatter(this.output.getRecipe().getOutput());
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlots.remove(this.inputSlot);
        this.inputSlot.load();
        this.getOutput();
        if (this.output != null) {
            for (int i = 0; i < this.quantitysolid.length; ++i) {
                this.outputmatter[i] = this.output.getRecipe().output.metadata.m_128459_("quantitysolid_" + i);
            }
            this.getrequiredmatter(this.output.getRecipe().getOutput());
        } else {
            this.getrequiredmatter(null);
        }
        this.MatterSlot.getmatter();
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlot.process();
        return this.output;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128459_("progress");
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            this.quantitysolid[i] = nbttagcompound.m_128459_("quantitysolid" + i);
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128347_("progress", this.progress);
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            nbttagcompound.m_128347_("quantitysolid" + i, this.quantitysolid[i]);
        }
        return nbttagcompound;
    }

    public boolean useEnergy(double amount, boolean consume) {
        if (this.energy.canUseEnergy(amount)) {
            if (consume) {
                this.energy.useEnergy(amount);
            }
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<?>> getGui(Player entityPlayer, ContainerBase<?> isAdmin) {
        return new GuiConverterSolidMatter((ContainerConverterSolidMatter)isAdmin);
    }

    public ContainerConverterSolidMatter getGuiContainer(Player entityPlayer) {
        return new ContainerConverterSolidMatter(entityPlayer, this);
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    @Override
    public void onUpdate() {
        if (this.output != null) {
            for (int i = 0; i < this.quantitysolid.length; ++i) {
                this.outputmatter[i] = this.output.getRecipe().output.metadata.m_128459_("quantitysolid_" + i);
            }
        }
        if (this.output == null) {
            this.getrequiredmatter(null);
        } else {
            this.getrequiredmatter(this.output.getRecipe().getOutput());
        }
        this.MatterSlot.getmatter();
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

