/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockAnvil;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.effects.EffectsRegister;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.register.RegisterOreDictionary;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityAnvil
extends TileEntityInventory
implements IUpdateTick,
IHasRecipe,
IAudioFixer {
    public static final List<String> list_string = TileEntityAnvil.itemNames();
    private static final List<AABB> aabbs = Collections.singletonList(new AABB(0.0, 0.0, -1.0, 1.0, 1.0, 2.0));
    private static final List<AABB> aabbs1 = Collections.singletonList(new AABB(-1.0, 0.0, 0.0, 2.0, 1.0, 1.0));
    public final InvSlotRecipes inputSlotA = new InvSlotRecipes(this, "anvil", this){

        @Override
        public boolean accepts(ItemStack itemStack, int index) {
            if (index == 4) {
                return super.accepts(itemStack, 0);
            }
            return false;
        }
    };
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public int progress = 0;
    public MachineRecipe output;
    public int durability = 300;
    public Map<UUID, Double> data;

    public TileEntityAnvil(BlockPos pos, BlockState state) {
        super(BlockAnvil.block_anvil, pos, state);
        Recipes.recipes.addInitRecipes(this);
    }

    public static List<String> itemNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Mikhail");
        list.add("Aluminium");
        list.add("Vanady");
        list.add("Tungsten");
        list.add("Invar");
        list.add("Caravky");
        list.add("Cobalt");
        list.add("Magnesium");
        list.add("Nickel");
        list.add("Platinum");
        list.add("Titanium");
        list.add("Chromium");
        list.add("Spinel");
        list.add("Electrum");
        list.add("Silver");
        list.add("Zinc");
        list.add("Manganese");
        list.add("Iridium");
        list.add("Germanium");
        return list;
    }

    public static List<String> itemNames7() {
        return Arrays.asList("Arsenic", "Barium", "Bismuth", "Gadolinium", "Gallium", "Hafnium", "Yttrium", "Molybdenum", "Neodymium", "Niobium", "Palladium", "Polonium", "Strontium", "Thallium", "Zirconium");
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction facing) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        if (this.facing != 4 && this.facing != 5) {
            return aabbs1;
        }
        return aabbs;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.primal_repair"));
        tooltip.add(Localization.translate("iu.primal_repair.info"));
        tooltip.add(Localization.translate("primitive_rcm.info"));
        tooltip.add(Localization.translate("primitive_use.info") + IUItem.ForgeHammer.getItem().m_41466_().getString());
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.anvil.getBlock();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockAnvil.block_anvil;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        List<ItemStack> drop = super.getSelfDrops(fortune, wrench);
        ItemStack stack = drop.get(0);
        CompoundTag nbt = ModUtils.nbt(stack);
        nbt.m_128405_("durability", this.durability);
        return drop;
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        CompoundTag nbt = ModUtils.nbt(stack);
        if (nbt.m_128441_("durability")) {
            this.durability = nbt.m_128451_("durability");
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.ANVIL);
        if (!this.getWorld().f_46443_) {
            this.inputSlotA.load();
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
            new PacketUpdateFieldTile(this, "durability", this.durability);
            if (this.durability > 200) {
                this.setActive("");
            } else if (this.durability > 100) {
                this.setActive("1");
            } else if (this.durability > 0) {
                this.setActive("2");
            } else {
                this.setActive("3");
            }
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("durability")) {
            try {
                this.durability = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.set(0, ItemStack.f_41583_);
        }
        if (name.equals("slot2")) {
            this.outputSlot.set(0, ItemStack.f_41583_);
        }
        if (name.equals("effect")) {
            this.spawnItemParticles(this.f_58857_, this.pos, this.inputSlotA.get(0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnItemParticles(Level world, BlockPos pos, ItemStack stack) {
        Random rand = new Random();
        for (int i = 0; i < 1; ++i) {
            double offsetX = -0.05;
            double offsetY = 0.05;
            double offsetZ = -0.05;
            world.m_7106_((ParticleOptions)EffectsRegister.ANVIL.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5, offsetX, offsetY, offsetZ);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
            this.outputSlot.readFromNbt(((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
            this.durability = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.durability);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onSneakingActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.m_21120_(hand);
        if (this.durability >= 0 && this.durability < 300 && stack.m_41720_() == IUItem.iuingot.getItemFromMeta(10)) {
            this.durability += 50;
            if (this.durability > 300) {
                this.durability = 300;
            }
            stack.m_41774_(1);
            if (this.durability > 200) {
                this.setActive("");
            } else if (this.durability > 100) {
                this.setActive("1");
            } else if (this.durability > 0) {
                this.setActive("2");
            } else {
                this.setActive("3");
            }
            new PacketUpdateFieldTile(this, "durability", this.durability);
        }
        return super.onSneakingActivated(player, hand, side, vec3);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.getWorld().f_46443_) {
            if (this.durability > 0 && (stack.m_41720_() == IUItem.ForgeHammer.getItem() || stack.m_41720_() == IUItem.ObsidianForgeHammer.getItem()) && this.output != null && this.outputSlot.canAdd(this.output.getRecipe().output.items.get(0))) {
                this.progress += 10;
                new PacketUpdateFieldTile(this, "effect", true);
                this.getCooldownTracker().setTick(10);
                if (stack.m_41720_() == IUItem.ObsidianForgeHammer.getItem()) {
                    this.progress += 10;
                }
                this.progress += (int)(this.data.getOrDefault(player.m_20148_(), 0.0) / 5.0);
                if (!this.getWorld().f_46443_) {
                    this.initiate(0);
                }
                if (this.progress >= 100) {
                    this.progress = 0;
                    if (!this.getWorld().f_46443_) {
                        PrimitiveHandler.addExperience(EnumPrimitive.ANVIL, 0.5, player.m_20148_());
                    }
                    --this.durability;
                    if (this.durability > 200) {
                        this.setActive("");
                    } else if (this.durability > 100) {
                        this.setActive("1");
                    } else if (this.durability > 0) {
                        this.setActive("2");
                    } else {
                        this.setActive("3");
                    }
                    player.m_21008_(hand, stack.m_41720_().getCraftingRemainingItem(stack));
                    this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                    this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                    if (this.inputSlotA.isEmpty() || this.outputSlot.get(0).m_41613_() >= 64) {
                        this.output = null;
                    }
                    if (!this.f_58857_.f_46443_) {
                        if (!this.inputSlotA.get(0).m_41619_()) {
                            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                        } else {
                            new PacketUpdateFieldTile(this, "slot3", this.inputSlotA);
                        }
                        new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                        new PacketUpdateFieldTile(this, "durability", this.durability);
                    }
                    if ((double)WorldBaseGen.random.nextInt(100) < this.data.getOrDefault(player.m_20148_(), 0.0) & this.output != null && this.outputSlot.canAdd(this.output.getRecipe().output.items.get(0))) {
                        this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                        this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                        if (this.inputSlotA.isEmpty() || this.outputSlot.get(0).m_41613_() >= 64) {
                            this.output = null;
                        }
                        if (!this.f_58857_.f_46443_) {
                            if (!this.inputSlotA.get(0).m_41619_()) {
                                new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                            } else {
                                new PacketUpdateFieldTile(this, "slot3", this.inputSlotA);
                            }
                            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                            new PacketUpdateFieldTile(this, "durability", this.durability);
                        }
                    }
                }
                return this.getWorld().f_46443_;
            }
            if (!stack.m_41619_()) {
                if (this.inputSlotA.get(0).m_41619_() && this.inputSlotA.accepts(stack, 4)) {
                    this.inputSlotA.set(0, stack.m_41777_());
                    stack.m_41764_(0);
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    return true;
                }
                if (!this.inputSlotA.get(0).m_41619_() && this.inputSlotA.get(0).m_150930_(stack.m_41720_())) {
                    int minCount = 64 - this.inputSlotA.get(0).m_41613_();
                    minCount = Math.min(stack.m_41613_(), minCount);
                    this.inputSlotA.get(0).m_41769_(minCount);
                    stack.m_41769_(-minCount);
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    return true;
                }
            } else {
                if (!this.outputSlot.isEmpty()) {
                    if (!this.f_58857_.f_46443_) {
                        ModUtils.dropAsEntity(this.f_58857_, this.pos, this.outputSlot.get(0));
                    }
                    this.outputSlot.set(0, ItemStack.f_41583_);
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot2", false);
                    }
                    return true;
                }
                if (!this.inputSlotA.isEmpty()) {
                    if (!this.f_58857_.f_46443_) {
                        ModUtils.dropAsEntity(this.f_58857_, this.pos, this.inputSlotA.get(0));
                    }
                    this.inputSlotA.set(0, ItemStack.f_41583_);
                    this.output = null;
                    if (!this.f_58857_.f_46443_) {
                        new PacketUpdateFieldTile(this, "slot3", false);
                    }
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.durability = nbttagcompound.m_128451_("durability");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128405_("durability", this.durability);
        return nbttagcompound;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        for (String s : list_string) {
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/" + s.toLowerCase(), 1)), new RecipeOutput(null, input.getInput("forge:plates/" + s.toLowerCase()).getInputs())));
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:plates/" + s.toLowerCase(), 1)), new RecipeOutput(null, input.getInput("forge:casings/" + s.toLowerCase(), 2).getInputs())));
        }
        for (String s : RegisterOreDictionary.list_baseore1) {
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/" + s, 1)), new RecipeOutput(null, input.getInput("forge:plates/" + s).getInputs().get(0))));
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:plates/" + s, 1)), new RecipeOutput(null, input.getInput("forge:casings/" + s, 2).getInputs().get(0))));
        }
        for (String s : RegisterOreDictionary.list_string1) {
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/" + s, 1)), new RecipeOutput(null, input.getInput("forge:plates/" + s).getInputs().get(0))));
            Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:plates/" + s, 1)), new RecipeOutput(null, input.getInput("forge:casings/" + s, 2).getInputs().get(0))));
        }
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/Iron", 1)), new RecipeOutput(null, input.getInput("forge:plates/Iron").getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(504), 1), 1)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.crafting_elements.getStack(501), 1))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:plates/Iron", 1)), new RecipeOutput(null, input.getInput("forge:casings/Iron", 2).getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/Gold", 1)), new RecipeOutput(null, input.getInput("forge:plates/Gold").getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/Lead", 1)), new RecipeOutput(null, input.getInput("forge:plates/Lead").getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/Tin", 1)), new RecipeOutput(null, input.getInput("forge:plates/Tin").getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:plates/Tin", 1)), new RecipeOutput(null, input.getInput("forge:casings/Tin", 2).getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:plates/Bronze", 1)), new RecipeOutput(null, input.getInput("forge:casings/Bronze", 2).getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/Osmium", 1)), new RecipeOutput(null, input.getInput("forge:plates/Osmium").getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/Tantalum", 1)), new RecipeOutput(null, input.getInput("forge:plates/Tantalum").getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/Cadmium", 1)), new RecipeOutput(null, input.getInput("forge:plates/Cadmium").getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/Steel", 1)), new RecipeOutput(null, input.getInput("forge:plates/Steel").getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/Bronze", 1)), new RecipeOutput(null, input.getInput("forge:plates/Bronze").getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:ingots/Copper", 1)), new RecipeOutput(null, input.getInput("forge:plates/Copper").getInputs().get(0))));
        Recipes.recipes.addRecipe("anvil", new BaseMachineRecipe(new Input(input.getInput("forge:plates/Copper", 1)), new RecipeOutput(null, input.getInput("forge:casings/Copper", 2).getInputs().get(0))));
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return EnumTypeAudio.ON;
    }

    @Override
    public void setType(EnumTypeAudio type) {
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.molot.getSoundEvent();
    }

    @Override
    public void initiate(int soundEvent) {
        if (soundEvent == 0) {
            this.getWorld().m_5594_(null, this.pos, this.getSound(), SoundSource.BLOCKS, 0.2f, 1.0f);
        }
    }

    @Override
    public boolean getEnable() {
        return true;
    }
}

