/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerBlockLimiter;
import com.denfop.gui.GuiBlockLimiter;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlotLimiter;
import com.denfop.items.ItemCraftingElements;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileLimiter
extends TileEntityInventory
implements IUpdatableTileEvent,
IAudioFixer {
    private final Energy energy;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio;
    public boolean sound = true;
    public InvSlotLimiter slot;
    public double max_value;

    public TileLimiter(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.limiter, pos, state);
        this.energy = this.addComponent(new Energy((TileEntityInventory)this, Double.MAX_VALUE, Arrays.asList(Direction.values()).stream().filter(facing -> facing != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()), 14, 0, false));
        this.energy.setLimit(true);
        this.slot = new InvSlotLimiter(this);
        this.valuesAudio = EnumTypeAudio.values();
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.max_value = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.max_value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.limiter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.pen.getSoundEvent();
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.getWorld().m_5594_(null, this.pos, this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.getWorld(), this.pos);
            this.getWorld().m_5594_(null, this.pos, EnumSound.InterruptOne.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.getWorld(), this.pos);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.slot.isEmpty()) {
            this.setTier(0);
        } else {
            this.setTier(((ISubEnum)((ItemCraftingElements)this.slot.get(0).m_41720_()).getElement()).getId() - 205);
        }
        this.energy.setDirections(Arrays.asList(Direction.values()).stream().filter(facing -> facing != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()));
        this.energy.setCapacity(this.energy.limit_amount);
    }

    public void setTier(int tier) {
        this.energy.setSourceTier(tier);
        if (tier != 0) {
            this.energy.setCapacity(EnergyNetGlobal.instance.getPowerFromTier(tier));
        } else {
            this.energy.setCapacity(0.0);
            this.energy.limit_amount = 0.0;
        }
        this.max_value = tier != 0 ? EnergyNetGlobal.instance.getPowerFromTier(tier) : 0.0;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128347_("max_value", this.max_value);
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.max_value = nbtTagCompound.m_128459_("max_value");
    }

    public Energy getEnergy() {
        return this.energy;
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        this.energy.limit_amount += i;
        this.energy.limit_amount = (int)Math.min(this.max_value, this.energy.limit_amount);
        this.energy.limit_amount = (int)Math.max(0.0, this.energy.limit_amount);
        this.energy.setDirections(Arrays.asList(Direction.values()).stream().filter(facing -> facing != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()));
        this.energy.setCapacity(this.energy.limit_amount);
        this.initiate(2);
        this.initiate(0);
    }

    public ContainerBlockLimiter getGuiContainer(Player entityPlayer) {
        return new ContainerBlockLimiter(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiBlockLimiter((ContainerBlockLimiter)menu);
    }
}

