/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.container.ContainerApothecaryBee;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiApothecaryBee;
import com.denfop.gui.GuiCore;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.bee.TileEntityApiary;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityApothecaryBee
extends TileEntityInventory {
    private static final int RADIUS = 4;
    public final ComponentBaseEnergy energy;
    AABB searchArea;
    List<List<TileEntityApiary>> list;
    List<ChunkPos> chunks;
    private ComponentVisibleArea visible;

    public TileEntityApothecaryBee(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.apothecary_bee, pos, state);
        this.searchArea = new AABB(this.pos.m_7918_(-4, -4, -4), this.pos.m_7918_(5, 5, 5));
        this.list = new ArrayList<List<TileEntityApiary>>();
        this.energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.QUANTUM, this, 20000.0));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.apothecary_bee;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.apothecary_bee.info"));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.visible.aabb = this.searchArea;
        if (!this.getWorld().f_46443_) {
            AABB aabb = this.searchArea;
            int j2 = Mth.m_14107_((double)((aabb.f_82288_ - 2.0) / 16.0));
            int k2 = Mth.m_14165_((double)((aabb.f_82291_ + 2.0) / 16.0));
            int l2 = Mth.m_14107_((double)((aabb.f_82290_ - 2.0) / 16.0));
            int i3 = Mth.m_14165_((double)((aabb.f_82293_ + 2.0) / 16.0));
            this.chunks = new ArrayList<ChunkPos>();
            for (int j3 = j2; j3 < k2; ++j3) {
                for (int k3 = l2; k3 < i3; ++k3) {
                    LevelChunk chunk = this.f_58857_.m_6325_(j3, k3);
                    if (this.chunks.contains(chunk.m_7697_())) continue;
                    this.chunks.add(chunk.m_7697_());
                }
            }
            for (ChunkPos chunk : this.chunks) {
                this.list.add(BeeNetwork.instance.getApiaryFromChunk(this.f_58857_, chunk));
            }
        }
    }

    public ContainerApothecaryBee getGuiContainer(Player var1) {
        return new ContainerApothecaryBee(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiApothecaryBee((ContainerApothecaryBee)menu);
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.m_123341_() > this.searchArea.f_82288_ && (double)vec.m_123341_() < this.searchArea.f_82291_) {
            if ((double)vec.m_123342_() > this.searchArea.f_82289_ && (double)vec.m_123342_() < this.searchArea.f_82292_) {
                return (double)vec.m_123343_() > this.searchArea.f_82290_ && (double)vec.m_123343_() < this.searchArea.f_82293_;
            }
            return false;
        }
        return false;
    }

    private void updateBee() {
        this.list.clear();
        for (ChunkPos chunk : this.chunks) {
            this.list.add(BeeNetwork.instance.getApiaryFromChunk(this.f_58857_, chunk));
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 100L == 0L) {
            this.updateBee();
        }
        if (this.getWorld().m_46467_() % 20L == 0L && this.energy.canUseEnergy(50.0)) {
            block0: for (List<TileEntityApiary> bees : this.list) {
                for (TileEntityApiary bee : bees) {
                    if (!(this.energy.getEnergy() > 50.0) || bee.ill <= 0) break block0;
                    if (!this.contains(bee.getPos())) continue;
                    bee.healBeesFromApothecary(this);
                }
            }
        }
    }
}

