/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerPlantCollector;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiPlantCollector;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.crop.TileEntityCrop;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityPlantCollector
extends TileEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 8;
    public final Energy energy;
    public final InvSlotOutput output;
    public final InvSlotUpgrade upgradeSlot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private final ComponentUpgradeSlots componentUpgrade;
    AABB searchArea;
    List<List<TileEntityCrop>> list;
    List<ChunkPos> chunks;
    private ComponentVisibleArea visible;

    public TileEntityPlantCollector(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.plant_collector, pos, state);
        this.searchArea = new AABB(this.pos.m_7918_(-8, -8, -8), this.pos.m_7918_(9, 9, 9));
        this.list = new ArrayList<List<TileEntityCrop>>();
        this.output = new InvSlotOutput(this, 18);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 1024.0, 4));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.2));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.plant_collector;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.plant_collector.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.visible.aabb = this.searchArea;
        if (!this.getWorld().f_46443_) {
            AABB aabb = this.searchArea;
            int j2 = Mth.m_14107_((double)((aabb.f_82288_ - 2.0) / 16.0));
            int k2 = Mth.m_14165_((double)((aabb.f_82291_ + 2.0) / 16.0));
            int l2 = Mth.m_14107_((double)((aabb.f_82290_ - 2.0) / 16.0));
            int i3 = Mth.m_14165_((double)((aabb.f_82293_ + 2.0) / 16.0));
            this.chunks = new ArrayList<ChunkPos>();
            for (int j3 = j2; j3 < k2; ++j3) {
                for (int k3 = l2; k3 < i3; ++k3) {
                    LevelChunk chunk = this.f_58857_.m_6325_(j3, k3);
                    if (this.chunks.contains(chunk.m_7697_())) continue;
                    this.chunks.add(chunk.m_7697_());
                }
            }
            for (ChunkPos chunk : this.chunks) {
                this.list.add(CropNetwork.instance.getCropsFromChunk(this.f_58857_, chunk));
            }
        }
    }

    public ContainerPlantCollector getGuiContainer(Player var1) {
        return new ContainerPlantCollector(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiPlantCollector((ContainerPlantCollector)menu);
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.m_123341_() > this.searchArea.f_82288_ && (double)vec.m_123341_() < this.searchArea.f_82291_) {
            if ((double)vec.m_123342_() > this.searchArea.f_82289_ && (double)vec.m_123342_() < this.searchArea.f_82292_) {
                return (double)vec.m_123343_() > this.searchArea.f_82290_ && (double)vec.m_123343_() < this.searchArea.f_82293_;
            }
            return false;
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 100L == 0L) {
            this.updateCrop();
        }
        if (this.getWorld().m_46467_() % 20L == 0L && this.energy.canUseEnergy(50.0)) {
            block0: for (List<TileEntityCrop> crops : this.list) {
                for (TileEntityCrop crop : crops) {
                    if (!(this.energy.getEnergy() > 50.0)) break block0;
                    if (!this.contains(crop.getPos()) || crop.getCrop() == null || crop.getCrop().getTick() != crop.getCrop().getMaxTick() || crop.getCrop().getId() == 3) continue;
                    List<ItemStack> listItems = crop.harvest(false);
                    this.energy.useEnergy(50.0);
                    this.output.add(listItems);
                    if (WorldBaseGen.random.nextInt(100) > 4) continue;
                    this.output.add(ModUtils.setSize(crop.getCropItem(), crop.getCrop().getSizeSeed()));
                }
            }
        }
    }

    private void updateCrop() {
        this.list.clear();
        for (ChunkPos chunk : this.chunks) {
            this.list.add(CropNetwork.instance.getCropsFromChunk(this.f_58857_, chunk));
        }
    }
}

