/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.pollution.ChunkLevel;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileEntityInventory;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TileEntityPurifierSoil
extends TileEntityInventory
implements IManufacturerBlock {
    public final Energy energy = this.addComponent(Energy.asBasicSink(this, 10000.0));
    public ChunkLevel chunkLevel = null;
    public ChunkPos chunkPos;
    public int levelBlock;

    public TileEntityPurifierSoil(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.purifier_soil, pos, state);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.soil_purifier.info"));
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (this.levelBlock < 10) {
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41720_().equals(IUItem.upgrade_speed_creation)) {
                return super.onActivated(player, hand, side, vec3);
            }
            stack.m_41774_(1);
            ++this.levelBlock;
            return true;
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.levelBlock != 0) {
            ret.add(new ItemStack((ItemLike)IUItem.upgrade_speed_creation.getItem(), this.levelBlock));
            this.levelBlock = 0;
        }
        return ret;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.levelBlock = nbttagcompound.m_128451_("level");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128405_("level", this.levelBlock);
        return nbttagcompound;
    }

    @Override
    public int getLevelMechanism() {
        return this.levelBlock;
    }

    @Override
    public void setLevelMech(int levelBlock) {
        this.levelBlock = levelBlock;
    }

    @Override
    public void removeLevel(int level) {
        this.levelBlock -= level;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.chunkPos = new ChunkPos(this.pos);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.chunkLevel != null);
        if (this.chunkLevel != null) {
            customPacketBuffer.writeBytes((ByteBuf)this.chunkLevel.writePacket());
        }
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        boolean exist = customPacketBuffer.readBoolean();
        if (exist) {
            this.chunkLevel = new ChunkLevel(customPacketBuffer);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.f_58857_.m_46467_() % 20L == 0L && this.energy.getEnergy() > 100.0) {
            this.chunkLevel = PollutionManager.pollutionManager.getChunkLevelSoil(this.chunkPos);
            if (this.chunkLevel != null) {
                ChunkLevel chunkLevel1 = PollutionManager.pollutionManager.getChunkLevelAir(this.chunkPos);
                if (this.chunkLevel.removePollution(10 + this.levelBlock * 50)) {
                    chunkLevel1.addPollution(25 + this.levelBlock * 25);
                    this.energy.useEnergy(100.0);
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        }
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.purifier_soil;
    }
}

