/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.generator.things.fluid;

import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerHeliumGenerator;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiHeliumGenerator;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ParticleUtils;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileHeliumGenerator
extends TileElectricMachine
implements IUpgradableBlock {
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public final InvSlotFluid containerslot = new InvSlotFluidByList((TileEntityInventory)this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, (Fluid)FluidName.fluidHelium.getInstance().get());
    public final FluidTank fluidTank;
    protected final Fluids fluids = this.addComponent(new Fluids(this));
    private final float energycost;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private double lastEnergy;

    public TileHeliumGenerator(BlockPos pos, BlockState state) {
        super(50000.0, 1, 1, BlockBaseMachine2.helium_generator, pos, state);
        this.energycost = 1000.0f;
        this.fluidTank = this.fluids.addTank("fluidTank", 20000, InvSlot.TypeItemSlot.OUTPUT, Fluids.fluidPredicate((Fluid)FluidName.fluidHelium.getInstance().get()));
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.15));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(14.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.helium_generator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1.getBlock(this.getTeBlock().getId());
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.hydrogen_generator.getSoundEvent();
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.lastEnergy = nbt.m_128459_("lastEnergy");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128347_("lastEnergy", this.lastEnergy);
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.setUpgradestat();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (!(this.energy.getEnergy() <= 0.0)) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.energy.getEnergy() >= (double)this.energycost) {
                needsInvUpdate = this.attemptGeneration();
            }
            this.lastEnergy = this.energy.getEnergy();
            if (this.upgradeSlot.tickNoMark() && needsInvUpdate) {
                this.setUpgradestat();
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
        if (this.getActive() && this.f_58857_.m_46467_() % 5L == 0L) {
            ParticleUtils.spawnHeliumGeneratorParticles(this.f_58857_, this.pos, this.f_58857_.f_46441_);
        }
        if (!this.containerslot.isEmpty() && this.fluidTank.getFluidAmount() > 0) {
            this.containerslot.processFromTank((IFluidTank)this.fluidTank, this.outputSlot);
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public boolean attemptGeneration() {
        int k = (int)(this.energy.getEnergy() / (double)this.energycost);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return false;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluidHelium.getInstance().get(), Math.min(m, k)), IFluidHandler.FluidAction.EXECUTE);
        this.energy.useEnergy(this.energycost * (float)Math.min(m, k));
        return true;
    }

    public String getProgressAsString() {
        int p = Math.min((int)(this.energy.getEnergy() * 100.0 / (double)this.energycost), 100);
        return p + "%";
    }

    public ContainerHeliumGenerator getGuiContainer(Player entityPlayer) {
        return new ContainerHeliumGenerator(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiHeliumGenerator((ContainerHeliumGenerator)isAdmin);
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(TileHeliumGenerator.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.FluidExtract);
    }
}

