/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.quarry_earth;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DataPos {
    public final BlockPos pos;
    public final BlockState state;

    public DataPos(BlockPos pos, BlockState state) {
        this.pos = pos;
        this.state = state;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getState() {
        return this.state;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", this.pos.m_123341_());
        tag.m_128405_("y", this.pos.m_123342_());
        tag.m_128405_("z", this.pos.m_123343_());
        tag.m_128359_("block", BuiltInRegistries.f_256975_.m_7981_((Object)this.state.m_60734_()).toString());
        CompoundTag props = new CompoundTag();
        for (Property property : this.state.m_61147_()) {
            String name = property.m_61708_();
            props.m_128359_(name, DataPos.getName(this.state, property));
        }
        tag.m_128365_("properties", (Tag)props);
        return tag;
    }

    public static DataPos load(CompoundTag tag) {
        BlockPos pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
        Block block = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(tag.m_128461_("block"))).orElse(Blocks.f_50016_);
        BlockState state = block.m_49966_();
        CompoundTag props = tag.m_128469_("properties");
        for (String key : props.m_128431_()) {
            Property property = state.m_60734_().m_49965_().m_61081_(key);
            if (property == null) continue;
            state = DataPos.setValue(state, property, props.m_128461_(key));
        }
        return new DataPos(pos, state);
    }

    private static <T extends Comparable<T>> String getName(BlockState state, Property<T> property) {
        Comparable value = state.m_61143_(property);
        return property.m_6940_(value);
    }

    private static <T extends Comparable<T>> BlockState setValue(BlockState state, Property<T> property, String name) {
        return property.m_6215_(name).map(v -> (BlockState)state.m_61124_(property, v)).orElse(state);
    }
}

