/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.heat.pump;

import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.ISubEnum;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerHeatPump;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiHeatPump;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemCraftingElements;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.reactors.heat.IPump;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityBasePump
extends TileEntityMultiBlockElement
implements IPump {
    private final int levelBlock;
    private final InvSlot slot;
    private int power;
    private int energy;

    public TileEntityBasePump(int levelBlock, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.levelBlock = levelBlock;
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public int getStackSizeLimit() {
                return 1;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.m_41720_() instanceof ItemCraftingElements)) {
                    return false;
                }
                int itemDamage = ((ISubEnum)((ItemCraftingElements)stack.m_41720_()).getElement()).getId();
                switch (itemDamage) {
                    case 276: {
                        return ((TileEntityBasePump)this.base).getBlockLevel() >= 0;
                    }
                    case 20: {
                        return ((TileEntityBasePump)this.base).getBlockLevel() >= 1;
                    }
                    case 96: {
                        return ((TileEntityBasePump)this.base).getBlockLevel() >= 2;
                    }
                    case 120: {
                        return ((TileEntityBasePump)this.base).getBlockLevel() >= 3;
                    }
                }
                return false;
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (content.m_41619_()) {
                    ((TileEntityBasePump)this.base).setEnergy(0);
                    ((TileEntityBasePump)this.base).setPower(0);
                } else {
                    int itemDamage = ((ISubEnum)((ItemCraftingElements)content.m_41720_()).getElement()).getId();
                    switch (itemDamage) {
                        case 276: {
                            ((TileEntityBasePump)this.base).setEnergy(5);
                            ((TileEntityBasePump)this.base).setPower(1);
                            break;
                        }
                        case 20: {
                            ((TileEntityBasePump)this.base).setEnergy(10);
                            ((TileEntityBasePump)this.base).setPower(2);
                            break;
                        }
                        case 96: {
                            ((TileEntityBasePump)this.base).setEnergy(20);
                            ((TileEntityBasePump)this.base).setPower(3);
                            break;
                        }
                        case 120: {
                            ((TileEntityBasePump)this.base).setEnergy(40);
                            ((TileEntityBasePump)this.base).setPower(4);
                        }
                    }
                }
                return content;
            }
        };
    }

    public ContainerHeatPump getGuiContainer(Player var1) {
        return new ContainerHeatPump(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiHeatPump((ContainerHeatPump)menu);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            if (this.getSlot().get(0).m_41619_()) {
                this.setEnergy(0);
                this.setPower(0);
            } else {
                int itemDamage = ((ISubEnum)((ItemCraftingElements)this.getSlot().get(0).m_41720_()).getElement()).getId();
                switch (itemDamage) {
                    case 276: {
                        this.setEnergy(5);
                        this.setPower(1);
                        break;
                    }
                    case 20: {
                        this.setEnergy(10);
                        this.setPower(2);
                        break;
                    }
                    case 96: {
                        this.setEnergy(20);
                        this.setPower(3);
                        break;
                    }
                    case 120: {
                        this.setEnergy(40);
                        this.setPower(4);
                    }
                }
            }
        }
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public int getBlockLevel() {
        return this.levelBlock;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    public void setPower(int power) {
        this.power = power;
    }

    @Override
    public InvSlot getSlot() {
        return this.slot;
    }
}

