/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.villager;

import com.denfop.IUItem;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.register.Register;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class VillagerInit {
    public static final RegistryObject<PoiType> ENGINEER_POI = VillagerInit.registerPoi("engineer", IUItem.programming_table.getObject(0));
    public static final RegistryObject<PoiType> MECHANIC_POI = VillagerInit.registerPoi("mechanic", IUItem.basemachine2.getObject(BlockBaseMachine3.generator_iu.getId()));
    public static final RegistryObject<PoiType> NUCLEAR_POI = VillagerInit.registerPoi("nuclear", IUItem.basemachine.getObject(10));
    public static final RegistryObject<PoiType> METALLURG_POI = VillagerInit.registerPoi("metallurg", IUItem.anvil.getObject(0));
    public static final RegistryObject<PoiType> CHEMIST_POI = VillagerInit.registerPoi("chemist", IUItem.fluidIntegrator.getObject(0));
    public static final RegistryObject<PoiType> BOTANIST_POI = VillagerInit.registerPoi("botanist", IUItem.apiary.getObject(0));
    public static final RegistryObject<VillagerProfession> ENGINEER = VillagerInit.registerProfession("engineer", ENGINEER_POI);
    public static final RegistryObject<VillagerProfession> MECHANIC = VillagerInit.registerProfession("mechanic", MECHANIC_POI);
    public static final RegistryObject<VillagerProfession> NUCLEAR = VillagerInit.registerProfession("nuclear", NUCLEAR_POI);
    public static final RegistryObject<VillagerProfession> METALLURG = VillagerInit.registerProfession("metallurg", METALLURG_POI);
    public static final RegistryObject<VillagerProfession> CHEMIST = VillagerInit.registerProfession("chemist", CHEMIST_POI);
    public static final RegistryObject<VillagerProfession> BOTANIST = VillagerInit.registerProfession("botanist", BOTANIST_POI);

    private static RegistryObject<PoiType> registerPoi(String name, RegistryObject<? extends Block> block) {
        return Register.POI_TYPE.register(name, () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((Block)block.get()).m_49965_().m_61056_()), 1, 1));
    }

    private static RegistryObject<VillagerProfession> registerProfession(String name, RegistryObject<PoiType> poiType) {
        return Register.VILLAGER_PROFESSIONS.register(name, () -> new VillagerProfession(name, poiTypeHolder -> poiTypeHolder.m_203334_() == poiType.get(), poiTypeHolder -> poiTypeHolder.m_203334_() == poiType.get(), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12510_));
    }

    public static void init() {
    }
}

